/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.api.core.BetaApi;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.transfermanager.DefaultQos;
import com.google.cloud.storage.transfermanager.Qos;
import com.google.cloud.storage.transfermanager.TransferManager;
import com.google.cloud.storage.transfermanager.TransferManagerImpl;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@BetaApi
public final class TransferManagerConfig {
    private final int maxWorkers;
    private final int perWorkerBufferSize;
    private final boolean allowDivideAndConquer;
    private final StorageOptions storageOptions;
    private final Qos qos;

    TransferManagerConfig(int maxWorkers, int perWorkerBufferSize, boolean allowDivideAndConquer, StorageOptions storageOptions, Qos qos) {
        this.maxWorkers = maxWorkers;
        this.perWorkerBufferSize = perWorkerBufferSize;
        this.allowDivideAndConquer = allowDivideAndConquer;
        this.storageOptions = storageOptions;
        this.qos = qos;
    }

    @BetaApi
    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    @BetaApi
    public int getPerWorkerBufferSize() {
        return this.perWorkerBufferSize;
    }

    @BetaApi
    public boolean isAllowDivideAndConquer() {
        return this.allowDivideAndConquer;
    }

    @BetaApi
    public StorageOptions getStorageOptions() {
        return this.storageOptions;
    }

    @BetaApi
    public TransferManager getService() {
        return new TransferManagerImpl(this);
    }

    @BetaApi
    public Builder toBuilder() {
        return new Builder().setAllowDivideAndConquer(this.allowDivideAndConquer).setMaxWorkers(this.maxWorkers).setPerWorkerBufferSize(this.perWorkerBufferSize).setQos(this.qos).setStorageOptions(this.storageOptions);
    }

    Qos getQos() {
        return this.qos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransferManagerConfig)) {
            return false;
        }
        TransferManagerConfig that = (TransferManagerConfig)o;
        return this.maxWorkers == that.maxWorkers && this.perWorkerBufferSize == that.perWorkerBufferSize && this.allowDivideAndConquer == that.allowDivideAndConquer && Objects.equals(this.storageOptions, that.storageOptions);
    }

    public int hashCode() {
        return Objects.hash(this.maxWorkers, this.perWorkerBufferSize, this.allowDivideAndConquer, this.storageOptions);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("maxWorkers", this.maxWorkers).add("perWorkerBufferSize", this.perWorkerBufferSize).add("allowChunking", this.allowDivideAndConquer).add("storageOptions", this.storageOptions).toString();
    }

    @BetaApi
    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi
    public static class Builder {
        private int maxWorkers = 2 * Runtime.getRuntime().availableProcessors();
        private int perWorkerBufferSize = 0x1000000;
        private boolean allowDivideAndConquer = false;
        private StorageOptions storageOptions = StorageOptions.getDefaultInstance();
        private Qos qos = DefaultQos.of();

        private Builder() {
        }

        @BetaApi
        public Builder setMaxWorkers(int maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        @BetaApi
        public Builder setPerWorkerBufferSize(int perWorkerBufferSize) {
            this.perWorkerBufferSize = perWorkerBufferSize;
            return this;
        }

        @BetaApi
        public Builder setAllowDivideAndConquer(boolean allowDivideAndConquer) {
            this.allowDivideAndConquer = allowDivideAndConquer;
            return this;
        }

        @BetaApi
        public Builder setStorageOptions(StorageOptions storageOptions) {
            this.storageOptions = storageOptions;
            return this;
        }

        @BetaApi
        Builder setQos(Qos qos) {
            this.qos = qos;
            return this;
        }

        @BetaApi
        public TransferManagerConfig build() {
            return new TransferManagerConfig(this.maxWorkers, this.perWorkerBufferSize, this.allowDivideAndConquer, this.storageOptions, this.qos);
        }
    }
}

