/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.calcite.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.calcite.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcCallFinder;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCorrelateSplitRule;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="RemoteCorrelateSplitRule", generator="Immutables")
public final class ImmutableRemoteCorrelateSplitRule {
    private ImmutableRemoteCorrelateSplitRule() {
    }

    @CheckReturnValue
    @Generated(from="RemoteCorrelateSplitRule.Config", generator="Immutables")
    @Immutable
    public static final class Config
    implements RemoteCorrelateSplitRule.Config {
        private final RelBuilderFactory relBuilderFactory;
        @Nullable
        private final String description;
        private final RelRule.OperandTransform operandSupplier;
        private final RemoteCalcCallFinder callFinder;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Config(Builder builder) {
            this.description = builder.description;
            this.callFinder = builder.callFinder;
            if (builder.relBuilderFactory != null) {
                this.initShim.relBuilderFactory(builder.relBuilderFactory);
            }
            if (builder.operandSupplier != null) {
                this.initShim.operandSupplier(builder.operandSupplier);
            }
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.initShim = null;
        }

        private Config(RelBuilderFactory relBuilderFactory, @Nullable String description, RelRule.OperandTransform operandSupplier, RemoteCalcCallFinder callFinder) {
            this.relBuilderFactory = relBuilderFactory;
            this.description = description;
            this.operandSupplier = operandSupplier;
            this.callFinder = callFinder;
            this.initShim = null;
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return RemoteCorrelateSplitRule.Config.super.relBuilderFactory();
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return RemoteCorrelateSplitRule.Config.super.operandSupplier();
        }

        @Override
        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        @Override
        @Nullable
        public String description() {
            return this.description;
        }

        @Override
        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        @Override
        public RemoteCalcCallFinder callFinder() {
            return this.callFinder;
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return new Config(newValue, this.description, this.operandSupplier, this.callFinder);
        }

        @Override
        public final Config withDescription(@Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new Config(this.relBuilderFactory, value, this.operandSupplier, this.callFinder);
        }

        @Override
        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return new Config(this.relBuilderFactory, this.description, newValue, this.callFinder);
        }

        public final Config withCallFinder(RemoteCalcCallFinder value) {
            if (this.callFinder == value) {
                return this;
            }
            RemoteCalcCallFinder newValue = Objects.requireNonNull(value, "callFinder");
            return new Config(this.relBuilderFactory, this.description, this.operandSupplier, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier) && this.callFinder.equals(another.callFinder);
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.relBuilderFactory.hashCode();
            h2 += (h2 << 5) + Objects.hashCode(this.description);
            h2 += (h2 << 5) + this.operandSupplier.hashCode();
            h2 += (h2 << 5) + this.callFinder.hashCode();
            return h2;
        }

        public String toString() {
            return MoreObjects.toStringHelper("Config").omitNullValues().add("relBuilderFactory", this.relBuilderFactory).add("description", this.description).add("operandSupplier", this.operandSupplier).add("callFinder", this.callFinder).toString();
        }

        public static Config copyOf(RemoteCorrelateSplitRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="RemoteCorrelateSplitRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_CALL_FINDER = 1L;
            private long initBits = 1L;
            @Nullable
            private RelBuilderFactory relBuilderFactory;
            @Nullable
            private String description;
            @Nullable
            private RelRule.OperandTransform operandSupplier;
            @Nullable
            private RemoteCalcCallFinder callFinder;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RemoteCorrelateSplitRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RelRule.Config instance;
                if (object instanceof RemoteCorrelateSplitRule.Config) {
                    instance = (RemoteCorrelateSplitRule.Config)object;
                    this.callFinder(instance.callFinder());
                }
                if (object instanceof RelRule.Config) {
                    instance = (RelRule.Config)object;
                    this.relBuilderFactory(instance.relBuilderFactory());
                    this.operandSupplier(instance.operandSupplier());
                    String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.description(descriptionValue);
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder relBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder description(@Nullable String description) {
                this.description = description;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder operandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder callFinder(RemoteCalcCallFinder callFinder) {
                this.callFinder = Objects.requireNonNull(callFinder, "callFinder");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Config build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Config(this);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("callFinder");
                }
                return "Cannot build Config, some of required attributes are not set " + String.valueOf(attributes);
            }
        }

        @Generated(from="RemoteCorrelateSplitRule.Config", generator="Immutables")
        private final class InitShim {
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;

            private InitShim() {
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void relBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void operandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                return "Cannot build Config, attribute initializers form cycle " + String.valueOf(attributes);
            }
        }
    }
}

