/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableFlinkRightJoinToLeftJoinRule;
import org.immutables.value.Value;

@Value.Enclosing
public class FlinkRightJoinToLeftJoinRule
extends RelRule<Config>
implements TransformationRule {
    public static final FlinkRightJoinToLeftJoinRule INSTANCE = Config.DEFAULT.toRule();

    public FlinkRightJoinToLeftJoinRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Join origJoin = (Join)call.rel(0);
        return origJoin.getJoinType() == JoinRelType.RIGHT;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join origJoin = (Join)call.rel(0);
        Object left = call.rel(1);
        Object right = call.rel(2);
        RexNode newCondition = this.shiftCondition(origJoin, (RelNode)left, (RelNode)right);
        Join leftJoin = origJoin.copy(origJoin.getTraitSet(), newCondition, (RelNode)right, (RelNode)left, JoinRelType.LEFT, false);
        RelBuilder relBuilder = call.builder();
        relBuilder.push(leftJoin);
        RelNode project = this.reorderProjectedFields((RelNode)left, (RelNode)right, relBuilder);
        call.transformTo(project);
    }

    private RelNode reorderProjectedFields(RelNode left, RelNode right, RelBuilder relBuilder) {
        int i;
        int nFieldsOnLeft = left.getRowType().getFieldList().size();
        int nFieldsOnRight = right.getRowType().getFieldList().size();
        ArrayList<RexInputRef> reorderedFields = new ArrayList<RexInputRef>();
        for (i = 0; i < nFieldsOnLeft; ++i) {
            reorderedFields.add(relBuilder.field(i + nFieldsOnRight));
        }
        for (i = 0; i < nFieldsOnRight; ++i) {
            reorderedFields.add(relBuilder.field(i));
        }
        return relBuilder.project(reorderedFields).build();
    }

    private RexNode shiftCondition(Join joinRel, RelNode left, RelNode right) {
        RexNode condition = joinRel.getCondition();
        int nFieldsOnLeft = left.getRowType().getFieldList().size();
        int nFieldsOnRight = right.getRowType().getFieldList().size();
        int[] adjustments = new int[nFieldsOnLeft + nFieldsOnRight];
        for (int i = 0; i < nFieldsOnLeft + nFieldsOnRight; ++i) {
            adjustments[i] = i < nFieldsOnLeft ? nFieldsOnRight : -nFieldsOnLeft;
        }
        return condition.accept(new RelOptUtil.RexInputConverter(joinRel.getCluster().getRexBuilder(), joinRel.getRowType().getFieldList(), adjustments));
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFlinkRightJoinToLeftJoinRule.Config.builder().build().as(Config.class).withOperandFor(LogicalJoin.class);

        @Override
        default public FlinkRightJoinToLeftJoinRule toRule() {
            return new FlinkRightJoinToLeftJoinRule(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(joinClass).inputs(b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(RelNode.class).anyInputs())).as(Config.class);
        }
    }
}

