/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.util.Arrays;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.metadata.FlinkMetadata;
import org.apache.flink.table.planner.plan.stats.ValueInterval;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.planner.plan.trait.RelWindowProperties;
import org.apache.flink.util.Preconditions;

public class FlinkRelMetadataQuery
extends RelMetadataQuery {
    private static final Handlers HANDLERS = new Handlers();
    private FlinkMetadata.ColumnInterval.Handler columnIntervalHandler;
    private FlinkMetadata.FilteredColumnInterval.Handler filteredColumnInterval;
    private FlinkMetadata.ColumnNullCount.Handler columnNullCountHandler;
    private FlinkMetadata.ColumnOriginNullCount.Handler columnOriginNullCountHandler;
    private FlinkMetadata.UniqueGroups.Handler uniqueGroupsHandler;
    private FlinkMetadata.FlinkDistribution.Handler distributionHandler;
    private FlinkMetadata.ModifiedMonotonicity.Handler modifiedMonotonicityHandler;
    private FlinkMetadata.WindowProperties.Handler windowPropertiesHandler;
    private FlinkMetadata.UpsertKeys.Handler upsertKeysHandler;

    public static FlinkRelMetadataQuery instance() {
        return new FlinkRelMetadataQuery();
    }

    public static FlinkRelMetadataQuery reuseOrCreate(RelMetadataQuery mq) {
        if (mq instanceof FlinkRelMetadataQuery) {
            return (FlinkRelMetadataQuery)mq;
        }
        return FlinkRelMetadataQuery.instance();
    }

    private FlinkRelMetadataQuery() {
        this.columnIntervalHandler = FlinkRelMetadataQuery.HANDLERS.columnIntervalHandler;
        this.filteredColumnInterval = FlinkRelMetadataQuery.HANDLERS.filteredColumnInterval;
        this.columnNullCountHandler = FlinkRelMetadataQuery.HANDLERS.columnNullCountHandler;
        this.columnOriginNullCountHandler = FlinkRelMetadataQuery.HANDLERS.columnOriginNullCountHandler;
        this.uniqueGroupsHandler = FlinkRelMetadataQuery.HANDLERS.uniqueGroupsHandler;
        this.distributionHandler = FlinkRelMetadataQuery.HANDLERS.distributionHandler;
        this.modifiedMonotonicityHandler = FlinkRelMetadataQuery.HANDLERS.modifiedMonotonicityHandler;
        this.windowPropertiesHandler = FlinkRelMetadataQuery.HANDLERS.windowPropertiesHandler;
        this.upsertKeysHandler = FlinkRelMetadataQuery.HANDLERS.upsertKeysHandler;
    }

    public ValueInterval getColumnInterval(RelNode rel, int index) {
        while (true) {
            try {
                return this.columnIntervalHandler.getColumnInterval(rel, this, index);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.columnIntervalHandler = (FlinkMetadata.ColumnInterval.Handler)this.revise(e.relClass, FlinkMetadata.ColumnInterval.DEF);
                continue;
            }
            break;
        }
    }

    public ValueInterval getFilteredColumnInterval(RelNode rel, int columnIndex, int filterArg) {
        while (true) {
            try {
                return this.filteredColumnInterval.getFilteredColumnInterval(rel, this, columnIndex, filterArg);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.filteredColumnInterval = (FlinkMetadata.FilteredColumnInterval.Handler)this.revise(e.relClass, FlinkMetadata.FilteredColumnInterval.DEF);
                continue;
            }
            break;
        }
    }

    public Double getColumnNullCount(RelNode rel, int index) {
        while (true) {
            try {
                return this.columnNullCountHandler.getColumnNullCount(rel, this, index);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.columnNullCountHandler = (FlinkMetadata.ColumnNullCount.Handler)this.revise(e.relClass, FlinkMetadata.ColumnNullCount.DEF);
                continue;
            }
            break;
        }
    }

    public Double getColumnOriginNullCount(RelNode rel, int index) {
        while (true) {
            try {
                return this.columnOriginNullCountHandler.getColumnOriginNullCount(rel, this, index);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.columnOriginNullCountHandler = (FlinkMetadata.ColumnOriginNullCount.Handler)this.revise(e.relClass, FlinkMetadata.ColumnOriginNullCount.DEF);
                continue;
            }
            break;
        }
    }

    public ImmutableBitSet getUniqueGroups(RelNode rel, ImmutableBitSet columns) {
        while (true) {
            try {
                Preconditions.checkArgument((columns != null ? 1 : 0) != 0);
                if (columns.isEmpty()) {
                    return columns;
                }
                ImmutableBitSet uniqueGroups = this.uniqueGroupsHandler.getUniqueGroups(rel, this, columns);
                Preconditions.checkArgument((uniqueGroups != null && !uniqueGroups.isEmpty() ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)columns.contains(uniqueGroups));
                return uniqueGroups;
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.uniqueGroupsHandler = (FlinkMetadata.UniqueGroups.Handler)this.revise(e.relClass, FlinkMetadata.UniqueGroups.DEF);
                continue;
            }
            break;
        }
    }

    public FlinkRelDistribution flinkDistribution(RelNode rel) {
        while (true) {
            try {
                return this.distributionHandler.flinkDistribution(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.distributionHandler = (FlinkMetadata.FlinkDistribution.Handler)this.revise(e.relClass, FlinkMetadata.FlinkDistribution.DEF);
                continue;
            }
            break;
        }
    }

    public RelModifiedMonotonicity getRelModifiedMonotonicity(RelNode rel) {
        while (true) {
            try {
                return this.modifiedMonotonicityHandler.getRelModifiedMonotonicity(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.modifiedMonotonicityHandler = (FlinkMetadata.ModifiedMonotonicity.Handler)this.revise(e.relClass, FlinkMetadata.ModifiedMonotonicity.DEF);
                continue;
            }
            break;
        }
    }

    public RelWindowProperties getRelWindowProperties(RelNode rel) {
        while (true) {
            try {
                return this.windowPropertiesHandler.getWindowProperties(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.windowPropertiesHandler = (FlinkMetadata.WindowProperties.Handler)this.revise(e.relClass, FlinkMetadata.WindowProperties.DEF);
                continue;
            }
            break;
        }
    }

    public Set<ImmutableBitSet> getUpsertKeys(RelNode rel) {
        while (true) {
            try {
                return this.upsertKeysHandler.getUpsertKeys(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.upsertKeysHandler = (FlinkMetadata.UpsertKeys.Handler)this.revise(e.relClass, FlinkMetadata.UpsertKeys.DEF);
                continue;
            }
            break;
        }
    }

    public Set<ImmutableBitSet> getUpsertKeysInKeyGroupRange(RelNode rel, int[] partitionKeys) {
        Exchange exchange;
        if (rel instanceof Exchange && Arrays.equals((exchange = (Exchange)rel).getDistribution().getKeys().stream().mapToInt(Integer::intValue).toArray(), partitionKeys)) {
            rel = exchange.getInput();
        }
        return this.getUpsertKeys(rel);
    }

    static /* synthetic */ Object access$000(Class x0) {
        return FlinkRelMetadataQuery.initialHandler(x0);
    }

    static /* synthetic */ Object access$100(Class x0) {
        return FlinkRelMetadataQuery.initialHandler(x0);
    }

    static /* synthetic */ Object access$200(Class x0) {
        return FlinkRelMetadataQuery.initialHandler(x0);
    }

    static /* synthetic */ Object access$300(Class x0) {
        return FlinkRelMetadataQuery.initialHandler(x0);
    }

    static /* synthetic */ Object access$400(Class x0) {
        return FlinkRelMetadataQuery.initialHandler(x0);
    }

    static /* synthetic */ Object access$500(Class x0) {
        return FlinkRelMetadataQuery.initialHandler(x0);
    }

    static /* synthetic */ Object access$600(Class x0) {
        return FlinkRelMetadataQuery.initialHandler(x0);
    }

    static /* synthetic */ Object access$700(Class x0) {
        return FlinkRelMetadataQuery.initialHandler(x0);
    }

    static /* synthetic */ Object access$800(Class x0) {
        return FlinkRelMetadataQuery.initialHandler(x0);
    }

    private static class Handlers {
        private FlinkMetadata.ColumnInterval.Handler columnIntervalHandler = (FlinkMetadata.ColumnInterval.Handler)FlinkRelMetadataQuery.access$000(FlinkMetadata.ColumnInterval.Handler.class);
        private FlinkMetadata.FilteredColumnInterval.Handler filteredColumnInterval = (FlinkMetadata.FilteredColumnInterval.Handler)FlinkRelMetadataQuery.access$100(FlinkMetadata.FilteredColumnInterval.Handler.class);
        private FlinkMetadata.ColumnNullCount.Handler columnNullCountHandler = (FlinkMetadata.ColumnNullCount.Handler)FlinkRelMetadataQuery.access$200(FlinkMetadata.ColumnNullCount.Handler.class);
        private FlinkMetadata.ColumnOriginNullCount.Handler columnOriginNullCountHandler = (FlinkMetadata.ColumnOriginNullCount.Handler)FlinkRelMetadataQuery.access$300(FlinkMetadata.ColumnOriginNullCount.Handler.class);
        private FlinkMetadata.UniqueGroups.Handler uniqueGroupsHandler = (FlinkMetadata.UniqueGroups.Handler)FlinkRelMetadataQuery.access$400(FlinkMetadata.UniqueGroups.Handler.class);
        private FlinkMetadata.FlinkDistribution.Handler distributionHandler = (FlinkMetadata.FlinkDistribution.Handler)FlinkRelMetadataQuery.access$500(FlinkMetadata.FlinkDistribution.Handler.class);
        private FlinkMetadata.ModifiedMonotonicity.Handler modifiedMonotonicityHandler = (FlinkMetadata.ModifiedMonotonicity.Handler)FlinkRelMetadataQuery.access$600(FlinkMetadata.ModifiedMonotonicity.Handler.class);
        private FlinkMetadata.WindowProperties.Handler windowPropertiesHandler = (FlinkMetadata.WindowProperties.Handler)FlinkRelMetadataQuery.access$700(FlinkMetadata.WindowProperties.Handler.class);
        private FlinkMetadata.UpsertKeys.Handler upsertKeysHandler = (FlinkMetadata.UpsertKeys.Handler)FlinkRelMetadataQuery.access$800(FlinkMetadata.UpsertKeys.Handler.class);

        private Handlers() {
        }
    }
}

