/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.sql.parser.ddl.SqlAddPartitions;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AddPartitionsOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.utils.OperationConverterUtils;

public class SqlAlterTableAddPartitionConverter
implements SqlNodeConverter<SqlAddPartitions> {
    @Override
    public Operation convertSqlNode(SqlAddPartitions sqlAddPartitions, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlAddPartitions.fullTableName());
        ObjectIdentifier tableIdentifier = context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        ArrayList<CatalogPartitionSpec> specs = new ArrayList<CatalogPartitionSpec>();
        ArrayList<CatalogPartitionImpl> partitions = new ArrayList<CatalogPartitionImpl>();
        for (int i = 0; i < sqlAddPartitions.getPartSpecs().size(); ++i) {
            specs.add(new CatalogPartitionSpec(sqlAddPartitions.getPartitionKVs(i)));
            Map<String, String> props = OperationConverterUtils.extractProperties(sqlAddPartitions.getPartProps().get(i));
            partitions.add(new CatalogPartitionImpl(props, null));
        }
        return new AddPartitionsOperation(tableIdentifier, sqlAddPartitions.ifPartitionNotExists(), specs, partitions);
    }
}

