/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;

public class SchemaBuilderUtil {
    final SqlValidator sqlValidator;
    final Function<SqlNode, String> escapeExpressions;
    final DataTypeFactory dataTypeFactory;
    protected Map<String, Schema.UnresolvedColumn> columns = new LinkedHashMap<String, Schema.UnresolvedColumn>();
    Map<String, Schema.UnresolvedWatermarkSpec> watermarkSpecs = new HashMap<String, Schema.UnresolvedWatermarkSpec>();
    Schema.UnresolvedPrimaryKey primaryKey = null;

    protected SchemaBuilderUtil(SqlValidator sqlValidator, Function<SqlNode, String> escapeExpressions, DataTypeFactory dataTypeFactory) {
        this.sqlValidator = sqlValidator;
        this.escapeExpressions = escapeExpressions;
        this.dataTypeFactory = dataTypeFactory;
    }

    void setPrimaryKey(SqlTableConstraint primaryKeyConstraint) {
        if (this.primaryKey != null) {
            throw new ValidationException("There already exists a primary key constraint in the table.");
        }
        for (SqlNode primaryKeyNode : primaryKeyConstraint.getColumns()) {
            String primaryKey = ((SqlIdentifier)primaryKeyNode).getSimple();
            if (!this.columns.containsKey(primaryKey)) {
                throw new ValidationException(String.format("Primary key column '%s' is not defined in the schema at %s", primaryKey, primaryKeyNode.getParserPosition()));
            }
            if (this.columns.get(primaryKey) instanceof Schema.UnresolvedPhysicalColumn) continue;
            throw new ValidationException(String.format("Could not create a PRIMARY KEY with column '%s' at %s.\nA PRIMARY KEY constraint must be declared on physical columns.", primaryKey, primaryKeyNode.getParserPosition()));
        }
        this.primaryKey = this.toUnresolvedPrimaryKey(primaryKeyConstraint);
    }

    void addWatermarks(List<SqlWatermark> derivedWatermarkSpecs, Map<String, RelDataType> allFieldsTypes, boolean overwriteWatermark) {
        for (SqlWatermark derivedWatermarkSpec : derivedWatermarkSpecs) {
            SqlIdentifier eventTimeColumnName = derivedWatermarkSpec.getEventTimeColumnName();
            String rowtimeAttribute = eventTimeColumnName.toString();
            if (!overwriteWatermark && this.watermarkSpecs.containsKey(rowtimeAttribute)) {
                throw new ValidationException(String.format("There already exists a watermark on column '%s'.", rowtimeAttribute));
            }
            SchemaBuilderUtil.verifyRowtimeAttribute(derivedWatermarkSpec, allFieldsTypes);
            this.watermarkSpecs.put(rowtimeAttribute, this.toUnresolvedWatermarkSpec(derivedWatermarkSpec, allFieldsTypes));
        }
    }

    public Schema build() {
        Schema.Builder resultBuilder = Schema.newBuilder();
        resultBuilder.fromColumns(new ArrayList<Schema.UnresolvedColumn>(this.columns.values()));
        for (Schema.UnresolvedWatermarkSpec watermarkSpec : this.watermarkSpecs.values()) {
            resultBuilder.watermark(watermarkSpec.getColumnName(), watermarkSpec.getWatermarkExpression());
        }
        if (this.primaryKey != null) {
            resultBuilder.primaryKeyNamed(this.primaryKey.getConstraintName(), this.primaryKey.getColumnNames().toArray(new String[0]));
        }
        return resultBuilder.build();
    }

    static void verifyRowtimeAttribute(SqlWatermark sqlWatermark, Map<String, RelDataType> allFieldsTypes) {
        SqlIdentifier eventTimeColumnName = sqlWatermark.getEventTimeColumnName();
        String fullRowtimeExpression = eventTimeColumnName.toString();
        ImmutableList<String> components = eventTimeColumnName.names;
        if (!allFieldsTypes.containsKey(components.get(0))) {
            throw new ValidationException(String.format("The rowtime attribute field '%s' is not defined in the table schema, at %s\nAvailable fields: [%s]", fullRowtimeExpression, eventTimeColumnName.getParserPosition(), allFieldsTypes.keySet().stream().collect(Collectors.joining("', '", "'", "'"))));
        }
        if (components.size() > 1) {
            RelDataType componentType = allFieldsTypes.get(components.get(0));
            for (int i = 1; i < components.size(); ++i) {
                RelDataTypeField field = componentType.getField((String)components.get(i), true, false);
                if (field == null) {
                    throw new ValidationException(String.format("The rowtime attribute field '%s' is not defined in the table schema, at %s\nNested field '%s' was not found in a composite type: %s.", fullRowtimeExpression, eventTimeColumnName.getComponent(i).getParserPosition(), components.get(i), FlinkTypeFactory.toLogicalType(allFieldsTypes.get(components.get(0)))));
                }
                componentType = field.getType();
            }
        }
    }

    protected Schema.UnresolvedPhysicalColumn toUnresolvedPhysicalColumn(SqlTableColumn.SqlRegularColumn column) {
        String name = column.getName().getSimple();
        Optional<String> comment = this.getComment(column);
        LogicalType logicalType = FlinkTypeFactory.toLogicalType(this.toRelDataType(column.getType()));
        return new Schema.UnresolvedPhysicalColumn(name, (AbstractDataType)TypeConversions.fromLogicalToDataType((LogicalType)logicalType), (String)comment.orElse(null));
    }

    Schema.UnresolvedComputedColumn toUnresolvedComputedColumn(SqlTableColumn.SqlComputedColumn column, SqlNode validatedExpression) {
        String name = column.getName().getSimple();
        Optional<String> comment = this.getComment(column);
        return new Schema.UnresolvedComputedColumn(name, (Expression)new SqlCallExpression(this.escapeExpressions.apply(validatedExpression)), (String)comment.orElse(null));
    }

    Schema.UnresolvedMetadataColumn toUnresolvedMetadataColumn(SqlTableColumn.SqlMetadataColumn column) {
        String name = column.getName().getSimple();
        Optional<String> comment = this.getComment(column);
        LogicalType logicalType = FlinkTypeFactory.toLogicalType(this.toRelDataType(column.getType()));
        return new Schema.UnresolvedMetadataColumn(name, (AbstractDataType)TypeConversions.fromLogicalToDataType((LogicalType)logicalType), (String)column.getMetadataAlias().orElse(null), column.isVirtual(), (String)comment.orElse(null));
    }

    Schema.UnresolvedWatermarkSpec toUnresolvedWatermarkSpec(SqlWatermark watermark, Map<String, RelDataType> accessibleFieldNamesToTypes) {
        SqlNode validated = this.sqlValidator.validateParameterizedExpression(watermark.getWatermarkStrategy(), accessibleFieldNamesToTypes);
        return new Schema.UnresolvedWatermarkSpec(watermark.getEventTimeColumnName().toString(), (Expression)new SqlCallExpression(this.escapeExpressions.apply(validated)));
    }

    public Schema.UnresolvedPrimaryKey toUnresolvedPrimaryKey(SqlTableConstraint primaryKey) {
        List columnNames = primaryKey.getColumns().getList().stream().map(n -> ((SqlIdentifier)n).getSimple()).collect(Collectors.toList());
        String constraintName = primaryKey.getConstraintName().orElseGet(() -> columnNames.stream().collect(Collectors.joining("_", "PK_", "")));
        return new Schema.UnresolvedPrimaryKey(constraintName, columnNames);
    }

    LogicalType getLogicalType(Schema.UnresolvedPhysicalColumn column) {
        return this.dataTypeFactory.createDataType(column.getDataType()).getLogicalType();
    }

    LogicalType getLogicalType(Schema.UnresolvedMetadataColumn column) {
        return this.dataTypeFactory.createDataType(column.getDataType()).getLogicalType();
    }

    Optional<String> getComment(SqlTableColumn column) {
        return column.getComment().map(c -> ((SqlLiteral)c).getValueAs(String.class));
    }

    RelDataType toRelDataType(SqlDataTypeSpec type) {
        boolean nullable = type.getNullable() == null || type.getNullable() != false;
        return type.deriveType(this.sqlValidator, nullable);
    }
}

