/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.ConstructedToConstructedCastRule;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;

class MapToMapAndMultisetToMultisetCastRule
extends AbstractNullAwareCodeGeneratorCastRule<MapData, MapData>
implements ConstructedToConstructedCastRule<MapData, MapData> {
    static final MapToMapAndMultisetToMultisetCastRule INSTANCE = new MapToMapAndMultisetToMultisetCastRule();

    private MapToMapAndMultisetToMultisetCastRule() {
        super(CastRulePredicate.builder().predicate(MapToMapAndMultisetToMultisetCastRule::isValidMapToMapOrMultisetToMultisetCasting).build());
    }

    private static boolean isValidMapToMapOrMultisetToMultisetCasting(LogicalType input, LogicalType target) {
        return input.is(LogicalTypeRoot.MAP) && target.is(LogicalTypeRoot.MAP) && CastRuleProvider.resolve(((MapType)input).getKeyType(), ((MapType)target).getKeyType()) != null && CastRuleProvider.resolve(((MapType)input).getValueType(), ((MapType)target).getValueType()) != null || input.is(LogicalTypeRoot.MULTISET) && target.is(LogicalTypeRoot.MULTISET) && CastRuleProvider.resolve(((MultisetType)input).getElementType(), ((MultisetType)target).getElementType()) != null;
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        LogicalType innerTargetValueType;
        LogicalType innerTargetKeyType;
        LogicalType innerInputValueType;
        LogicalType innerInputKeyType;
        if (inputLogicalType.is(LogicalTypeRoot.MULTISET)) {
            innerInputKeyType = ((MultisetType)inputLogicalType).getElementType();
            innerInputValueType = new IntType(false);
            innerTargetKeyType = ((MultisetType)targetLogicalType).getElementType();
            innerTargetValueType = new IntType(false);
        } else {
            innerInputKeyType = ((MapType)inputLogicalType).getKeyType();
            innerInputValueType = ((MapType)inputLogicalType).getValueType();
            innerTargetKeyType = ((MapType)targetLogicalType).getKeyType();
            innerTargetValueType = ((MapType)targetLogicalType).getValueType();
        }
        CodeGeneratorContext codeGeneratorContext = context.getCodeGeneratorContext();
        String innerTargetKeyTypeTerm = CodeGenUtils.boxedTypeTermForType(innerTargetKeyType);
        String innerTargetValueTypeTerm = CodeGenUtils.boxedTypeTermForType(innerTargetValueType);
        String keyArrayTerm = CastRuleUtils.methodCall(inputTerm, "keyArray", new Object[0]);
        String valueArrayTerm = CastRuleUtils.methodCall(inputTerm, "valueArray", new Object[0]);
        String size = CastRuleUtils.methodCall(inputTerm, "size", new Object[0]);
        String map = CodeGenUtils.newName(codeGeneratorContext, "map");
        String key = CodeGenUtils.newName(codeGeneratorContext, "key");
        String value = CodeGenUtils.newName(codeGeneratorContext, "value");
        return new CastRuleUtils.CodeWriter().declStmt(CodeGenUtils.className(Map.class), map, CastRuleUtils.constructorCall(HashMap.class, new Object[0])).forStmt(size, (index, codeWriter) -> {
            CastCodeBlock keyCodeBlock = CastRuleProvider.generateAlwaysNonNullCodeBlock(context, CodeGenUtils.rowFieldReadAccess(index, keyArrayTerm, innerInputKeyType), innerInputKeyType, innerTargetKeyType);
            assert (keyCodeBlock != null);
            CastCodeBlock valueCodeBlock = CastRuleProvider.generateAlwaysNonNullCodeBlock(context, CodeGenUtils.rowFieldReadAccess(index, valueArrayTerm, innerInputValueType), innerInputValueType, innerTargetValueType);
            assert (valueCodeBlock != null);
            codeWriter.declStmt(innerTargetKeyTypeTerm, key, null).declStmt(innerTargetValueTypeTerm, value, null);
            if (innerTargetKeyType.isNullable()) {
                codeWriter.ifStmt("!" + CastRuleUtils.methodCall(keyArrayTerm, "isNullAt", index), thenWriter -> thenWriter.append(keyCodeBlock).assignStmt(key, keyCodeBlock.getReturnTerm()));
            } else {
                codeWriter.append(keyCodeBlock).assignStmt(key, keyCodeBlock.getReturnTerm());
            }
            if (inputLogicalType.is(LogicalTypeRoot.MAP) && innerTargetValueType.isNullable()) {
                codeWriter.ifStmt("!" + CastRuleUtils.methodCall(valueArrayTerm, "isNullAt", index), thenWriter -> thenWriter.append(valueCodeBlock).assignStmt(value, valueCodeBlock.getReturnTerm()));
            } else {
                codeWriter.append(valueCodeBlock).assignStmt(value, valueCodeBlock.getReturnTerm());
            }
            codeWriter.stmt(CastRuleUtils.methodCall(map, "put", key, value));
        }, codeGeneratorContext).assignStmt(returnVariable, CastRuleUtils.constructorCall(GenericMapData.class, map)).toString();
    }
}

