/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.planner.catalog.CatalogSchemaModel;
import org.apache.flink.table.planner.catalog.DatabaseCalciteSchema;
import org.apache.flink.table.planner.catalog.FlinkSchema;

@Internal
public class CatalogCalciteSchema
extends FlinkSchema {
    private final String catalogName;
    private final CatalogManager catalogManager;
    private final boolean isStreamingMode;

    public CatalogCalciteSchema(String catalogName, CatalogManager catalog, boolean isStreamingMode) {
        this.catalogName = catalogName;
        this.catalogManager = catalog;
        this.isStreamingMode = isStreamingMode;
    }

    @Override
    public Schema getSubSchema(String schemaName) {
        if (this.catalogManager.schemaExists(this.catalogName, schemaName)) {
            if (this.getSchemaVersion().isPresent()) {
                return new DatabaseCalciteSchema(this.catalogName, schemaName, this.catalogManager, this.isStreamingMode).snapshot(this.getSchemaVersion().get());
            }
            return new DatabaseCalciteSchema(this.catalogName, schemaName, this.catalogManager, this.isStreamingMode);
        }
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return this.catalogManager.listSchemas(this.catalogName);
    }

    @Override
    public Table getTable(String name) {
        return null;
    }

    @Override
    public Set<String> getTableNames() {
        return new HashSet<String>();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Schemas.subSchemaExpression(parentSchema, name, this.getClass());
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public CatalogSchemaModel getModel(String name) {
        return null;
    }

    @Override
    public FlinkSchema copy() {
        return new CatalogCalciteSchema(this.catalogName, this.catalogManager, this.isStreamingMode);
    }
}

