/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate.implicit;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractTypeCoercion
implements TypeCoercion {
    protected SqlValidator validator;
    protected RelDataTypeFactory factory;

    AbstractTypeCoercion(RelDataTypeFactory typeFactory, SqlValidator validator) {
        this.factory = Objects.requireNonNull(typeFactory, "typeFactory");
        this.validator = Objects.requireNonNull(validator, "validator");
    }

    protected boolean coerceOperandType(@Nullable SqlValidatorScope scope, SqlCall call, int index, RelDataType targetType) {
        SqlNode operand;
        if (RelDataTypeFactoryImpl.isJavaType(targetType)) {
            targetType = ((JavaTypeFactory)this.factory).toSql(targetType);
        }
        if ((operand = call.getOperandList().get(index)) instanceof SqlDynamicParam) {
            return false;
        }
        Objects.requireNonNull(scope, "scope");
        RelDataType operandType = this.validator.deriveType(scope, operand);
        if (this.coerceStringToArray(call, operand, index, operandType, targetType).booleanValue()) {
            return true;
        }
        if (!this.needToCast(scope, operand, targetType)) {
            return false;
        }
        RelDataType targetType1 = this.syncAttributes(operandType, targetType);
        SqlNode desired = AbstractTypeCoercion.castTo(operand, targetType1);
        call.setOperand(index, desired);
        this.updateInferredType(desired, targetType1);
        return true;
    }

    protected boolean coerceOperandsType(@Nullable SqlValidatorScope scope, SqlCall call, RelDataType commonType) {
        boolean coerced = false;
        for (int i = 0; i < call.operandCount(); ++i) {
            coerced = this.coerceOperandType(scope, call, i, commonType) || coerced;
        }
        return coerced;
    }

    protected boolean coerceColumnType(@Nullable SqlValidatorScope scope, SqlNodeList nodeList, int index, RelDataType targetType) {
        if (RelDataTypeFactoryImpl.isJavaType(targetType)) {
            targetType = ((JavaTypeFactory)this.factory).toSql(targetType);
        }
        if (index >= nodeList.size()) {
            return true;
        }
        SqlNode node = nodeList.get(index);
        if (node instanceof SqlDynamicParam) {
            return false;
        }
        if (node instanceof SqlIdentifier) {
            SqlIdentifier node1 = (SqlIdentifier)node;
            if (node1.isStar()) {
                return true;
            }
            if (DynamicRecordType.isDynamicStarColName(Util.last(node1.names))) {
                return false;
            }
        }
        Objects.requireNonNull(scope, "scope is needed for needToCast(scope, operand, targetType)");
        if (node instanceof SqlCall) {
            SqlCall node2 = (SqlCall)node;
            if (node2.getOperator().kind == SqlKind.AS) {
                Object operand = node2.operand(0);
                if (!this.needToCast(scope, (SqlNode)operand, targetType)) {
                    return false;
                }
                RelDataType targetType2 = this.syncAttributes(this.validator.deriveType(scope, (SqlNode)operand), targetType);
                SqlNode casted = AbstractTypeCoercion.castTo(operand, targetType2);
                node2.setOperand(0, casted);
                this.updateInferredType(casted, targetType2);
                return true;
            }
        }
        if (!this.needToCast(scope, node, targetType)) {
            return false;
        }
        RelDataType targetType3 = this.syncAttributes(this.validator.deriveType(scope, node), targetType);
        SqlNode node3 = AbstractTypeCoercion.castTo(node, targetType3);
        nodeList.set(index, node3);
        this.updateInferredType(node3, targetType3);
        return true;
    }

    RelDataType syncAttributes(RelDataType fromType, RelDataType toType) {
        RelDataType syncedType = toType;
        if (fromType != null) {
            Charset charset;
            syncedType = this.factory.createTypeWithNullability(syncedType, fromType.isNullable());
            if (SqlTypeUtil.inCharOrBinaryFamilies(fromType) && SqlTypeUtil.inCharOrBinaryFamilies(toType) && (charset = fromType.getCharset()) != null && SqlTypeUtil.inCharFamily(syncedType)) {
                SqlCollation collation = NonNullableAccessors.getCollation(fromType);
                syncedType = this.factory.createTypeWithCharsetAndCollation(syncedType, charset, collation);
            }
        }
        return syncedType;
    }

    protected boolean needToCast(SqlValidatorScope scope, SqlNode node, RelDataType toType) {
        RelDataType fromType = this.validator.deriveType(scope, node);
        if (fromType == null) {
            return false;
        }
        if (fromType instanceof RelDataTypeFactoryImpl.JavaType && toType.getSqlTypeName() == fromType.getSqlTypeName()) {
            return false;
        }
        if (toType.getSqlTypeName() == SqlTypeName.ANY || fromType.getSqlTypeName() == SqlTypeName.ANY) {
            return false;
        }
        if (SqlTypeUtil.isCharacter(toType) && SqlTypeUtil.isCharacter(fromType)) {
            return false;
        }
        if (fromType.getPrecedenceList().containsType(toType) && SqlTypeUtil.isIntType(fromType) && SqlTypeUtil.isIntType(toType)) {
            return false;
        }
        if (SqlTypeUtil.equalSansNullability(this.factory, fromType, toType)) {
            return false;
        }
        assert (SqlTypeUtil.canCastFrom(toType, fromType, true));
        return true;
    }

    private static SqlNode castTo(SqlNode node, RelDataType type) {
        return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, node, SqlTypeUtil.convertTypeToSpec(type).withNullable(type.isNullable()));
    }

    protected void updateInferredType(SqlNode node, RelDataType type) {
        this.validator.setValidatedNodeType(node, type);
        SqlValidatorNamespace namespace = this.validator.getNamespace(node);
        if (namespace != null) {
            namespace.setType(type);
        }
    }

    protected void updateInferredColumnType(SqlValidatorScope scope, SqlNode query, int columnIndex, RelDataType desiredType) {
        RelDataType rowType = this.validator.deriveType(scope, query);
        assert (rowType.isStruct());
        assert (columnIndex < rowType.getFieldList().size());
        ArrayList<Pair<String, RelDataType>> fieldList = new ArrayList<Pair<String, RelDataType>>();
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            RelDataTypeField field = rowType.getFieldList().get(i);
            String name = field.getName();
            RelDataType type = field.getType();
            RelDataType targetType = i == columnIndex ? desiredType : type;
            fieldList.add(Pair.of(name, targetType));
        }
        this.updateInferredType(query, this.factory.createStructType(fieldList));
    }

    @Override
    public @Nullable RelDataType getTightestCommonType(@Nullable RelDataType type1, @Nullable RelDataType type2) {
        if (type1 == null || type2 == null) {
            return null;
        }
        if (type1.equals(type2) || type1.isNullable() != type2.isNullable() && this.factory.createTypeWithNullability(type1, type2.isNullable()).equals(type2)) {
            return this.factory.createTypeWithNullability(type1, type1.isNullable() || type2.isNullable());
        }
        if (SqlTypeUtil.isNull(type1)) {
            return type2;
        }
        if (SqlTypeUtil.isNull(type2)) {
            return type1;
        }
        RelDataType resultType = null;
        if (SqlTypeUtil.isString(type1) && SqlTypeUtil.isString(type2)) {
            resultType = this.factory.leastRestrictive(ImmutableList.of(type1, type2));
        }
        if (SqlTypeUtil.isNumeric(type1) && SqlTypeUtil.isNumeric(type2) && !SqlTypeUtil.isDecimal(type1) && !SqlTypeUtil.isDecimal(type2)) {
            resultType = this.factory.leastRestrictive(ImmutableList.of(type1, type2));
        }
        if (SqlTypeUtil.isDate(type1) && SqlTypeUtil.isTimestamp(type2)) {
            resultType = type2;
        }
        if (SqlTypeUtil.isDate(type2) && SqlTypeUtil.isTimestamp(type1)) {
            resultType = type1;
        }
        if (type1.isStruct() && type2.isStruct() && SqlTypeUtil.equalAsStructSansNullability(this.factory, type1, type2, this.validator.getCatalogReader().nameMatcher())) {
            ArrayList<RelDataType> fields = new ArrayList<RelDataType>();
            List<String> fieldNames = type1.getFieldNames();
            for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(type1.getFieldList(), type2.getFieldList())) {
                RelDataType leftType = ((RelDataTypeField)pair.left).getType();
                RelDataType rightType = ((RelDataTypeField)pair.right).getType();
                RelDataType dataType = this.getTightestCommonTypeOrThrow(leftType, rightType);
                boolean isNullable = leftType.isNullable() || rightType.isNullable();
                fields.add(this.factory.createTypeWithNullability(dataType, isNullable));
            }
            return this.factory.createStructType(type1.getStructKind(), fields, fieldNames);
        }
        if (SqlTypeUtil.isArray(type1) && SqlTypeUtil.isArray(type2) && SqlTypeUtil.equalSansNullability(this.factory, type1, type2)) {
            resultType = this.factory.createTypeWithNullability(type1, type1.isNullable() || type2.isNullable());
        }
        if (SqlTypeUtil.isMap(type1) && SqlTypeUtil.isMap(type2) && SqlTypeUtil.equalSansNullability(this.factory, type1, type2)) {
            RelDataType keyType = this.getTightestCommonTypeOrThrow(type1.getKeyType(), type2.getKeyType());
            RelDataType valType = this.getTightestCommonTypeOrThrow(type1.getValueType(), type2.getValueType());
            resultType = this.factory.createMapType(keyType, valType);
        }
        return resultType;
    }

    private RelDataType getTightestCommonTypeOrThrow(@Nullable RelDataType type1, @Nullable RelDataType type2) {
        return Objects.requireNonNull(this.getTightestCommonType(type1, type2), () -> "expected non-null getTightestCommonType for " + type1 + " and " + type2);
    }

    private @Nullable RelDataType promoteToVarChar(@Nullable RelDataType type1, @Nullable RelDataType type2) {
        RelDataType resultType = null;
        if (type1 == null || type2 == null) {
            return null;
        }
        if (SqlTypeUtil.isCharacter(type1) && SqlTypeUtil.isCharacter(type2)) {
            return null;
        }
        if (SqlTypeUtil.isAtomic(type1) && SqlTypeUtil.isCharacter(type2)) {
            resultType = this.factory.createSqlType(SqlTypeName.VARCHAR);
        }
        if (SqlTypeUtil.isCharacter(type1) && SqlTypeUtil.isAtomic(type2)) {
            resultType = this.factory.createSqlType(SqlTypeName.VARCHAR);
        }
        return resultType;
    }

    @Override
    public @Nullable RelDataType commonTypeForBinaryComparison(@Nullable RelDataType type1, @Nullable RelDataType type2) {
        if (type1 == null || type2 == null) {
            return null;
        }
        SqlTypeName typeName1 = type1.getSqlTypeName();
        SqlTypeName typeName2 = type2.getSqlTypeName();
        if (typeName1 == null || typeName2 == null) {
            return null;
        }
        if (SqlTypeUtil.isCharacter(type1) && SqlTypeUtil.isDatetime(type2)) {
            return type2;
        }
        if (SqlTypeUtil.isDatetime(type1) && SqlTypeUtil.isCharacter(type2)) {
            return type1;
        }
        if (SqlTypeUtil.isDate(type1) && SqlTypeUtil.isTimestamp(type2)) {
            return type2;
        }
        if (SqlTypeUtil.isDate(type2) && SqlTypeUtil.isTimestamp(type1)) {
            return type1;
        }
        if (SqlTypeUtil.isString(type1) && typeName2 == SqlTypeName.NULL) {
            return type1;
        }
        if (typeName1 == SqlTypeName.NULL && SqlTypeUtil.isString(type2)) {
            return type2;
        }
        if (SqlTypeUtil.isDecimal(type1) && SqlTypeUtil.isCharacter(type2) || SqlTypeUtil.isCharacter(type1) && SqlTypeUtil.isDecimal(type2)) {
            return SqlTypeUtil.getMaxPrecisionScaleDecimal(this.factory);
        }
        if (SqlTypeUtil.isBinary(type2) && SqlTypeUtil.isApproximateNumeric(type1) || SqlTypeUtil.isBinary(type1) && SqlTypeUtil.isApproximateNumeric(type2)) {
            return null;
        }
        if (SqlTypeUtil.isAtomic(type1) && SqlTypeUtil.isCharacter(type2)) {
            if (SqlTypeUtil.isTimestamp(type1)) {
                return null;
            }
            return type1;
        }
        if (SqlTypeUtil.isCharacter(type1) && SqlTypeUtil.isAtomic(type2)) {
            if (SqlTypeUtil.isTimestamp(type2)) {
                return null;
            }
            return type2;
        }
        if (this.validator.config().conformance().allowCoercionStringToArray()) {
            if (SqlTypeUtil.isString(type1) && SqlTypeUtil.isArray(type2)) {
                return type2;
            }
            if (SqlTypeUtil.isString(type2) && SqlTypeUtil.isArray(type1)) {
                return type1;
            }
        }
        return null;
    }

    @Override
    public @Nullable RelDataType getWiderTypeForTwo(@Nullable RelDataType type1, @Nullable RelDataType type2, boolean stringPromotion) {
        RelDataType valType;
        if (type1 == null || type2 == null) {
            return null;
        }
        RelDataType resultType = this.getTightestCommonType(type1, type2);
        if (null == resultType) {
            resultType = this.getWiderTypeForDecimal(type1, type2);
        }
        if (null == resultType && stringPromotion) {
            resultType = this.promoteToVarChar(type1, type2);
        }
        if (null == resultType && SqlTypeUtil.isArray(type1) && SqlTypeUtil.isArray(type2) && null != (valType = this.getWiderTypeForTwo(type1.getComponentType(), type2.getComponentType(), stringPromotion))) {
            resultType = this.factory.createArrayType(valType, -1L);
        }
        return resultType;
    }

    @Override
    public @Nullable RelDataType getWiderTypeForDecimal(@Nullable RelDataType type1, @Nullable RelDataType type2) {
        if (type1 == null || type2 == null) {
            return null;
        }
        if (!SqlTypeUtil.isDecimal(type1) && !SqlTypeUtil.isDecimal(type2)) {
            return null;
        }
        if (SqlTypeUtil.isNumeric(type1) && SqlTypeUtil.isNumeric(type2)) {
            return this.factory.leastRestrictive(ImmutableList.of(type1, type2));
        }
        return null;
    }

    @Override
    public @Nullable RelDataType getWiderTypeFor(List<RelDataType> typeList, boolean stringPromotion) {
        assert (typeList.size() > 1);
        RelDataType resultType = typeList.get(0);
        List<RelDataType> target = stringPromotion ? AbstractTypeCoercion.partitionByCharacter(typeList) : typeList;
        for (RelDataType tp : target) {
            resultType = this.getWiderTypeForTwo(tp, resultType, stringPromotion);
            if (null != resultType) continue;
            return null;
        }
        return resultType;
    }

    private static List<RelDataType> partitionByCharacter(List<RelDataType> types) {
        ArrayList<RelDataType> withCharacterTypes = new ArrayList<RelDataType>();
        ArrayList<RelDataType> nonCharacterTypes = new ArrayList<RelDataType>();
        for (RelDataType tp : types) {
            if (SqlTypeUtil.hasCharacter(tp)) {
                withCharacterTypes.add(tp);
                continue;
            }
            nonCharacterTypes.add(tp);
        }
        ArrayList<RelDataType> partitioned = new ArrayList<RelDataType>();
        partitioned.addAll(withCharacterTypes);
        partitioned.addAll(nonCharacterTypes);
        return partitioned;
    }

    boolean canImplicitTypeCast(List<RelDataType> types, List<SqlTypeFamily> families) {
        boolean needed = false;
        if (types.size() != families.size()) {
            return false;
        }
        for (Pair<RelDataType, SqlTypeFamily> pair : Pair.zip(types, families)) {
            RelDataType implicitType = this.implicitCast((RelDataType)pair.left, (SqlTypeFamily)pair.right);
            if (null == implicitType) {
                return false;
            }
            needed = pair.left != implicitType || needed;
        }
        return needed;
    }

    public @Nullable RelDataType implicitCast(RelDataType in, SqlTypeFamily expected) {
        ImmutableList<SqlTypeFamily> numericFamilies = ImmutableList.of(SqlTypeFamily.NUMERIC, SqlTypeFamily.DECIMAL, SqlTypeFamily.APPROXIMATE_NUMERIC, SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.INTEGER);
        ImmutableList<SqlTypeFamily> dateTimeFamilies = ImmutableList.of(SqlTypeFamily.DATE, SqlTypeFamily.TIME, SqlTypeFamily.TIMESTAMP);
        if (expected.getTypeNames().contains((Object)in.getSqlTypeName())) {
            return in;
        }
        if (SqlTypeUtil.isNull(in)) {
            return expected.getDefaultConcreteType(this.factory);
        }
        if (SqlTypeUtil.isNumeric(in) && expected == SqlTypeFamily.DECIMAL) {
            return this.factory.decimalOf(in);
        }
        if (SqlTypeUtil.isApproximateNumeric(in) && expected == SqlTypeFamily.EXACT_NUMERIC) {
            return this.factory.decimalOf(in);
        }
        if (SqlTypeUtil.isDate(in) && expected == SqlTypeFamily.TIMESTAMP) {
            return this.factory.createSqlType(SqlTypeName.TIMESTAMP);
        }
        if (SqlTypeUtil.isTimestamp(in) && expected == SqlTypeFamily.DATE) {
            return this.factory.createSqlType(SqlTypeName.DATE);
        }
        if (SqlTypeUtil.isCharacter(in) && numericFamilies.contains(expected)) {
            return expected.getDefaultConcreteType(this.factory);
        }
        if (SqlTypeUtil.isCharacter(in) && dateTimeFamilies.contains(expected)) {
            return expected.getDefaultConcreteType(this.factory);
        }
        if (SqlTypeUtil.isCharacter(in) && expected == SqlTypeFamily.BINARY) {
            return expected.getDefaultConcreteType(this.factory);
        }
        if (SqlTypeUtil.isAtomic(in) && (expected == SqlTypeFamily.STRING || expected == SqlTypeFamily.CHARACTER)) {
            return expected.getDefaultConcreteType(this.factory);
        }
        if (SqlTypeUtil.isCharacter(in) && expected == SqlTypeFamily.GEO) {
            return expected.getDefaultConcreteType(this.factory);
        }
        return null;
    }

    protected Boolean coerceStringToArray(SqlCall call, SqlNode operand, int index, RelDataType fromType, RelDataType targetType) {
        if (this.validator.config().conformance().allowCoercionStringToArray() && SqlTypeUtil.isString(fromType) && SqlTypeUtil.isArray(targetType) && operand instanceof SqlCharStringLiteral) {
            try {
                SqlNode arrayValue = SqlParserUtil.parseArrayLiteral(((SqlCharStringLiteral)operand).getValueAs(String.class));
                call.setOperand(index, arrayValue);
                this.updateInferredType(arrayValue, targetType);
            }
            catch (SqlParseException e) {
                return false;
            }
            return true;
        }
        return false;
    }
}

