/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ReloadingX509TrustManager
implements X509TrustManager {
    static final Logger LOG = LoggerFactory.getLogger(ReloadingX509TrustManager.class);
    static final String RELOAD_ERROR_MESSAGE = "Could not load truststore (keep using existing one) : ";
    private String type;
    private String password;
    private AtomicReference<X509TrustManager> trustManagerRef;
    private static final X509Certificate[] EMPTY = new X509Certificate[0];

    public ReloadingX509TrustManager(String type, String location, String password) throws IOException, GeneralSecurityException {
        this.type = type;
        this.password = password;
        this.trustManagerRef = new AtomicReference();
        this.trustManagerRef.set(this.loadTrustManager(Paths.get(location, new String[0])));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm == null) {
            throw new CertificateException("Unknown client chain certificate: " + chain[0].toString());
        }
        tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm == null) {
            throw new CertificateException("Unknown server chain certificate: " + chain[0].toString());
        }
        tm.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] issuers = EMPTY;
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm != null) {
            issuers = tm.getAcceptedIssuers();
        }
        return issuers;
    }

    public ReloadingX509TrustManager loadFrom(Path path) {
        try {
            this.trustManagerRef.set(this.loadTrustManager(path));
        }
        catch (Exception ex) {
            throw new RuntimeException(RELOAD_ERROR_MESSAGE, ex);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    X509TrustManager loadTrustManager(Path path) throws IOException, GeneralSecurityException {
        TrustManager[] trustManagers;
        X509TrustManager trustManager = null;
        KeyStore ks = KeyStore.getInstance(this.type);
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            ks.load(in, this.password == null ? null : this.password.toCharArray());
            LOG.debug("Loaded truststore '" + path + "'");
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(SSLFactory.SSLCERTIFICATE);
        trustManagerFactory.init(ks);
        for (TrustManager trustManager1 : trustManagers = trustManagerFactory.getTrustManagers()) {
            if (!(trustManager1 instanceof X509TrustManager)) continue;
            trustManager = (X509TrustManager)trustManager1;
            break;
        }
        return trustManager;
    }
}

