/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.EtagSource;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Tristate;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AFileStatus
extends FileStatus
implements EtagSource {
    private static final long serialVersionUID = -5955674081978903922L;
    private Tristate isEmptyDirectory;
    private String eTag;
    private String versionId;

    public S3AFileStatus(boolean isemptydir, Path path, String owner) {
        this(Tristate.fromBool(isemptydir), path, owner);
    }

    public S3AFileStatus(Tristate isemptydir, Path path, String owner) {
        this(path, true, isemptydir, 0L, 0L, 0L, owner, null, null);
    }

    public S3AFileStatus(long length, long modification_time, Path path, long blockSize, String owner, String eTag, String versionId) {
        this(path, false, Tristate.FALSE, length, modification_time, blockSize, owner, eTag, versionId);
    }

    S3AFileStatus(Path path, boolean isDir, Tristate isemptydir, long length, long modificationTime, long blockSize, String owner, String eTag, String versionId) {
        super(length, isDir, 1, blockSize, modificationTime, 0L, null, owner, owner, null, path, false, true, false);
        this.isEmptyDirectory = isemptydir;
        this.eTag = eTag;
        this.versionId = versionId;
    }

    public static S3AFileStatus fromFileStatus(FileStatus source, Tristate isEmptyDirectory, String eTag, String versionId) {
        if (source.isDirectory()) {
            return new S3AFileStatus(isEmptyDirectory, source.getPath(), source.getOwner());
        }
        return new S3AFileStatus(source.getLen(), source.getModificationTime(), source.getPath(), source.getBlockSize(), source.getOwner(), eTag, versionId);
    }

    public Tristate isEmptyDirectory() {
        return this.isEmptyDirectory;
    }

    public void setIsEmptyDirectory(Tristate isEmptyDirectory) {
        this.isEmptyDirectory = isEmptyDirectory;
    }

    @Deprecated
    public String getETag() {
        return this.getEtag();
    }

    @Override
    public String getEtag() {
        return this.eTag;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public long getModificationTime() {
        if (this.isDirectory()) {
            return System.currentTimeMillis();
        }
        return super.getModificationTime();
    }

    @Override
    public String toString() {
        return super.toString() + String.format(" isEmptyDirectory=%s", this.isEmptyDirectory().name() + String.format(" eTag=%s", this.eTag) + String.format(" versionId=%s", this.versionId));
    }
}

