/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.functions.adaptors;

import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.cep.PatternFlatSelectFunction;
import org.apache.flink.cep.PatternFlatTimeoutFunction;
import org.apache.flink.cep.functions.PatternProcessFunction;
import org.apache.flink.cep.functions.TimedOutPartialMatchHandler;
import org.apache.flink.cep.functions.adaptors.PatternFlatSelectAdapter;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
public class PatternTimeoutFlatSelectAdapter<IN, OUT, T>
extends PatternFlatSelectAdapter<IN, OUT>
implements TimedOutPartialMatchHandler<IN> {
    private final PatternFlatTimeoutFunction<IN, T> flatTimeoutFunction;
    private final OutputTag<T> timedOutPartialMatchesTag;
    private transient SideCollector<T> sideCollector;

    public PatternTimeoutFlatSelectAdapter(PatternFlatSelectFunction<IN, OUT> flatSelectFunction, PatternFlatTimeoutFunction<IN, T> flatTimeoutFunction, OutputTag<T> timedOutPartialMatchesTag) {
        super(flatSelectFunction);
        this.flatTimeoutFunction = (PatternFlatTimeoutFunction)Preconditions.checkNotNull(flatTimeoutFunction);
        this.timedOutPartialMatchesTag = (OutputTag)Preconditions.checkNotNull(timedOutPartialMatchesTag);
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        FunctionUtils.setFunctionRuntimeContext(this.flatTimeoutFunction, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.flatTimeoutFunction, (OpenContext)openContext);
        if (this.sideCollector == null) {
            this.sideCollector = new SideCollector((OutputTag)Preconditions.checkNotNull(this.timedOutPartialMatchesTag));
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.flatTimeoutFunction);
    }

    @Override
    public void processTimedOutMatch(Map<String, List<IN>> match, PatternProcessFunction.Context ctx) throws Exception {
        this.sideCollector.setCtx(ctx);
        this.flatTimeoutFunction.timeout(match, ctx.timestamp(), this.sideCollector);
    }

    private static final class SideCollector<T>
    implements Collector<T> {
        private final OutputTag<T> timedOutPartialMatchesTag;
        private transient PatternProcessFunction.Context ctx;

        private SideCollector(OutputTag<T> timedOutPartialMatchesTag) {
            this.timedOutPartialMatchesTag = (OutputTag)Preconditions.checkNotNull(timedOutPartialMatchesTag);
        }

        public void setCtx(PatternProcessFunction.Context ctx) {
            this.ctx = ctx;
        }

        public void collect(T record) {
            this.ctx.output(this.timedOutPartialMatchesTag, record);
        }

        public void close() {
        }
    }
}

