/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.checkpoint;

import java.util.Arrays;

import static org.apache.flink.util.Preconditions.checkNotNull;

/** Simple encapsulation of state generated by checkpoint coordinator. */
public class MasterState implements java.io.Serializable {

    private static final long serialVersionUID = 1L;

    private final String name;
    private final byte[] bytes;
    private final int version;

    public MasterState(String name, byte[] bytes, int version) {
        this.name = checkNotNull(name);
        this.bytes = checkNotNull(bytes);
        this.version = version;
    }

    // ------------------------------------------------------------------------

    public String name() {
        return name;
    }

    public byte[] bytes() {
        return bytes;
    }

    public int version() {
        return version;
    }

    // ------------------------------------------------------------------------

    @Override
    public String toString() {
        return "name: " + name + " ; version: " + version + " ; bytes: " + Arrays.toString(bytes);
    }
}
