/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.common;

import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.core.fs.LimitedConnectionsFileSystem;
import org.apache.flink.core.fs.UnsupportedFileSystemSchemeException;
import org.apache.flink.fs.osshadoop.common.HadoopFileSystem;
import org.apache.flink.fs.osshadoop.common.HadoopUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFsFactory
implements FileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFsFactory.class);
    private Configuration flinkConfig;
    private org.apache.hadoop.conf.Configuration hadoopConfig;

    public String getScheme() {
        return "*";
    }

    public void configure(Configuration config) {
        this.flinkConfig = config;
        this.hadoopConfig = null;
    }

    public FileSystem create(URI fsUri) throws IOException {
        Preconditions.checkNotNull((Object)fsUri, (String)"fsUri");
        String scheme = fsUri.getScheme();
        Preconditions.checkArgument((scheme != null ? 1 : 0) != 0, (Object)"file system has null scheme");
        try {
            URI initUri;
            Class<? extends org.apache.hadoop.fs.FileSystem> fsClass;
            org.apache.hadoop.conf.Configuration hadoopConfig;
            if (this.hadoopConfig != null) {
                hadoopConfig = this.hadoopConfig;
            } else if (this.flinkConfig != null) {
                this.hadoopConfig = hadoopConfig = HadoopUtils.getHadoopConfiguration(this.flinkConfig);
            } else {
                LOG.warn("Hadoop configuration has not been explicitly initialized prior to loading a Hadoop file system. Using configuration from the classpath.");
                hadoopConfig = new org.apache.hadoop.conf.Configuration();
            }
            try {
                fsClass = org.apache.hadoop.fs.FileSystem.getFileSystemClass(scheme, hadoopConfig);
            }
            catch (IOException e) {
                throw new UnsupportedFileSystemSchemeException("Hadoop File System abstraction does not support scheme '" + scheme + "'. Either no file system implementation exists for that scheme, or the relevant classes are missing from the classpath.", (Throwable)e);
            }
            LOG.debug("Instantiating for file system scheme {} Hadoop File System {}", (Object)scheme, (Object)fsClass.getName());
            org.apache.hadoop.fs.FileSystem hadoopFs = fsClass.newInstance();
            if (fsUri.getAuthority() != null) {
                initUri = fsUri;
            } else {
                String configEntry;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("URI {} does not specify file system authority, trying to load default authority (fs.defaultFS)", (Object)fsUri);
                }
                if ((configEntry = hadoopConfig.get("fs.defaultFS", null)) == null) {
                    configEntry = hadoopConfig.get("fs.default.name", null);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Hadoop's 'fs.defaultFS' is set to {}", (Object)configEntry);
                }
                if (configEntry == null) {
                    throw new IOException(HadoopFsFactory.getMissingAuthorityErrorPrefix(fsUri) + "Hadoop configuration did not contain an entry for the default file system ('fs.defaultFS').");
                }
                try {
                    initUri = URI.create(configEntry);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(HadoopFsFactory.getMissingAuthorityErrorPrefix(fsUri) + "The configuration contains an invalid file system default name ('fs.default.name' or 'fs.defaultFS'): " + configEntry);
                }
                if (initUri.getAuthority() == null) {
                    throw new IOException(HadoopFsFactory.getMissingAuthorityErrorPrefix(fsUri) + "Hadoop configuration for default file system ('fs.default.name' or 'fs.defaultFS') contains no valid authority component (like hdfs namenode, S3 host, etc)");
                }
            }
            try {
                hadoopFs.initialize(initUri, hadoopConfig);
            }
            catch (UnknownHostException e) {
                String message = "The Hadoop file system's authority (" + initUri.getAuthority() + "), specified by either the file URI or the configuration, cannot be resolved.";
                throw new IOException(message, e);
            }
            HadoopFileSystem fs = new HadoopFileSystem(hadoopFs);
            if (this.flinkConfig != null) {
                return HadoopFsFactory.limitIfConfigured(fs, scheme, this.flinkConfig);
            }
            return fs;
        }
        catch (LinkageError | ReflectiveOperationException e) {
            throw new UnsupportedFileSystemSchemeException("Cannot support file system for '" + fsUri.getScheme() + "' via Hadoop, because Hadoop is not in the classpath, or some classes are missing from the classpath.", e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Cannot instantiate file system for URI: " + fsUri, e);
        }
    }

    private static String getMissingAuthorityErrorPrefix(URI fsURI) {
        return "The given file system URI (" + fsURI.toString() + ") did not describe the authority (like for example HDFS NameNode address/port or S3 host). The attempt to use a configured default authority failed: ";
    }

    private static FileSystem limitIfConfigured(HadoopFileSystem fs, String scheme, Configuration config) {
        LimitedConnectionsFileSystem.ConnectionLimitingSettings limitSettings = LimitedConnectionsFileSystem.ConnectionLimitingSettings.fromConfig((Configuration)config, (String)scheme);
        if (limitSettings == null) {
            return fs;
        }
        return new LimitedConnectionsFileSystem((FileSystem)fs, limitSettings.limitTotal, limitSettings.limitOutput, limitSettings.limitInput, limitSettings.streamOpenTimeout, limitSettings.streamInactivityTimeout);
    }
}

