/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.plan.utils.RexDefaultVisitor;
import org.apache.flink.table.planner.utils.ShortcutUtils;

public class ConstantFoldingUtil {
    public static boolean supportsConstantFolding(RexNode node) {
        return node.accept(new CanConstantFoldExpressionVisitor());
    }

    private static class CanConstantFoldExpressionVisitor
    extends RexDefaultVisitor<Boolean> {
        private CanConstantFoldExpressionVisitor() {
        }

        @Override
        public Boolean visitNode(RexNode rexNode) {
            return true;
        }

        private boolean supportsConstantFolding(RexCall call) {
            FunctionDefinition definition = ShortcutUtils.unwrapFunctionDefinition(call);
            return definition == null || definition.supportsConstantFolding();
        }

        @Override
        public Boolean visitCall(RexCall call) {
            boolean supportsConstantFolding = this.supportsConstantFolding(call);
            return supportsConstantFolding && call.getOperands().stream().allMatch(node -> node.accept(this));
        }
    }
}

