/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.functions.TemporalTableFunctionImpl;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.GetTemporalTableFunctionCall;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableFunctionRule$;
import org.apache.flink.table.planner.plan.rules.logical.TemporalTableFunctionCall;
import org.apache.flink.table.planner.plan.utils.ExpandTableScanShuttle;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\u0007\u000e\u0001yAQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\n-BQ!\u0011\u0001\u0005\n\tCQa\u0014\u0001\u0005\nACQa\u0015\u0001\u0005BQCQ!\u0018\u0001\u0005\ny;QA^\u0007\t\u0002]4Q\u0001D\u0007\t\u0002aDQA\n\u0005\u0005\u0002qDq! \u0005C\u0002\u0013\u0005a\u0010\u0003\u0004\u0000\u0011\u0001\u0006Ia\b\u00024\u0019><\u0017nY1m\u0007>\u0014(/\u001a7bi\u0016$vNS8j]\u001a\u0013x.\u001c+f[B|'/\u00197UC\ndWMR;oGRLwN\u001c*vY\u0016T!AD\b\u0002\u000f1|w-[2bY*\u0011\u0001#E\u0001\u0006eVdWm\u001d\u0006\u0003%M\tA\u0001\u001d7b]*\u0011A#F\u0001\ba2\fgN\\3s\u0015\t1r#A\u0003uC\ndWM\u0003\u0002\u00193\u0005)a\r\\5oW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\"S\"A\u0011\u000b\u0005I\u0011#BA\u0012\u001a\u0003\u001d\u0019\u0017\r\\2ji\u0016L!!J\u0011\u0003\u0015I+Gn\u00149u%VdW-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u0002\u001b\u0005aR\r\u001f;sC\u000e$h*Y7f\rJ|W\u000eV5nK\u0006#HO]5ckR,GC\u0001\u0017:!\ticG\u0004\u0002/iA\u0011qFM\u0007\u0002a)\u0011\u0011'H\u0001\u0007yI|w\u000e\u001e \u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0002\rA\u0013X\rZ3g\u0013\t9\u0004H\u0001\u0004TiJLgn\u001a\u0006\u0003kIBQA\u000f\u0002A\u0002m\nQ\u0002^5nK\u0006#HO]5ckR,\u0007C\u0001\u001f@\u001b\u0005i$B\u0001 \u0016\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005\u0001k$AC#yaJ,7o]5p]\u0006\u0019\u0012n\u001d)s_\u000e$\u0018.\\3SK\u001a,'/\u001a8dKR\u00111i\u0012\t\u0003\t\u0016k\u0011AM\u0005\u0003\rJ\u0012qAQ8pY\u0016\fg\u000eC\u0003I\u0007\u0001\u0007\u0011*A\u000buK6\u0004xN]1m)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8\u0011\u0005)kU\"A&\u000b\u00051+\u0012!\u00034v]\u000e$\u0018n\u001c8t\u0013\tq5JA\rUK6\u0004xN]1m)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8J[Bd\u0017AI3yiJ\f7\r\u001e(b[\u00164%o\\7Qe&l\u0017M]=LKf\fE\u000f\u001e:jEV$X\r\u0006\u0002-#\")!\u000b\u0002a\u0001w\u0005QQ\r\u001f9sKN\u001c\u0018n\u001c8\u0002\u000f=tW*\u0019;dQR\u0011Q\u000b\u0017\t\u0003\tZK!a\u0016\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u00063\u0016\u0001\rAW\u0001\u0005G\u0006dG\u000e\u0005\u0002!7&\u0011A,\t\u0002\u000f%\u0016dw\n\u001d;Sk2,7)\u00197m\u0003U\u0019'/Z1uKJKw\r\u001b;FqB\u0014Xm]:j_:$RaX3keR\u0004\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u0012\u0002\u0007I,\u00070\u0003\u0002eC\n9!+\u001a=O_\u0012,\u0007\"\u00024\u0007\u0001\u00049\u0017A\u0003:fq\n+\u0018\u000e\u001c3feB\u0011\u0001\r[\u0005\u0003S\u0006\u0014!BU3y\u0005VLG\u000eZ3s\u0011\u0015Yg\u00011\u0001m\u0003!aWM\u001a;O_\u0012,\u0007CA7q\u001b\u0005q'BA8#\u0003\r\u0011X\r\\\u0005\u0003c:\u0014qAU3m\u001d>$W\rC\u0003t\r\u0001\u0007A.A\u0005sS\u001eDGOT8eK\")QO\u0002a\u0001Y\u0005)a-[3mI\u0006\u0019Dj\\4jG\u0006d7i\u001c:sK2\fG/\u001a+p\u0015>LgN\u0012:p[R+W\u000e]8sC2$\u0016M\u00197f\rVt7\r^5p]J+H.\u001a\t\u0003S!\u0019\"\u0001C=\u0011\u0005\u0011S\u0018BA>3\u0005\u0019\te.\u001f*fMR\tq/\u0001\u0005J\u001dN#\u0016IT\"F+\u0005y\u0012!C%O'R\u000bejQ#!\u0001")
public class LogicalCorrelateToJoinFromTemporalTableFunctionRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return LogicalCorrelateToJoinFromTemporalTableFunctionRule$.MODULE$.INSTANCE();
    }

    private String extractNameFromTimeAttribute(Expression timeAttribute) {
        Expression expression = timeAttribute;
        if (expression instanceof FieldReferenceExpression) {
            FieldReferenceExpression fieldReferenceExpression = (FieldReferenceExpression)expression;
            if (fieldReferenceExpression.getOutputDataType().getLogicalType().isAnyOf(new LogicalTypeRoot[]{LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE})) {
                return fieldReferenceExpression.getName();
            }
        }
        throw new ValidationException(new StringBuilder(49).append("Invalid timeAttribute [").append(timeAttribute).append("] in TemporalTableFunction").toString());
    }

    private boolean isProctimeReference(TemporalTableFunctionImpl temporalTableFunction) {
        FieldReferenceExpression fieldRef = (FieldReferenceExpression)temporalTableFunction.getTimeAttribute();
        return LogicalTypeChecks.isProctimeAttribute((LogicalType)fieldRef.getOutputDataType().getLogicalType());
    }

    private String extractNameFromPrimaryKeyAttribute(Expression expression) {
        Expression expression2 = expression;
        if (expression2 instanceof FieldReferenceExpression) {
            FieldReferenceExpression fieldReferenceExpression = (FieldReferenceExpression)expression2;
            return fieldReferenceExpression.getName();
        }
        throw new ValidationException(new StringBuilder(101).append("Unsupported expression [").append(expression).append("] as primary key. ").append("Only top-level (not nested) field references are supported.").toString());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Some some;
        TemporalTableFunctionCall temporalTableFunctionCall;
        LogicalCorrelate logicalCorrelate = (LogicalCorrelate)call.rel(0);
        Object leftNode = call.rel(1);
        TableFunctionScan rightTableFunctionScan = (TableFunctionScan)call.rel(2);
        RelOptCluster cluster = logicalCorrelate.getCluster();
        Option<TemporalTableFunctionCall> option = new GetTemporalTableFunctionCall(cluster.getRexBuilder(), (RelNode)leftNode).visit(rightTableFunctionScan.getCall());
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some && (temporalTableFunctionCall = (TemporalTableFunctionCall)(some = (Some)option).value()) != null) {
            TemporalTableFunction rightTemporalTableFunction = temporalTableFunctionCall.temporalTableFunction();
            RexNode leftTimeAttribute = temporalTableFunctionCall.timeAttribute();
            if (rightTemporalTableFunction instanceof TemporalTableFunctionImpl) {
                TemporalTableFunctionImpl temporalTableFunctionImpl = (TemporalTableFunctionImpl)rightTemporalTableFunction;
                QueryOperation underlyingHistoryTable = temporalTableFunctionImpl.getUnderlyingHistoryTable();
                RexBuilder rexBuilder = cluster.getRexBuilder();
                FlinkOptimizeContext flinkContext = (FlinkOptimizeContext)ShortcutUtils.unwrapContext(call.getPlanner());
                FlinkRelBuilder relBuilder = flinkContext.getFlinkRelBuilder();
                RelNode temporalTable = relBuilder.queryOperation(underlyingHistoryTable).build();
                ExpandTableScanShuttle shuttle = new ExpandTableScanShuttle();
                RelNode rightNode = temporalTable.accept(shuttle);
                RexNode rightTimeIndicatorExpression = this.createRightExpression(rexBuilder, (RelNode)leftNode, rightNode, this.extractNameFromTimeAttribute(temporalTableFunctionImpl.getTimeAttribute()));
                RexNode rightPrimaryKeyExpression = this.createRightExpression(rexBuilder, (RelNode)leftNode, rightNode, this.extractNameFromPrimaryKeyAttribute(temporalTableFunctionImpl.getPrimaryKey()));
                relBuilder.push((RelNode)leftNode);
                relBuilder.push(rightNode);
                RexNode condition = this.isProctimeReference(temporalTableFunctionImpl) ? TemporalJoinUtil$.MODULE$.makeProcTimeTemporalFunctionJoinConCall(rexBuilder, leftTimeAttribute, rightPrimaryKeyExpression) : TemporalJoinUtil$.MODULE$.makeRowTimeTemporalFunctionJoinConCall(rexBuilder, leftTimeAttribute, rightTimeIndicatorExpression, rightPrimaryKeyExpression);
                relBuilder.join(JoinRelType.INNER, condition);
                call.transformTo(relBuilder.build());
                return;
            }
        }
        throw new MatchError(option);
    }

    private RexNode createRightExpression(RexBuilder rexBuilder, RelNode leftNode, RelNode rightNode, String field) {
        int rightReferencesOffset = leftNode.getRowType().getFieldCount();
        RelDataTypeField rightDataTypeField = rightNode.getRowType().getField(field, false, false);
        return rexBuilder.makeInputRef(rightDataTypeField.getType(), rightReferencesOffset + rightDataTypeField.getIndex());
    }

    public LogicalCorrelateToJoinFromTemporalTableFunctionRule() {
        super(RelOptRule.operand(LogicalCorrelate.class, RelOptRule.some(RelOptRule.operand(RelNode.class, RelOptRule.any()), RelOptRule.operand(TableFunctionScan.class, RelOptRule.none()))), "LogicalCorrelateToJoinFromTemporalTableFunctionRule");
    }
}

