/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Sarg;
import org.apache.flink.annotation.Internal;
import org.apache.flink.calcite.shaded.com.google.common.collect.Range;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlAggFunction;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.functions.sql.BuiltInSqlOperator;
import org.apache.flink.table.planner.functions.utils.AggSqlFunction;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction;
import org.apache.flink.table.planner.functions.utils.TableSqlFunction;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.typeutils.SymbolUtil;

@Internal
final class RexNodeJsonSerializer
extends StdSerializer<RexNode> {
    private static final long serialVersionUID = 1L;
    static final String FIELD_NAME_KIND = "kind";
    static final String FIELD_NAME_VALUE = "value";
    static final String FIELD_NAME_TYPE = "type";
    static final String FIELD_NAME_NAME = "name";
    static final String KIND_INPUT_REF = "INPUT_REF";
    static final String FIELD_NAME_INPUT_INDEX = "inputIndex";
    static final String KIND_LITERAL = "LITERAL";
    static final String FIELD_NAME_SARG = "sarg";
    static final String FIELD_NAME_RANGES = "ranges";
    static final String FIELD_NAME_BOUND_LOWER = "lower";
    static final String FIELD_NAME_BOUND_UPPER = "upper";
    static final String FIELD_NAME_BOUND_TYPE = "boundType";
    static final String FIELD_NAME_CONTAINS_NULL = "containsNull";
    static final String FIELD_NAME_NULL_AS = "nullAs";
    static final String FIELD_NAME_SYMBOL = "symbol";
    static final String KIND_FIELD_ACCESS = "FIELD_ACCESS";
    static final String FIELD_NAME_EXPR = "expr";
    static final String KIND_CORREL_VARIABLE = "CORREL_VARIABLE";
    static final String FIELD_NAME_CORREL = "correl";
    static final String KIND_PATTERN_INPUT_REF = "PATTERN_INPUT_REF";
    static final String FIELD_NAME_ALPHA = "alpha";
    static final String KIND_CALL = "CALL";
    static final String FIELD_NAME_OPERANDS = "operands";
    static final String FIELD_NAME_INTERNAL_NAME = "internalName";
    static final String FIELD_NAME_SYSTEM_NAME = "systemName";
    static final String FIELD_NAME_CATALOG_NAME = "catalogName";
    static final String FIELD_NAME_SYNTAX = "syntax";
    static final String FIELD_NAME_SQL_KIND = "sqlKind";
    static final String FIELD_NAME_CLASS = "class";

    RexNodeJsonSerializer() {
        super(RexNode.class);
    }

    public void serialize(RexNode rexNode, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        ReadableConfig config = SerdeContext.get((DatabindContext)serializerProvider).getConfiguration();
        TableConfigOptions.CatalogPlanCompilation compilationStrategy = (TableConfigOptions.CatalogPlanCompilation)config.get(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS);
        switch (rexNode.getKind()) {
            case INPUT_REF: 
            case TABLE_INPUT_REF: {
                RexNodeJsonSerializer.serializeInputRef((RexInputRef)rexNode, jsonGenerator, serializerProvider);
                break;
            }
            case LITERAL: {
                RexNodeJsonSerializer.serializeLiteral((RexLiteral)rexNode, jsonGenerator, serializerProvider);
                break;
            }
            case FIELD_ACCESS: {
                RexNodeJsonSerializer.serializeFieldAccess((RexFieldAccess)rexNode, jsonGenerator, serializerProvider);
                break;
            }
            case CORREL_VARIABLE: {
                RexNodeJsonSerializer.serializeCorrelVariable((RexCorrelVariable)rexNode, jsonGenerator, serializerProvider);
                break;
            }
            case PATTERN_INPUT_REF: {
                RexNodeJsonSerializer.serializePatternFieldRef((RexPatternFieldRef)rexNode, jsonGenerator, serializerProvider);
                break;
            }
            default: {
                if (rexNode instanceof RexCall) {
                    RexNodeJsonSerializer.serializeCall((RexCall)rexNode, jsonGenerator, serializerProvider, compilationStrategy);
                    break;
                }
                throw new TableException("Unknown RexNode: " + rexNode);
            }
        }
    }

    private static void serializePatternFieldRef(RexPatternFieldRef inputRef, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, KIND_PATTERN_INPUT_REF);
        gen.writeStringField(FIELD_NAME_ALPHA, inputRef.getAlpha());
        gen.writeNumberField(FIELD_NAME_INPUT_INDEX, inputRef.getIndex());
        serializerProvider.defaultSerializeField(FIELD_NAME_TYPE, (Object)inputRef.getType(), gen);
        gen.writeEndObject();
    }

    private static void serializeInputRef(RexInputRef inputRef, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, KIND_INPUT_REF);
        gen.writeNumberField(FIELD_NAME_INPUT_INDEX, inputRef.getIndex());
        serializerProvider.defaultSerializeField(FIELD_NAME_TYPE, (Object)inputRef.getType(), gen);
        gen.writeEndObject();
    }

    private static void serializeLiteral(RexLiteral literal, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, KIND_LITERAL);
        Comparable value = literal.getValueAs(Comparable.class);
        if (literal.getTypeName() == SqlTypeName.SARG) {
            RexNodeJsonSerializer.serializeSargValue((Sarg)value, literal.getType().getSqlTypeName(), gen);
        } else {
            RexNodeJsonSerializer.serializeLiteralValue(value, literal.getType().getSqlTypeName(), gen);
        }
        serializerProvider.defaultSerializeField(FIELD_NAME_TYPE, (Object)literal.getType(), gen);
        gen.writeEndObject();
    }

    private static void serializeLiteralValue(Comparable<?> value, SqlTypeName literalTypeName, JsonGenerator gen) throws IOException {
        if (value == null) {
            gen.writeNullField(FIELD_NAME_VALUE);
            return;
        }
        switch (literalTypeName) {
            case BOOLEAN: {
                gen.writeBooleanField(FIELD_NAME_VALUE, ((Boolean)value).booleanValue());
                break;
            }
            case TINYINT: {
                gen.writeNumberField(FIELD_NAME_VALUE, (short)((BigDecimal)value).byteValue());
                break;
            }
            case SMALLINT: {
                gen.writeNumberField(FIELD_NAME_VALUE, ((BigDecimal)value).shortValue());
                break;
            }
            case INTEGER: {
                gen.writeNumberField(FIELD_NAME_VALUE, ((BigDecimal)value).intValue());
                break;
            }
            case BIGINT: {
                gen.writeNumberField(FIELD_NAME_VALUE, ((BigDecimal)value).longValue());
                break;
            }
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                gen.writeStringField(FIELD_NAME_VALUE, value.toString());
                break;
            }
            case BINARY: 
            case VARBINARY: {
                gen.writeStringField(FIELD_NAME_VALUE, ((ByteString)value).toBase64String());
                break;
            }
            case CHAR: 
            case VARCHAR: {
                gen.writeStringField(FIELD_NAME_VALUE, ((NlsString)value).getValue());
                break;
            }
            case SYMBOL: {
                SymbolUtil.SerializableSymbol symbol = SymbolUtil.calciteToSerializable((Enum)((Object)value));
                gen.writeStringField(FIELD_NAME_SYMBOL, symbol.getKind());
                gen.writeStringField(FIELD_NAME_VALUE, symbol.getValue());
                break;
            }
            default: {
                throw new TableException(String.format("Literal type '%s' is not supported for serializing value '%s'.", new Object[]{literalTypeName, value}));
            }
        }
    }

    private static void serializeSargValue(Sarg<?> value, SqlTypeName sqlTypeName, JsonGenerator gen) throws IOException {
        gen.writeFieldName(FIELD_NAME_SARG);
        gen.writeStartObject();
        gen.writeFieldName(FIELD_NAME_RANGES);
        gen.writeStartArray();
        for (Range range : value.rangeSet.asRanges()) {
            SymbolUtil.SerializableSymbol symbol;
            gen.writeStartObject();
            if (range.hasLowerBound()) {
                gen.writeFieldName(FIELD_NAME_BOUND_LOWER);
                gen.writeStartObject();
                RexNodeJsonSerializer.serializeLiteralValue(range.lowerEndpoint(), sqlTypeName, gen);
                symbol = SymbolUtil.calciteToSerializable(range.lowerBoundType());
                gen.writeStringField(FIELD_NAME_BOUND_TYPE, symbol.getValue());
                gen.writeEndObject();
            }
            if (range.hasUpperBound()) {
                gen.writeFieldName(FIELD_NAME_BOUND_UPPER);
                gen.writeStartObject();
                RexNodeJsonSerializer.serializeLiteralValue(range.upperEndpoint(), sqlTypeName, gen);
                symbol = SymbolUtil.calciteToSerializable(range.upperBoundType());
                gen.writeStringField(FIELD_NAME_BOUND_TYPE, symbol.getValue());
                gen.writeEndObject();
            }
            gen.writeEndObject();
        }
        gen.writeEndArray();
        SymbolUtil.SerializableSymbol symbol = SymbolUtil.calciteToSerializable(value.nullAs);
        gen.writeStringField(FIELD_NAME_NULL_AS, symbol.getValue());
        gen.writeEndObject();
    }

    private static void serializeFieldAccess(RexFieldAccess fieldAccess, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, KIND_FIELD_ACCESS);
        gen.writeStringField(FIELD_NAME_NAME, fieldAccess.getField().getName());
        serializerProvider.defaultSerializeField(FIELD_NAME_EXPR, (Object)fieldAccess.getReferenceExpr(), gen);
        gen.writeEndObject();
    }

    private static void serializeCorrelVariable(RexCorrelVariable variable, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, KIND_CORREL_VARIABLE);
        gen.writeStringField(FIELD_NAME_CORREL, variable.getName());
        serializerProvider.defaultSerializeField(FIELD_NAME_TYPE, (Object)variable.getType(), gen);
        gen.writeEndObject();
    }

    private static void serializeCall(RexCall call, JsonGenerator gen, SerializerProvider serializerProvider, TableConfigOptions.CatalogPlanCompilation compilationStrategy) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, KIND_CALL);
        RexNodeJsonSerializer.serializeSqlOperator(call.getOperator(), gen, serializerProvider, compilationStrategy == TableConfigOptions.CatalogPlanCompilation.ALL);
        gen.writeFieldName(FIELD_NAME_OPERANDS);
        gen.writeStartArray();
        for (RexNode operand : call.getOperands()) {
            serializerProvider.defaultSerializeValue((Object)operand, gen);
        }
        gen.writeEndArray();
        serializerProvider.defaultSerializeField(FIELD_NAME_TYPE, (Object)call.getType(), gen);
        gen.writeEndObject();
    }

    static void serializeSqlOperator(SqlOperator operator, JsonGenerator gen, SerializerProvider serializerProvider, boolean serializeCatalogObjects) throws IOException {
        if (operator.getSyntax() != SqlSyntax.FUNCTION) {
            gen.writeStringField(FIELD_NAME_SYNTAX, SymbolUtil.calciteToSerializable(operator.getSyntax()).getValue());
        }
        if (operator instanceof BridgingSqlFunction) {
            BridgingSqlFunction function = (BridgingSqlFunction)operator;
            RexNodeJsonSerializer.serializeBridgingSqlFunction(function.getName(), function.getResolvedFunction(), gen, serializerProvider, serializeCatalogObjects);
        } else if (operator instanceof BridgingSqlAggFunction) {
            BridgingSqlAggFunction function = (BridgingSqlAggFunction)operator;
            RexNodeJsonSerializer.serializeBridgingSqlFunction(function.getName(), function.getResolvedFunction(), gen, serializerProvider, serializeCatalogObjects);
        } else {
            if (operator instanceof ScalarSqlFunction || operator instanceof TableSqlFunction || operator instanceof AggSqlFunction) {
                throw RexNodeJsonSerializer.legacyException(operator.toString());
            }
            if (operator.getName().isEmpty()) {
                gen.writeStringField(FIELD_NAME_SQL_KIND, operator.getKind().name());
            } else {
                gen.writeStringField(FIELD_NAME_INTERNAL_NAME, BuiltInSqlOperator.toQualifiedName(operator));
            }
        }
    }

    private static void serializeBridgingSqlFunction(String summaryName, ContextResolvedFunction resolvedFunction, JsonGenerator gen, SerializerProvider serializerProvider, boolean serializeCatalogObjects) throws IOException {
        FunctionDefinition definition = resolvedFunction.getDefinition();
        if (definition instanceof ScalarFunctionDefinition || definition instanceof TableFunctionDefinition || definition instanceof TableAggregateFunctionDefinition || definition instanceof AggregateFunctionDefinition) {
            throw RexNodeJsonSerializer.legacyException(summaryName);
        }
        if (definition instanceof BuiltInFunctionDefinition) {
            BuiltInFunctionDefinition builtInFunction = (BuiltInFunctionDefinition)definition;
            gen.writeStringField(FIELD_NAME_INTERNAL_NAME, builtInFunction.getQualifiedName());
        } else if (resolvedFunction.isAnonymous()) {
            RexNodeJsonSerializer.serializeInlineFunction(summaryName, definition, gen);
        } else if (resolvedFunction.isTemporary()) {
            RexNodeJsonSerializer.serializeTemporaryFunction(resolvedFunction, gen, serializerProvider);
        } else {
            assert (resolvedFunction.isPermanent());
            RexNodeJsonSerializer.serializePermanentFunction(resolvedFunction, gen, serializerProvider, serializeCatalogObjects);
        }
    }

    private static void serializeInlineFunction(String summaryName, FunctionDefinition definition, JsonGenerator gen) throws IOException {
        if (!(definition instanceof UserDefinedFunction) || !UserDefinedFunctionHelper.isClassNameSerializable((UserDefinedFunction)((UserDefinedFunction)definition))) {
            throw RexNodeJsonSerializer.cannotSerializeInlineFunction(summaryName);
        }
        gen.writeStringField(FIELD_NAME_CLASS, definition.getClass().getName());
    }

    private static void serializeTemporaryFunction(ContextResolvedFunction resolvedFunction, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        assert (resolvedFunction.getIdentifier().isPresent());
        FunctionIdentifier identifier = (FunctionIdentifier)resolvedFunction.getIdentifier().get();
        if (identifier.getSimpleName().isPresent()) {
            gen.writeStringField(FIELD_NAME_SYSTEM_NAME, (String)identifier.getSimpleName().get());
        } else {
            assert (identifier.getIdentifier().isPresent());
            serializerProvider.defaultSerializeField(FIELD_NAME_CATALOG_NAME, identifier.getIdentifier().get(), gen);
        }
    }

    private static void serializePermanentFunction(ContextResolvedFunction resolvedFunction, JsonGenerator gen, SerializerProvider serializerProvider, boolean serializeCatalogObjects) throws IOException {
        FunctionIdentifier identifier = (FunctionIdentifier)resolvedFunction.getIdentifier().orElseThrow(() -> new IllegalArgumentException("Permanent functions should own a function identifier."));
        if (identifier.getSimpleName().isPresent()) {
            gen.writeStringField(FIELD_NAME_SYSTEM_NAME, (String)identifier.getSimpleName().get());
        } else {
            assert (identifier.getIdentifier().isPresent());
            RexNodeJsonSerializer.serializeCatalogFunction((ObjectIdentifier)identifier.getIdentifier().get(), resolvedFunction.getDefinition(), gen, serializerProvider, serializeCatalogObjects);
        }
    }

    private static void serializeCatalogFunction(ObjectIdentifier objectIdentifier, FunctionDefinition definition, JsonGenerator gen, SerializerProvider serializerProvider, boolean serializeCatalogObjects) throws IOException {
        serializerProvider.defaultSerializeField(FIELD_NAME_CATALOG_NAME, (Object)objectIdentifier, gen);
        if (!serializeCatalogObjects) {
            return;
        }
        if (!(definition instanceof UserDefinedFunction) || !UserDefinedFunctionHelper.isClassNameSerializable((UserDefinedFunction)((UserDefinedFunction)definition))) {
            throw RexNodeJsonSerializer.cannotSerializePermanentCatalogFunction(objectIdentifier);
        }
        gen.writeStringField(FIELD_NAME_CLASS, definition.getClass().getName());
    }

    private static TableException legacyException(String summaryName) {
        return new TableException(String.format("Functions of the deprecated function stack are not supported. Please update '%s' to the new interfaces.", summaryName));
    }

    private static TableException cannotSerializeInlineFunction(String summaryName) {
        return new TableException(String.format("Anonymous function '%s' is not serializable. The function's implementation class must not be stateful (i.e. containing only transient and static fields) and should provide a default constructor. One can register the function under a temporary name to resolve this issue.", summaryName));
    }

    private static TableException cannotSerializePermanentCatalogFunction(ObjectIdentifier objectIdentifier) {
        return new TableException(String.format("Permanent catalog function '%s' is not serializable. The function's implementation class must not be stateful (i.e. containing only transient and static fields) and should provide a default constructor. Depending on the catalog implementation, it might be necessary to only serialize the function's identifier by setting the option '%s'='%s'. One then needs to guarantee that the same catalog object is also present during a restore.", objectIdentifier.asSummaryString(), TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanCompilation.IDENTIFIER));
    }
}

