/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.expressions.converter.converters.ArrayConverter;
import org.apache.flink.table.planner.expressions.converter.converters.AsConverter;
import org.apache.flink.table.planner.expressions.converter.converters.BetweenConverter;
import org.apache.flink.table.planner.expressions.converter.converters.CastConverter;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;
import org.apache.flink.table.planner.expressions.converter.converters.GetConverter;
import org.apache.flink.table.planner.expressions.converter.converters.InConverter;
import org.apache.flink.table.planner.expressions.converter.converters.IsJsonConverter;
import org.apache.flink.table.planner.expressions.converter.converters.JsonArrayConverter;
import org.apache.flink.table.planner.expressions.converter.converters.JsonExistsConverter;
import org.apache.flink.table.planner.expressions.converter.converters.JsonObjectConverter;
import org.apache.flink.table.planner.expressions.converter.converters.JsonQueryConverter;
import org.apache.flink.table.planner.expressions.converter.converters.JsonValueConverter;
import org.apache.flink.table.planner.expressions.converter.converters.MapConverter;
import org.apache.flink.table.planner.expressions.converter.converters.NotBetweenConverter;
import org.apache.flink.table.planner.expressions.converter.converters.OrderAscConverter;
import org.apache.flink.table.planner.expressions.converter.converters.PlusConverter;
import org.apache.flink.table.planner.expressions.converter.converters.ReinterpretCastConverter;
import org.apache.flink.table.planner.expressions.converter.converters.ReplaceConverter;
import org.apache.flink.table.planner.expressions.converter.converters.RowConverter;
import org.apache.flink.table.planner.expressions.converter.converters.SqrtConverter;
import org.apache.flink.table.planner.expressions.converter.converters.TemporalOverlapsConverter;
import org.apache.flink.table.planner.expressions.converter.converters.ThrowExceptionConverter;
import org.apache.flink.table.planner.expressions.converter.converters.TimestampDiffConverter;
import org.apache.flink.table.planner.expressions.converter.converters.TrimConverter;
import org.apache.flink.table.planner.expressions.converter.converters.TryCastConverter;
import org.apache.flink.table.planner.functions.InternalFunctionDefinitions;

@Internal
public class CustomizedConverters {
    private static final Map<FunctionDefinition, CustomizedConverter> CONVERTERS = new HashMap<FunctionDefinition, CustomizedConverter>();

    public Optional<CustomizedConverter> getConverter(FunctionDefinition functionDefinition) {
        return Optional.ofNullable(CONVERTERS.get(functionDefinition));
    }

    static {
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.CAST, new CastConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.TRY_CAST, new TryCastConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.REINTERPRET_CAST, new ReinterpretCastConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.IN, new InConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.GET, new GetConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.TRIM, new TrimConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.AS, new AsConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.BETWEEN, new BetweenConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.NOT_BETWEEN, new NotBetweenConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.REPLACE, new ReplaceConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.PLUS, new PlusConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.TEMPORAL_OVERLAPS, new TemporalOverlapsConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.TIMESTAMP_DIFF, new TimestampDiffConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.ARRAY, new ArrayConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.MAP, new MapConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.ROW, new RowConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.ORDER_ASC, new OrderAscConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.SQRT, new SqrtConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_JSON, new IsJsonConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.JSON_EXISTS, new JsonExistsConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.JSON_VALUE, new JsonValueConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.JSON_QUERY, new JsonQueryConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.JSON_OBJECT, new JsonObjectConverter());
        CONVERTERS.put((FunctionDefinition)BuiltInFunctionDefinitions.JSON_ARRAY, new JsonArrayConverter());
        CONVERTERS.put((FunctionDefinition)InternalFunctionDefinitions.THROW_EXCEPTION, new ThrowExceptionConverter());
    }
}

