/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.ExplainFormat;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.InternalPlan;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.delegation.DefaultExecutor;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.ExecNodeGraphInternalPlan;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodePlanDumper;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.optimize.StreamCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTraitDef$;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.DummyStreamExecutionEnvironment;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001\u0002\t\u0012\u0001yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tS\u0001\u0011\t\u0011)A\u0005U!I\u0001\u0007\u0001B\u0001B\u0003%\u0011g\u000e\u0005\nq\u0001\u0011\t\u0011)A\u0005s}B\u0011\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011#\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019CQA\u0014\u0001\u0005\u0002=CQa\u0016\u0001\u0005RaCQa\u001d\u0001\u0005RQDQ\u0001 \u0001\u0005RuDq!!\u000b\u0001\t#\nY\u0003C\u0004\u0002d\u0001!\t%!\u001a\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011Q\u0015\u0001\u0005B\u0005\u001d\u0006bBAZ\u0001\u0011\u0005\u0013Q\u0017\u0002\u000e'R\u0014X-Y7QY\u0006tg.\u001a:\u000b\u0005I\u0019\u0012A\u00033fY\u0016<\u0017\r^5p]*\u0011A#F\u0001\ba2\fgN\\3s\u0015\t1r#A\u0003uC\ndWM\u0003\u0002\u00193\u0005)a\r\\5oW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\nS\"A\t\n\u0005\t\n\"a\u0003)mC:tWM\u001d\"bg\u0016\f\u0001\"\u001a=fGV$xN\u001d\t\u0003K\u001dj\u0011A\n\u0006\u0003%UI!\u0001\u000b\u0014\u0003\u0011\u0015CXmY;u_J\f1\u0002^1cY\u0016\u001cuN\u001c4jOB\u00111FL\u0007\u0002Y)\u0011Q&F\u0001\u0004CBL\u0017BA\u0018-\u0005-!\u0016M\u00197f\u0007>tg-[4\u0002\u001b5|G-\u001e7f\u001b\u0006t\u0017mZ3s!\t\u0011T'D\u00014\u0015\t!T#\u0001\u0004n_\u0012,H.Z\u0005\u0003mM\u0012Q\"T8ek2,W*\u00198bO\u0016\u0014\u0018B\u0001\u0019\"\u0003=1WO\\2uS>t7)\u0019;bY><\u0007C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0016\u0003\u001d\u0019\u0017\r^1m_\u001eL!AP\u001e\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001eL!\u0001O\u0011\u0002\u001d\r\fG/\u00197pO6\u000bg.Y4feB\u0011!HQ\u0005\u0003\u0007n\u0012abQ1uC2|w-T1oC\u001e,'/\u0003\u0002AC\u0005Y1\r\\1tg2{\u0017\rZ3s!\t9E*D\u0001I\u0015\tI%*\u0001\u0003mC:<'\"A&\u0002\t)\fg/Y\u0005\u0003\u001b\"\u00131b\u00117bgNdu.\u00193fe\u00061A(\u001b8jiz\"r\u0001U)S'R+f\u000b\u0005\u0002!\u0001!)1e\u0002a\u0001I!)\u0011f\u0002a\u0001U!)\u0001g\u0002a\u0001c!)\u0001h\u0002a\u0001s!)\u0001i\u0002a\u0001\u0003\")Qi\u0002a\u0001\r\u0006aq-\u001a;Ue\u0006LG\u000fR3ggV\t\u0011\fE\u0002[;~k\u0011a\u0017\u0006\u00029\u0006)1oY1mC&\u0011al\u0017\u0002\u0006\u0003J\u0014\u0018-\u001f\u0019\u0003A*\u00042!\u00194i\u001b\u0005\u0011'BA2e\u0003\u0011\u0001H.\u00198\u000b\u0005\u0015L\u0012aB2bY\u000eLG/Z\u0005\u0003O\n\u00141BU3m)J\f\u0017\u000e\u001e#fMB\u0011\u0011N\u001b\u0007\u0001\t%Y\u0007\"!A\u0001\u0002\u000b\u0005ANA\u0002`IE\n\"!\u001c9\u0011\u0005is\u0017BA8\\\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!Y9\n\u0005I\u0014'\u0001\u0003*fYR\u0013\u0018-\u001b;\u0002\u0019\u001d,Go\u00149uS6L'0\u001a:\u0016\u0003U\u0004\"A\u001e>\u000e\u0003]T!\u0001_=\u0002\u0011=\u0004H/[7ju\u0016T!aY\n\n\u0005m<(!C(qi&l\u0017N_3s\u0003i9W\r^#yK\u000etu\u000eZ3He\u0006\u0004\b\u000e\u0015:pG\u0016\u001c8o\u001c:t+\u0005q\b#B@\u0002\u0010\u0005Ua\u0002BA\u0001\u0003\u0017qA!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fi\u0012A\u0002\u001fs_>$h(C\u0001]\u0013\r\tiaW\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t\"a\u0005\u0003\u0007M+\u0017OC\u0002\u0002\u000em\u0003B!a\u0006\u0002&5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0005qe>\u001cWm]:pe*!\u0011qDA\u0011\u0003\u0011)\u00070Z2\u000b\u0007\u0005\r\u00120A\u0003o_\u0012,7/\u0003\u0003\u0002(\u0005e!AF#yK\u000etu\u000eZ3He\u0006\u0004\b\u000e\u0015:pG\u0016\u001c8o\u001c:\u0002\u001fQ\u0014\u0018M\\:mCR,Gk\u001c)mC:$B!!\f\u0002XA1\u0011qFA\u001b\u0003si!!!\r\u000b\u0007\u0005M\"*\u0001\u0003vi&d\u0017\u0002BA\u001c\u0003c\u0011A\u0001T5tiB\"\u00111HA&!\u0019\ti$!\u0012\u0002J5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0002eC\u001eT!!L\f\n\t\u0005\u001d\u0013q\b\u0002\u000f)J\fgn\u001d4pe6\fG/[8o!\rI\u00171\n\u0003\f\u0003\u001bZ\u0011\u0011!A\u0001\u0006\u0003\tyEA\u0002`II\n2!\\A)!\rQ\u00161K\u0005\u0004\u0003+Z&aA!os\"9\u0011\u0011L\u0006A\u0002\u0005m\u0013!C3yK\u000e<%/\u00199i!\u0011\ti&a\u0018\u000e\u0005\u0005u\u0011\u0002BA1\u0003;\u0011Q\"\u0012=fG:{G-Z$sCBD\u0017aB3ya2\f\u0017N\u001c\u000b\t\u0003O\n9(a\"\u0002\u0012B!\u0011\u0011NA9\u001d\u0011\tY'!\u001c\u0011\u0007\u0005\r1,C\u0002\u0002pm\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA:\u0003k\u0012aa\u0015;sS:<'bAA87\"9\u0011\u0011\u0010\u0007A\u0002\u0005m\u0014AC8qKJ\fG/[8ogB1\u0011qFA\u001b\u0003{\u0002B!a \u0002\u00046\u0011\u0011\u0011\u0011\u0006\u0004\u0003s*\u0012\u0002BAC\u0003\u0003\u0013\u0011b\u00149fe\u0006$\u0018n\u001c8\t\u000f\u0005%E\u00021\u0001\u0002\f\u00061am\u001c:nCR\u00042aKAG\u0013\r\ty\t\f\u0002\u000e\u000bb\u0004H.Y5o\r>\u0014X.\u0019;\t\u000f\u0005ME\u00021\u0001\u0002\u0016\u0006aQ\r\u001f;sC\u0012+G/Y5mgB)!,a&\u0002\u001c&\u0019\u0011\u0011T.\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0002,\u0003;K1!a(-\u00055)\u0005\u0010\u001d7bS:$U\r^1jY\u0006\u00112M]3bi\u0016$U/\\7z!2\fgN\\3s)\u0005\u0001\u0016aC3ya2\f\u0017N\u001c)mC:$b!a\u001a\u0002*\u0006E\u0006BB2\u000f\u0001\u0004\tY\u000bE\u0002&\u0003[K1!a,'\u00051Ie\u000e^3s]\u0006d\u0007\u000b\\1o\u0011\u001d\t\u0019J\u0004a\u0001\u0003+\u000b\u0011CY3g_J,GK]1og2\fG/[8o)\t\t9\fE\u0002[\u0003sK1!a/\\\u0005\u0011)f.\u001b;")
public class StreamPlanner
extends PlannerBase {
    private final Executor executor;
    private final TableConfig tableConfig;
    private final ClassLoader classLoader;

    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), MiniBatchIntervalTraitDef$.MODULE$.INSTANCE(), ModifyKindSetTraitDef$.MODULE$.INSTANCE(), UpdateKindTraitDef$.MODULE$.INSTANCE()});
    }

    @Override
    public Optimizer getOptimizer() {
        return new StreamCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public List<Transformation<?>> translateToPlan(ExecNodeGraph execGraph) {
        this.beforeTranslation();
        StreamPlanner planner = this.createDummyPlanner();
        Buffer transformations = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execGraph.getRootNodes()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecNode execNode = x0$1;
            if (execNode instanceof StreamExecNode) {
                StreamExecNode streamExecNode = (StreamExecNode)execNode;
                return streamExecNode.translateToPlan(planner);
            }
            throw new TableException("Cannot generate DataStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
        }, Buffer$.MODULE$.canBuildFrom());
        this.afterTranslation();
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(transformations.$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(planner.extraTransformations())));
    }

    public String explain(List<Operation> operations, ExplainFormat format, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        ExplainFormat explainFormat = format;
        ExplainFormat explainFormat2 = ExplainFormat.TEXT;
        if (explainFormat == null ? explainFormat2 != null : !explainFormat.equals(explainFormat2)) {
            throw new UnsupportedOperationException(new java.lang.StringBuilder(29).append("Unsupported explain format [").append(format.getClass().getCanonicalName()).append("]").toString());
        }
        Tuple4<Buffer<RelNode>, Seq<RelNode>, ExecNodeGraph, StreamGraph> tuple4 = this.getExplainGraphs(operations);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Buffer sinkRelNodes = (Buffer)tuple4._1();
        Seq optimizedRelNodes = (Seq)tuple4._2();
        ExecNodeGraph execGraph = (ExecNodeGraph)tuple4._3();
        StreamGraph streamGraph = (StreamGraph)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)sinkRelNodes, (Object)optimizedRelNodes, (Object)execGraph, (Object)streamGraph);
        Buffer sinkRelNodes2 = (Buffer)tuple42._1();
        Seq optimizedRelNodes2 = (Seq)tuple42._2();
        ExecNodeGraph execGraph2 = (ExecNodeGraph)tuple42._3();
        StreamGraph streamGraph2 = (StreamGraph)tuple42._4();
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes2.foreach((Function1 & Serializable & scala.Serializable)sink -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)sink, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()));
            return sb.append(System.lineSeparator());
        });
        boolean withAdvice = extraDetails.contains((Object)ExplainDetail.PLAN_ADVICE);
        StringBuilder stringBuilder = withAdvice ? sb.append("== Optimized Physical Plan With Advice ==") : sb.append("== Optimized Physical Plan ==");
        sb.append(System.lineSeparator());
        SqlExplainLevel explainLevel = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST) ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.DIGEST_ATTRIBUTES;
        boolean withChangelogTraits = extraDetails.contains((Object)ExplainDetail.CHANGELOG_MODE);
        if (withAdvice) {
            boxedUnit2 = sb.append(FlinkRelOptUtil$.MODULE$.toString((Seq<RelNode>)optimizedRelNodes2, explainLevel, withChangelogTraits, true));
        } else {
            optimizedRelNodes2.foreach((Function1 & Serializable & scala.Serializable)rel -> {
                RelNode x$1 = rel;
                SqlExplainLevel x$2 = explainLevel;
                boolean x$3 = withChangelogTraits;
                boolean x$4 = FlinkRelOptUtil$.MODULE$.toString$default$3();
                boolean x$5 = FlinkRelOptUtil$.MODULE$.toString$default$5();
                boolean x$6 = FlinkRelOptUtil$.MODULE$.toString$default$6();
                boolean x$7 = FlinkRelOptUtil$.MODULE$.toString$default$7();
                sb.append(FlinkRelOptUtil$.MODULE$.toString(x$1, x$2, x$4, x$3, x$5, x$6, x$7));
                return sb.append(System.lineSeparator());
            });
            boxedUnit2 = BoxedUnit.UNIT;
        }
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph2));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph2.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    private StreamPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecEnv());
        DefaultExecutor executor = new DefaultExecutor(dummyExecEnv);
        return new StreamPlanner(executor, this.tableConfig, super.moduleManager(), super.functionCatalog(), super.catalogManager(), this.classLoader);
    }

    public String explainPlan(InternalPlan plan, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        this.beforeTranslation();
        ExecNodeGraph execGraph = ((ExecNodeGraphInternalPlan)plan).getExecNodeGraph();
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.afterTranslation();
        StreamGraph streamGraph = (StreamGraph)this.executor.createPipeline(transformations, (ReadableConfig)this.tableConfig.getConfiguration(), null);
        StringBuilder sb = new StringBuilder();
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    @Override
    public void beforeTranslation() {
        RuntimeExecutionMode runtimeMode;
        super.beforeTranslation();
        RuntimeExecutionMode runtimeExecutionMode = runtimeMode = (RuntimeExecutionMode)this.getTableConfig().get(ExecutionOptions.RUNTIME_MODE);
        RuntimeExecutionMode runtimeExecutionMode2 = RuntimeExecutionMode.STREAMING;
        if (runtimeExecutionMode == null ? runtimeExecutionMode2 != null : !runtimeExecutionMode.equals(runtimeExecutionMode2)) {
            throw new IllegalArgumentException("Mismatch between configured runtime mode and actual runtime mode. Currently, the 'execution.runtime-mode' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        }
    }

    public String explainPlan(InternalPlan plan, ExplainDetail[] extraDetails) {
        return this.explainPlan(plan, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public String explain(List<Operation> operations, ExplainFormat format, ExplainDetail[] extraDetails) {
        return this.explain(operations, format, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public StreamPlanner(Executor executor, TableConfig tableConfig, ModuleManager moduleManager, FunctionCatalog functionCatalog, CatalogManager catalogManager, ClassLoader classLoader) {
        this.executor = executor;
        this.tableConfig = tableConfig;
        this.classLoader = classLoader;
        super(executor, tableConfig, moduleManager, functionCatalog, catalogManager, true, classLoader);
    }
}

