/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.SqlUnparseUtils;

public class SqlAlterModel
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ALTER MODEL", SqlKind.OTHER_DDL);
    protected final SqlIdentifier modelName;
    protected final SqlIdentifier newModelName;
    protected final boolean ifModelExists;
    private final SqlNodeList propertyList;

    public SqlAlterModel(SqlParserPos pos, SqlIdentifier modelName, SqlNodeList propertyList, boolean ifModelExists) {
        super(pos);
        this.modelName = Objects.requireNonNull(modelName, "modelName should not be null");
        this.newModelName = null;
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList should not be null");
        this.ifModelExists = ifModelExists;
    }

    public SqlAlterModel(SqlParserPos pos, SqlIdentifier modelName, SqlIdentifier newModelName, boolean ifModelExists) {
        super(pos);
        this.modelName = Objects.requireNonNull(modelName, "modelName should not be null");
        this.newModelName = Objects.requireNonNull(newModelName, "newModelName should not be null");
        this.propertyList = null;
        this.ifModelExists = ifModelExists;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public SqlIdentifier getModelName() {
        return this.modelName;
    }

    public String[] fullModelName() {
        return this.modelName.names.toArray(new String[0]);
    }

    public boolean ifModelExists() {
        return this.ifModelExists;
    }

    public SqlIdentifier getNewModelName() {
        return this.newModelName;
    }

    public String[] fullNewModelName() {
        if (this.newModelName != null) {
            return this.newModelName.names.toArray(new String[0]);
        }
        return new String[0];
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    @Override
    public List<SqlNode> getOperandList() {
        if (this.newModelName != null) {
            return ImmutableNullableList.of(this.modelName, this.newModelName);
        }
        return ImmutableNullableList.of(this.modelName, this.propertyList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER MODEL");
        if (this.ifModelExists) {
            writer.keyword("IF EXISTS");
        }
        this.modelName.unparse(writer, leftPrec, rightPrec);
        if (this.newModelName != null) {
            writer.keyword("RENAME TO");
            this.newModelName.unparse(writer, leftPrec, rightPrec);
        } else {
            writer.keyword("SET");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            if (this.propertyList != null) {
                for (SqlNode modelOption : this.propertyList) {
                    SqlUnparseUtils.printIndent(writer);
                    modelOption.unparse(writer, leftPrec, rightPrec);
                }
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }
}

