/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.config.CharLiteralStyle;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.Static;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlAbstractParserImpl {
    private static final ImmutableSet<String> SQL_92_RESERVED_WORD_SET = ImmutableSet.of("ABSOLUTE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", new String[]{"AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONDITION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTAINS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DETERMINISTIC", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INADD", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUT", "OUTADD", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARAMETER", "PARTIAL", "PATH", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "ROUTINE", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SQL", "SQLCODE", "SQLERROR", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"});
    protected int nDynamicParams;
    protected @Nullable String originalSql;
    protected final List<CalciteContextException> warnings = new ArrayList<CalciteContextException>();

    public static Set<String> getSql92ReservedWords() {
        return SQL_92_RESERVED_WORD_SET;
    }

    protected SqlCall createCall(SqlIdentifier funName, SqlParserPos pos, SqlFunctionCategory funcType, SqlLiteral functionQualifier, Iterable<? extends SqlNode> operands) {
        return this.createCall(funName, pos, funcType, functionQualifier, Iterables.toArray(operands, SqlNode.class));
    }

    protected SqlCall createCall(SqlIdentifier funName, SqlParserPos pos, SqlFunctionCategory funcType, SqlLiteral functionQualifier, SqlNode[] operands) {
        SqlUnresolvedFunction fun = new SqlUnresolvedFunction(funName, null, null, null, null, funcType);
        return fun.createCall(functionQualifier, pos, operands);
    }

    public abstract Metadata getMetadata();

    public abstract SqlParseException normalizeException(@Nullable Throwable var1);

    protected abstract SqlParserPos getPos() throws Exception;

    public abstract void ReInit(Reader var1);

    public abstract SqlNode parseSqlExpressionEof() throws Exception;

    public abstract SqlNode parseSqlStmtEof() throws Exception;

    public abstract SqlNodeList parseSqlStmtList() throws Exception;

    public abstract void setTabSize(int var1);

    public abstract void setQuotedCasing(Casing var1);

    public abstract void setUnquotedCasing(Casing var1);

    public abstract void setIdentifierMaxLength(int var1);

    @Deprecated
    public void setTimeUnitCodes(Map<String, TimeUnit> timeUnitCodes) {
    }

    public abstract void setConformance(SqlConformance var1);

    public abstract SqlNode parseArray() throws SqlParseException;

    public void setOriginalSql(String originalSql) {
        this.originalSql = originalSql;
    }

    public @Nullable String getOriginalSql() {
        return this.originalSql;
    }

    public abstract void switchTo(LexicalState var1);

    public static class MetadataImpl
    implements Metadata {
        private final Set<String> reservedFunctionNames = new HashSet<String>();
        private final Set<String> contextVariableNames = new HashSet<String>();
        private final Set<String> nonReservedKeyWordSet = new HashSet<String>();
        private final NavigableSet<String> tokenSet = new TreeSet<String>();
        private final List<String> tokenList;
        private final Set<String> reservedWords = new HashSet<String>();
        private final String sql92ReservedWords;

        public MetadataImpl(SqlAbstractParserImpl sqlParser) {
            this.initList(sqlParser, this.reservedFunctionNames, "ReservedFunctionName");
            this.initList(sqlParser, this.contextVariableNames, "ContextVariable");
            this.initList(sqlParser, this.nonReservedKeyWordSet, "NonReservedKeyWord");
            this.tokenList = ImmutableList.copyOf(this.tokenSet);
            this.sql92ReservedWords = this.constructSql92ReservedWordList();
            TreeSet<String> reservedWordSet = new TreeSet<String>();
            reservedWordSet.addAll(this.tokenSet);
            reservedWordSet.removeAll(this.nonReservedKeyWordSet);
            this.reservedWords.addAll(reservedWordSet);
        }

        private void initList(@UnderInitialization MetadataImpl this, SqlAbstractParserImpl parserImpl, Set<String> keywords, String name) {
            parserImpl.ReInit(new StringReader("1"));
            try {
                Object o = this.virtualCall(parserImpl, name);
                throw new AssertionError((Object)("expected call to fail, got " + o));
            }
            catch (SqlParseException parseException) {
                int[][] expectedTokenSequences;
                String[] tokenImages = parseException.getTokenImages();
                if (this.tokenSet.isEmpty()) {
                    for (String token : tokenImages) {
                        String tokenVal = SqlParserUtil.getTokenVal(token);
                        if (tokenVal == null) continue;
                        this.tokenSet.add(tokenVal);
                    }
                }
                for (int[] tokens : expectedTokenSequences = parseException.getExpectedTokenSequences()) {
                    assert (tokens.length == 1);
                    int tokenId = tokens[0];
                    String token = tokenImages[tokenId];
                    String tokenVal = SqlParserUtil.getTokenVal(token);
                    if (tokenVal == null) continue;
                    keywords.add(tokenVal);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("While building token lists", e);
            }
        }

        private @Nullable Object virtualCall(@UnderInitialization MetadataImpl this, SqlAbstractParserImpl parserImpl, String name) throws Throwable {
            Class<?> clazz = parserImpl.getClass();
            try {
                Method method = clazz.getMethod(name, new Class[0]);
                return method.invoke((Object)parserImpl, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw parserImpl.normalizeException(cause);
            }
        }

        private String constructSql92ReservedWordList(@UnderInitialization MetadataImpl this) {
            StringBuilder sb = new StringBuilder();
            TreeSet<String> jdbcReservedSet = new TreeSet<String>();
            jdbcReservedSet.addAll(this.tokenSet);
            jdbcReservedSet.removeAll(SQL_92_RESERVED_WORD_SET);
            jdbcReservedSet.removeAll(this.nonReservedKeyWordSet);
            int j = 0;
            for (String jdbcReserved : jdbcReservedSet) {
                if (j++ > 0) {
                    sb.append(",");
                }
                sb.append(jdbcReserved);
            }
            return sb.toString();
        }

        @Override
        public List<String> getTokens() {
            return this.tokenList;
        }

        @Override
        public boolean isSql92ReservedWord(String token) {
            return SQL_92_RESERVED_WORD_SET.contains(token);
        }

        @Override
        public String getJdbcKeywords() {
            return this.sql92ReservedWords;
        }

        @Override
        public boolean isKeyword(String token) {
            return this.isNonReservedKeyword(token) || this.isReservedFunctionName(token) || this.isContextVariableName(token) || this.isReservedWord(token);
        }

        @Override
        public boolean isNonReservedKeyword(String token) {
            return this.nonReservedKeyWordSet.contains(token);
        }

        @Override
        public boolean isReservedFunctionName(String token) {
            return this.reservedFunctionNames.contains(token);
        }

        @Override
        public boolean isContextVariableName(String token) {
            return this.contextVariableNames.contains(token);
        }

        @Override
        public boolean isReservedWord(String token) {
            return this.reservedWords.contains(token);
        }
    }

    public static interface Metadata {
        public boolean isNonReservedKeyword(String var1);

        public boolean isContextVariableName(String var1);

        public boolean isReservedFunctionName(String var1);

        public boolean isKeyword(String var1);

        public boolean isReservedWord(String var1);

        public boolean isSql92ReservedWord(String var1);

        public String getJdbcKeywords();

        public List<String> getTokens();
    }

    public static enum LexicalState {
        DEFAULT,
        DQID,
        BTID,
        BQID;


        public static LexicalState forConfig(SqlParser.Config config) {
            switch (config.quoting()) {
                case BRACKET: {
                    return DEFAULT;
                }
                case DOUBLE_QUOTE: {
                    return DQID;
                }
                case BACK_TICK_BACKSLASH: {
                    return BQID;
                }
                case BACK_TICK: {
                    if (config.conformance().allowHyphenInUnquotedTableName() && config.charLiteralStyles().equals(EnumSet.of(CharLiteralStyle.BQ_SINGLE, CharLiteralStyle.BQ_DOUBLE))) {
                        return BQID;
                    }
                    if (config.conformance().allowHyphenInUnquotedTableName() || !config.charLiteralStyles().equals(EnumSet.of(CharLiteralStyle.STANDARD))) break;
                    return BTID;
                }
            }
            throw new AssertionError(config);
        }
    }

    protected static enum ExprContext {
        ACCEPT_ALL,
        ACCEPT_NONCURSOR,
        ACCEPT_QUERY,
        ACCEPT_QUERY_OR_JOIN,
        ACCEPT_NON_QUERY,
        ACCEPT_SUB_QUERY,
        ACCEPT_CURSOR;

        @Deprecated
        public static final ExprContext ACCEPT_SUBQUERY;
        @Deprecated
        public static final ExprContext ACCEPT_NONQUERY;

        public void throwIfNotCompatible(SqlNode e) {
            switch (this) {
                case ACCEPT_NON_QUERY: 
                case ACCEPT_SUB_QUERY: 
                case ACCEPT_CURSOR: {
                    if (!e.isA(SqlKind.QUERY)) break;
                    throw SqlUtil.newContextException(e.getParserPosition(), Static.RESOURCE.illegalQueryExpression());
                }
                case ACCEPT_QUERY: {
                    if (e.isA(SqlKind.QUERY)) break;
                    throw SqlUtil.newContextException(e.getParserPosition(), Static.RESOURCE.illegalNonQueryExpression());
                }
                case ACCEPT_QUERY_OR_JOIN: {
                    if (e.isA(SqlKind.QUERY) || e.getKind() == SqlKind.JOIN) break;
                    throw SqlUtil.newContextException(e.getParserPosition(), Static.RESOURCE.expectedQueryOrJoinExpression());
                }
            }
        }

        static {
            ACCEPT_SUBQUERY = ACCEPT_SUB_QUERY;
            ACCEPT_NONQUERY = ACCEPT_NON_QUERY;
        }
    }
}

