/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.ShowCreateUtil;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ShowOperation;
import org.apache.flink.util.Preconditions;

@Internal
public class ShowCreateCatalogOperation
implements ShowOperation {
    private final String catalogName;

    public ShowCreateCatalogOperation(String catalogName) {
        this.catalogName = (String)Preconditions.checkNotNull((Object)catalogName, (String)"Catalog name must not be null");
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String asSummaryString() {
        return String.format("SHOW CREATE CATALOG %s", this.catalogName);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        CatalogDescriptor catalogDescriptor = ctx.getCatalogManager().getCatalogDescriptor(this.catalogName).orElseThrow(() -> new ValidationException(String.format("Cannot obtain metadata information from Catalog %s.", this.catalogName)));
        String resultRow = ShowCreateUtil.buildShowCreateCatalogRow(catalogDescriptor);
        return TableResultUtils.buildStringArrayResult("result", new String[]{resultRow});
    }
}

