/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.common.collect.ImmutableSet;

final class AutoValue_AsyncWriteChannelOptions
extends AsyncWriteChannelOptions {
    private final int bufferSize;
    private final int pipeBufferSize;
    private final AsyncWriteChannelOptions.PipeType pipeType;
    private final int uploadChunkSize;
    private final int uploadCacheSize;
    private final boolean directUploadEnabled;
    private final boolean grpcChecksumsEnabled;
    private final long grpcWriteTimeout;
    private final long numberOfBufferedRequests;
    private final long grpcWriteMessageTimeoutMillis;
    private final AsyncWriteChannelOptions.UploadType uploadType;
    private final AsyncWriteChannelOptions.PartFileCleanupType partFileCleanupType;
    private final ImmutableSet<String> temporaryPaths;
    private final int PCUBufferCount;
    private final int PCUBufferCapacity;
    private final String partFileNamePrefix;

    private AutoValue_AsyncWriteChannelOptions(int bufferSize, int pipeBufferSize, AsyncWriteChannelOptions.PipeType pipeType, int uploadChunkSize, int uploadCacheSize, boolean directUploadEnabled, boolean grpcChecksumsEnabled, long grpcWriteTimeout, long numberOfBufferedRequests, long grpcWriteMessageTimeoutMillis, AsyncWriteChannelOptions.UploadType uploadType, AsyncWriteChannelOptions.PartFileCleanupType partFileCleanupType, ImmutableSet<String> temporaryPaths, int PCUBufferCount, int PCUBufferCapacity, String partFileNamePrefix) {
        this.bufferSize = bufferSize;
        this.pipeBufferSize = pipeBufferSize;
        this.pipeType = pipeType;
        this.uploadChunkSize = uploadChunkSize;
        this.uploadCacheSize = uploadCacheSize;
        this.directUploadEnabled = directUploadEnabled;
        this.grpcChecksumsEnabled = grpcChecksumsEnabled;
        this.grpcWriteTimeout = grpcWriteTimeout;
        this.numberOfBufferedRequests = numberOfBufferedRequests;
        this.grpcWriteMessageTimeoutMillis = grpcWriteMessageTimeoutMillis;
        this.uploadType = uploadType;
        this.partFileCleanupType = partFileCleanupType;
        this.temporaryPaths = temporaryPaths;
        this.PCUBufferCount = PCUBufferCount;
        this.PCUBufferCapacity = PCUBufferCapacity;
        this.partFileNamePrefix = partFileNamePrefix;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public int getPipeBufferSize() {
        return this.pipeBufferSize;
    }

    @Override
    public AsyncWriteChannelOptions.PipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public int getUploadChunkSize() {
        return this.uploadChunkSize;
    }

    @Override
    public int getUploadCacheSize() {
        return this.uploadCacheSize;
    }

    @Override
    public boolean isDirectUploadEnabled() {
        return this.directUploadEnabled;
    }

    @Override
    public boolean isGrpcChecksumsEnabled() {
        return this.grpcChecksumsEnabled;
    }

    @Override
    public long getGrpcWriteTimeout() {
        return this.grpcWriteTimeout;
    }

    @Override
    public long getNumberOfBufferedRequests() {
        return this.numberOfBufferedRequests;
    }

    @Override
    public long getGrpcWriteMessageTimeoutMillis() {
        return this.grpcWriteMessageTimeoutMillis;
    }

    @Override
    public AsyncWriteChannelOptions.UploadType getUploadType() {
        return this.uploadType;
    }

    @Override
    public AsyncWriteChannelOptions.PartFileCleanupType getPartFileCleanupType() {
        return this.partFileCleanupType;
    }

    @Override
    public ImmutableSet<String> getTemporaryPaths() {
        return this.temporaryPaths;
    }

    @Override
    public int getPCUBufferCount() {
        return this.PCUBufferCount;
    }

    @Override
    public int getPCUBufferCapacity() {
        return this.PCUBufferCapacity;
    }

    @Override
    public String getPartFileNamePrefix() {
        return this.partFileNamePrefix;
    }

    public String toString() {
        return "AsyncWriteChannelOptions{bufferSize=" + this.bufferSize + ", pipeBufferSize=" + this.pipeBufferSize + ", pipeType=" + (Object)((Object)this.pipeType) + ", uploadChunkSize=" + this.uploadChunkSize + ", uploadCacheSize=" + this.uploadCacheSize + ", directUploadEnabled=" + this.directUploadEnabled + ", grpcChecksumsEnabled=" + this.grpcChecksumsEnabled + ", grpcWriteTimeout=" + this.grpcWriteTimeout + ", numberOfBufferedRequests=" + this.numberOfBufferedRequests + ", grpcWriteMessageTimeoutMillis=" + this.grpcWriteMessageTimeoutMillis + ", uploadType=" + (Object)((Object)this.uploadType) + ", partFileCleanupType=" + (Object)((Object)this.partFileCleanupType) + ", temporaryPaths=" + this.temporaryPaths + ", PCUBufferCount=" + this.PCUBufferCount + ", PCUBufferCapacity=" + this.PCUBufferCapacity + ", partFileNamePrefix=" + this.partFileNamePrefix + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AsyncWriteChannelOptions) {
            AsyncWriteChannelOptions that = (AsyncWriteChannelOptions)o;
            return this.bufferSize == that.getBufferSize() && this.pipeBufferSize == that.getPipeBufferSize() && this.pipeType.equals((Object)that.getPipeType()) && this.uploadChunkSize == that.getUploadChunkSize() && this.uploadCacheSize == that.getUploadCacheSize() && this.directUploadEnabled == that.isDirectUploadEnabled() && this.grpcChecksumsEnabled == that.isGrpcChecksumsEnabled() && this.grpcWriteTimeout == that.getGrpcWriteTimeout() && this.numberOfBufferedRequests == that.getNumberOfBufferedRequests() && this.grpcWriteMessageTimeoutMillis == that.getGrpcWriteMessageTimeoutMillis() && this.uploadType.equals((Object)that.getUploadType()) && this.partFileCleanupType.equals((Object)that.getPartFileCleanupType()) && this.temporaryPaths.equals(that.getTemporaryPaths()) && this.PCUBufferCount == that.getPCUBufferCount() && this.PCUBufferCapacity == that.getPCUBufferCapacity() && this.partFileNamePrefix.equals(that.getPartFileNamePrefix());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.bufferSize;
        h$ *= 1000003;
        h$ ^= this.pipeBufferSize;
        h$ *= 1000003;
        h$ ^= this.pipeType.hashCode();
        h$ *= 1000003;
        h$ ^= this.uploadChunkSize;
        h$ *= 1000003;
        h$ ^= this.uploadCacheSize;
        h$ *= 1000003;
        h$ ^= this.directUploadEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.grpcChecksumsEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.grpcWriteTimeout >>> 32 ^ this.grpcWriteTimeout);
        h$ *= 1000003;
        h$ ^= (int)(this.numberOfBufferedRequests >>> 32 ^ this.numberOfBufferedRequests);
        h$ *= 1000003;
        h$ ^= (int)(this.grpcWriteMessageTimeoutMillis >>> 32 ^ this.grpcWriteMessageTimeoutMillis);
        h$ *= 1000003;
        h$ ^= this.uploadType.hashCode();
        h$ *= 1000003;
        h$ ^= this.partFileCleanupType.hashCode();
        h$ *= 1000003;
        h$ ^= this.temporaryPaths.hashCode();
        h$ *= 1000003;
        h$ ^= this.PCUBufferCount;
        h$ *= 1000003;
        h$ ^= this.PCUBufferCapacity;
        h$ *= 1000003;
        return h$ ^= this.partFileNamePrefix.hashCode();
    }

    @Override
    public AsyncWriteChannelOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AsyncWriteChannelOptions.Builder {
        private int bufferSize;
        private int pipeBufferSize;
        private AsyncWriteChannelOptions.PipeType pipeType;
        private int uploadChunkSize;
        private int uploadCacheSize;
        private boolean directUploadEnabled;
        private boolean grpcChecksumsEnabled;
        private long grpcWriteTimeout;
        private long numberOfBufferedRequests;
        private long grpcWriteMessageTimeoutMillis;
        private AsyncWriteChannelOptions.UploadType uploadType;
        private AsyncWriteChannelOptions.PartFileCleanupType partFileCleanupType;
        private ImmutableSet<String> temporaryPaths;
        private int PCUBufferCount;
        private int PCUBufferCapacity;
        private String partFileNamePrefix;
        private short set$0;

        Builder() {
        }

        private Builder(AsyncWriteChannelOptions source) {
            this.bufferSize = source.getBufferSize();
            this.pipeBufferSize = source.getPipeBufferSize();
            this.pipeType = source.getPipeType();
            this.uploadChunkSize = source.getUploadChunkSize();
            this.uploadCacheSize = source.getUploadCacheSize();
            this.directUploadEnabled = source.isDirectUploadEnabled();
            this.grpcChecksumsEnabled = source.isGrpcChecksumsEnabled();
            this.grpcWriteTimeout = source.getGrpcWriteTimeout();
            this.numberOfBufferedRequests = source.getNumberOfBufferedRequests();
            this.grpcWriteMessageTimeoutMillis = source.getGrpcWriteMessageTimeoutMillis();
            this.uploadType = source.getUploadType();
            this.partFileCleanupType = source.getPartFileCleanupType();
            this.temporaryPaths = source.getTemporaryPaths();
            this.PCUBufferCount = source.getPCUBufferCount();
            this.PCUBufferCapacity = source.getPCUBufferCapacity();
            this.partFileNamePrefix = source.getPartFileNamePrefix();
            this.set$0 = (short)2047;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            this.set$0 = (short)(this.set$0 | 1);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setPipeBufferSize(int pipeBufferSize) {
            this.pipeBufferSize = pipeBufferSize;
            this.set$0 = (short)(this.set$0 | 2);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setPipeType(AsyncWriteChannelOptions.PipeType pipeType) {
            if (pipeType == null) {
                throw new NullPointerException("Null pipeType");
            }
            this.pipeType = pipeType;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setUploadChunkSize(int uploadChunkSize) {
            this.uploadChunkSize = uploadChunkSize;
            this.set$0 = (short)(this.set$0 | 4);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setUploadCacheSize(int uploadCacheSize) {
            this.uploadCacheSize = uploadCacheSize;
            this.set$0 = (short)(this.set$0 | 8);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setDirectUploadEnabled(boolean directUploadEnabled) {
            this.directUploadEnabled = directUploadEnabled;
            this.set$0 = (short)(this.set$0 | 0x10);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setGrpcChecksumsEnabled(boolean grpcChecksumsEnabled) {
            this.grpcChecksumsEnabled = grpcChecksumsEnabled;
            this.set$0 = (short)(this.set$0 | 0x20);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setGrpcWriteTimeout(long grpcWriteTimeout) {
            this.grpcWriteTimeout = grpcWriteTimeout;
            this.set$0 = (short)(this.set$0 | 0x40);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setNumberOfBufferedRequests(long numberOfBufferedRequests) {
            this.numberOfBufferedRequests = numberOfBufferedRequests;
            this.set$0 = (short)(this.set$0 | 0x80);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setGrpcWriteMessageTimeoutMillis(long grpcWriteMessageTimeoutMillis) {
            this.grpcWriteMessageTimeoutMillis = grpcWriteMessageTimeoutMillis;
            this.set$0 = (short)(this.set$0 | 0x100);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setUploadType(AsyncWriteChannelOptions.UploadType uploadType) {
            if (uploadType == null) {
                throw new NullPointerException("Null uploadType");
            }
            this.uploadType = uploadType;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setPartFileCleanupType(AsyncWriteChannelOptions.PartFileCleanupType partFileCleanupType) {
            if (partFileCleanupType == null) {
                throw new NullPointerException("Null partFileCleanupType");
            }
            this.partFileCleanupType = partFileCleanupType;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setTemporaryPaths(ImmutableSet<String> temporaryPaths) {
            if (temporaryPaths == null) {
                throw new NullPointerException("Null temporaryPaths");
            }
            this.temporaryPaths = temporaryPaths;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setPCUBufferCount(int PCUBufferCount) {
            this.PCUBufferCount = PCUBufferCount;
            this.set$0 = (short)(this.set$0 | 0x200);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setPCUBufferCapacity(int PCUBufferCapacity) {
            this.PCUBufferCapacity = PCUBufferCapacity;
            this.set$0 = (short)(this.set$0 | 0x400);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setPartFileNamePrefix(String partFileNamePrefix) {
            if (partFileNamePrefix == null) {
                throw new NullPointerException("Null partFileNamePrefix");
            }
            this.partFileNamePrefix = partFileNamePrefix;
            return this;
        }

        @Override
        AsyncWriteChannelOptions autoBuild() {
            if (this.set$0 != 2047 || this.pipeType == null || this.uploadType == null || this.partFileCleanupType == null || this.temporaryPaths == null || this.partFileNamePrefix == null) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" bufferSize");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" pipeBufferSize");
                }
                if (this.pipeType == null) {
                    missing.append(" pipeType");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" uploadChunkSize");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" uploadCacheSize");
                }
                if ((this.set$0 & 0x10) == 0) {
                    missing.append(" directUploadEnabled");
                }
                if ((this.set$0 & 0x20) == 0) {
                    missing.append(" grpcChecksumsEnabled");
                }
                if ((this.set$0 & 0x40) == 0) {
                    missing.append(" grpcWriteTimeout");
                }
                if ((this.set$0 & 0x80) == 0) {
                    missing.append(" numberOfBufferedRequests");
                }
                if ((this.set$0 & 0x100) == 0) {
                    missing.append(" grpcWriteMessageTimeoutMillis");
                }
                if (this.uploadType == null) {
                    missing.append(" uploadType");
                }
                if (this.partFileCleanupType == null) {
                    missing.append(" partFileCleanupType");
                }
                if (this.temporaryPaths == null) {
                    missing.append(" temporaryPaths");
                }
                if ((this.set$0 & 0x200) == 0) {
                    missing.append(" PCUBufferCount");
                }
                if ((this.set$0 & 0x400) == 0) {
                    missing.append(" PCUBufferCapacity");
                }
                if (this.partFileNamePrefix == null) {
                    missing.append(" partFileNamePrefix");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AsyncWriteChannelOptions(this.bufferSize, this.pipeBufferSize, this.pipeType, this.uploadChunkSize, this.uploadCacheSize, this.directUploadEnabled, this.grpcChecksumsEnabled, this.grpcWriteTimeout, this.numberOfBufferedRequests, this.grpcWriteMessageTimeoutMillis, this.uploadType, this.partFileCleanupType, this.temporaryPaths, this.PCUBufferCount, this.PCUBufferCapacity, this.partFileNamePrefix);
        }
    }
}

