/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input.operator.window;

import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.state.api.functions.WindowReaderFunction;
import org.apache.flink.state.api.input.operator.window.EvictingWindowReaderFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class AggregateEvictingWindowReaderFunction<IN, ACC, R, OUT, KEY, W extends Window>
extends EvictingWindowReaderFunction<IN, R, OUT, KEY, W> {
    private final AggregateFunction<IN, ACC, R> aggFunction;

    public AggregateEvictingWindowReaderFunction(WindowReaderFunction<R, OUT, KEY, W> wrappedFunction, AggregateFunction<IN, ACC, R> aggFunction) {
        super(wrappedFunction);
        this.aggFunction = aggFunction;
    }

    @Override
    public Iterable<R> transform(Iterable<StreamRecord<IN>> elements) throws Exception {
        Object acc = this.aggFunction.createAccumulator();
        for (StreamRecord<IN> element : elements) {
            acc = this.aggFunction.add(element.getValue(), acc);
        }
        Object result = this.aggFunction.getResult(acc);
        return Collections.singletonList(result);
    }
}

