/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.ProjectedRowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkUpsertMaterializer
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SinkUpsertMaterializer.class);
    private static final String STATE_CLEARED_WARN_MSG = "The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.";
    private final StateTtlConfig ttlConfig;
    private final GeneratedRecordEqualiser generatedRecordEqualiser;
    private final GeneratedRecordEqualiser generatedUpsertKeyEqualiser;
    private final TypeSerializer<RowData> serializer;
    private final int[] inputUpsertKey;
    private final boolean hasUpsertKey;
    private transient RecordEqualiser equaliser;
    private transient ValueState<List<RowData>> state;
    private transient TimestampedCollector<RowData> collector;
    private transient ProjectedRowData upsertKeyProjectedRow1;
    private transient ProjectedRowData upsertKeyProjectedRow2;

    public SinkUpsertMaterializer(StateTtlConfig ttlConfig, TypeSerializer<RowData> serializer, GeneratedRecordEqualiser generatedRecordEqualiser, @Nullable GeneratedRecordEqualiser generatedUpsertKeyEqualiser, @Nullable int[] inputUpsertKey) {
        this.ttlConfig = ttlConfig;
        this.serializer = serializer;
        this.generatedRecordEqualiser = generatedRecordEqualiser;
        this.generatedUpsertKeyEqualiser = generatedUpsertKeyEqualiser;
        this.inputUpsertKey = inputUpsertKey;
        boolean bl = this.hasUpsertKey = null != inputUpsertKey && inputUpsertKey.length > 0;
        if (this.hasUpsertKey) {
            Preconditions.checkNotNull((Object)generatedUpsertKeyEqualiser, (String)"GeneratedUpsertKeyEqualiser cannot be null when inputUpsertKey is not empty!");
        }
    }

    @Override
    public void open() throws Exception {
        super.open();
        if (this.hasUpsertKey) {
            this.equaliser = (RecordEqualiser)this.generatedUpsertKeyEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
            this.upsertKeyProjectedRow1 = ProjectedRowData.from((int[])this.inputUpsertKey);
            this.upsertKeyProjectedRow2 = ProjectedRowData.from((int[])this.inputUpsertKey);
        } else {
            this.equaliser = (RecordEqualiser)this.generatedRecordEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        }
        ValueStateDescriptor descriptor = new ValueStateDescriptor("values", (TypeSerializer)new ListSerializer(this.serializer));
        if (this.ttlConfig.isEnabled()) {
            descriptor.enableTimeToLive(this.ttlConfig);
        }
        this.state = this.getRuntimeContext().getState(descriptor);
        this.collector = new TimestampedCollector(this.output);
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        RowData row = (RowData)element.getValue();
        ArrayList<RowData> values = (ArrayList<RowData>)this.state.value();
        if (values == null) {
            values = new ArrayList<RowData>(2);
        }
        switch (row.getRowKind()) {
            case INSERT: 
            case UPDATE_AFTER: {
                this.addRow(values, row);
                break;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                this.retractRow(values, row);
            }
        }
    }

    private void addRow(List<RowData> values, RowData add) throws IOException {
        RowKind outRowKind;
        RowKind rowKind = outRowKind = values.isEmpty() ? RowKind.INSERT : RowKind.UPDATE_AFTER;
        if (this.hasUpsertKey) {
            int index = this.findFirst(values, add);
            if (index == -1) {
                values.add(add);
            } else {
                values.set(index, add);
            }
        } else {
            values.add(add);
        }
        add.setRowKind(outRowKind);
        this.collector.collect((Object)add);
        this.state.update(values);
    }

    private void retractRow(List<RowData> values, RowData retract) throws IOException {
        int lastIndex = values.size() - 1;
        int index = this.findFirst(values, retract);
        if (index == -1) {
            LOG.info(STATE_CLEARED_WARN_MSG);
            return;
        }
        values.remove(index);
        if (values.isEmpty()) {
            retract.setRowKind(RowKind.DELETE);
            this.collector.collect((Object)retract);
        } else if (index == lastIndex) {
            RowData latestRow = values.get(values.size() - 1);
            latestRow.setRowKind(RowKind.UPDATE_AFTER);
            this.collector.collect((Object)latestRow);
        }
        if (values.isEmpty()) {
            this.state.clear();
        } else {
            this.state.update(values);
        }
    }

    private int findFirst(List<RowData> values, RowData target) {
        Iterator<RowData> iterator = values.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (this.equalsIgnoreRowKind(target, iterator.next())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean equalsIgnoreRowKind(RowData newRow, RowData oldRow) {
        newRow.setRowKind(oldRow.getRowKind());
        if (this.hasUpsertKey) {
            return this.equaliser.equals((RowData)this.upsertKeyProjectedRow1.replaceRow(newRow), (RowData)this.upsertKeyProjectedRow2.replaceRow(oldRow));
        }
        return this.equaliser.equals(newRow, oldRow);
    }
}

