/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank.utils;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.shaded.guava32.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava32.com.google.common.cache.CacheBuilder;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.TopNBufferCacheRemovalListener;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FastTop1Helper
extends AbstractTopNFunction.AbstractTopNHelper {
    private static final Logger LOG = LoggerFactory.getLogger(FastTop1Helper.class);
    private final TypeSerializer<RowData> inputRowSer;
    private final Cache<RowData, RowData> kvCache;
    private final long topNSize;

    public FastTop1Helper(AbstractTopNFunction topNFunction, TypeSerializer<RowData> inputRowSer, long cacheSize, long topNSize) {
        super(topNFunction);
        this.inputRowSer = inputRowSer;
        this.topNSize = topNSize;
        int lruCacheSize = Math.max(1, (int)(cacheSize / topNSize));
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this.ttlConfig.isEnabled()) {
            cacheBuilder.expireAfterWrite(this.ttlConfig.getTimeToLive().toMillis(), TimeUnit.MILLISECONDS);
        }
        this.kvCache = cacheBuilder.maximumSize((long)lruCacheSize).removalListener(new TopNBufferCacheRemovalListener(this.keyContext, this::flushBufferToState)).build();
        LOG.info("Top-1 operator is using LRU caches key-size: {}", (Object)lruCacheSize);
    }

    @Nullable
    public RowData getPrevRowFromCache(RowData currentKey) {
        return (RowData)this.kvCache.getIfPresent((Object)currentKey);
    }

    public void processAsFirstRow(RowData input, RowData currentKey, Collector<RowData> out) {
        this.kvCache.put((Object)currentKey, (Object)((RowData)this.inputRowSer.copy((Object)input)));
        if (this.outputRankNumber) {
            this.collectInsert(out, input, 1L, 1L);
        } else {
            this.collectInsert(out, input);
        }
    }

    public void processWithPrevRow(RowData input, RowData currentKey, RowData prevRow, Collector<RowData> out) throws Exception {
        RowData oldSortKey;
        RowData curSortKey = (RowData)this.sortKeySelector.getKey((Object)input);
        int compare = this.sortKeyComparator.compare(curSortKey, oldSortKey = (RowData)this.sortKeySelector.getKey((Object)prevRow));
        if (compare < 0) {
            this.kvCache.put((Object)currentKey, (Object)((RowData)this.inputRowSer.copy((Object)input)));
            if (this.outputRankNumber) {
                this.collectUpdateBefore(out, prevRow, 1L, 1L);
                this.collectUpdateAfter(out, input, 1L, 1L);
            } else {
                this.collectUpdateBefore(out, prevRow);
                this.collectUpdateAfter(out, input);
            }
        }
    }

    public void flushAllCacheToState() throws Exception {
        for (Map.Entry entry : this.kvCache.asMap().entrySet()) {
            this.flushBufferToState((RowData)entry.getKey(), (RowData)entry.getValue());
        }
    }

    public abstract void flushBufferToState(RowData var1, RowData var2) throws Exception;

    public void registerMetric() {
        this.registerMetric(this.kvCache.size() * this.topNSize);
    }
}

