/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.operators.over.frame.SlidingOverFrame;
import org.apache.flink.table.types.logical.RowType;

public class RangeSlidingOverFrame
extends SlidingOverFrame {
    private GeneratedRecordComparator lboundComparator;
    private GeneratedRecordComparator rboundComparator;
    private RecordComparator lbound;
    private RecordComparator rbound;

    public RangeSlidingOverFrame(RowType inputType, RowType valueType, GeneratedAggsHandleFunction aggsHandleFunction, GeneratedRecordComparator lboundComparator, GeneratedRecordComparator rboundComparator) {
        super(inputType, valueType, aggsHandleFunction);
        this.lboundComparator = lboundComparator;
        this.rboundComparator = rboundComparator;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        ClassLoader cl = ctx.getRuntimeContext().getUserCodeClassLoader();
        this.lbound = (RecordComparator)this.lboundComparator.newInstance(cl);
        this.rbound = (RecordComparator)this.rboundComparator.newInstance(cl);
        this.lboundComparator = null;
        this.rboundComparator = null;
    }

    @Override
    public RowData process(int index, RowData current) throws Exception {
        boolean bufferUpdated;
        boolean bl = bufferUpdated = index == 0;
        while (!this.buffer.isEmpty() && this.lbound.compare((RowData)this.buffer.peek(), current) < 0) {
            this.buffer.remove();
            bufferUpdated = true;
        }
        while (this.nextRow != null && this.rbound.compare((RowData)this.nextRow, current) <= 0) {
            if (this.lbound.compare((RowData)this.nextRow, current) >= 0) {
                this.buffer.add(this.inputSer.copy((RowData)this.nextRow));
                bufferUpdated = true;
            }
            this.nextRow = OverWindowFrame.getNextOrNull(this.inputIterator);
        }
        return this.accumulateBuffer(bufferUpdated);
    }
}

