/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.sidecar.common.server.ICassandraFactory;
import org.apache.cassandra.sidecar.utils.SimpleCassandraVersion;
import org.jetbrains.annotations.VisibleForTesting;

public class CassandraVersionProvider {
    final ArrayList<ICassandraFactory> versions;

    public CassandraVersionProvider(ArrayList<ICassandraFactory> versions) {
        this.versions = versions;
    }

    @VisibleForTesting
    public List<ICassandraFactory> allVersions() {
        return this.versions;
    }

    public ICassandraFactory cassandra(SimpleCassandraVersion requestedVersion) {
        ICassandraFactory result = this.versions.get(0);
        for (ICassandraFactory factory : this.versions) {
            SimpleCassandraVersion currentMinVersion = SimpleCassandraVersion.create(result);
            SimpleCassandraVersion nextVersion = SimpleCassandraVersion.create(factory);
            if (nextVersion.isGreaterThan(requestedVersion) || !requestedVersion.isGreaterThan(currentMinVersion)) continue;
            result = factory;
        }
        return result;
    }

    public ICassandraFactory cassandra(String requestedVersion) {
        SimpleCassandraVersion version = SimpleCassandraVersion.create(requestedVersion);
        return this.cassandra(version);
    }

    @NotThreadSafe
    public static class Builder {
        ArrayList<ICassandraFactory> versions = new ArrayList();

        public CassandraVersionProvider build() {
            if (this.versions.isEmpty()) {
                throw new IllegalStateException("At least one ICassandraFactory is required");
            }
            return new CassandraVersionProvider(this.versions);
        }

        public Builder add(ICassandraFactory version) {
            this.versions.add(version);
            return this;
        }
    }
}

