/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.server;

import com.google.inject.Singleton;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrafficShapingOptions;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.cassandra.sidecar.common.server.utils.ByteUtils;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.config.SslConfiguration;
import org.apache.cassandra.sidecar.config.TrafficShapingConfiguration;
import org.apache.cassandra.sidecar.utils.SslUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HttpServerOptionsProvider
implements Function<SidecarConfiguration, HttpServerOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServerOptionsProvider.class);

    @Override
    public HttpServerOptions apply(SidecarConfiguration configuration) {
        SslConfiguration ssl;
        HttpServerOptions options = new HttpServerOptions().setLogActivity(true);
        ServiceConfiguration serviceConf = configuration.serviceConfiguration();
        options.setIdleTimeoutUnit(TimeUnit.MILLISECONDS).setIdleTimeout(serviceConf.requestIdleTimeout().toIntMillis()).setTcpKeepAlive(serviceConf.tcpKeepAlive()).setAcceptBacklog(serviceConf.acceptBacklog());
        if (SystemUtils.IS_OS_LINUX) {
            options.setTcpFastOpen(true);
            options.setTcpCork(true);
        }
        if ((ssl = configuration.sslConfiguration()) != null && ssl.enabled()) {
            options.setClientAuth(ClientAuth.valueOf((String)ssl.clientAuth())).setSsl(true).setEnabledSecureTransportProtocols(new LinkedHashSet<String>(ssl.secureTransportProtocols()));
            for (String cipherSuite : ssl.cipherSuites()) {
                options.addEnabledCipherSuite(cipherSuite);
            }
            if (ssl.preferOpenSSL() && OpenSSLEngineOptions.isAvailable()) {
                LOGGER.info("Using OpenSSL for encryption");
                options.setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions().setSessionCacheEnabled(true));
            } else {
                LOGGER.warn("OpenSSL not enabled, using JDK for TLS");
            }
            this.configureSSLOptions(options.getSslOptions(), ssl, 0L);
        }
        options.setTrafficShapingOptions(this.buildTrafficShapingOptions(serviceConf.trafficShapingConfiguration()));
        return options;
    }

    protected void configureSSLOptions(SSLOptions options, SslConfiguration ssl, long timestamp) {
        options.setSslHandshakeTimeout(ssl.handshakeTimeout().quantity()).setSslHandshakeTimeoutUnit(ssl.handshakeTimeout().unit());
        this.configureKeyStore(options, ssl, timestamp);
        this.configureTrustStore(options, ssl);
    }

    protected void configureKeyStore(SSLOptions options, SslConfiguration ssl, long timestamp) {
        SslUtils.setKeyStoreConfiguration(options, ssl.keystore(), timestamp);
    }

    protected void configureTrustStore(SSLOptions options, SslConfiguration ssl) {
        if (ssl.isTrustStoreConfigured()) {
            SslUtils.setTrustStoreConfiguration(options, ssl.truststore());
        }
    }

    protected TrafficShapingOptions buildTrafficShapingOptions(TrafficShapingConfiguration config) {
        long inboundGlobalBandwidthBytesPerSecond = config.inboundGlobalBandwidthBytesPerSecond();
        long outboundGlobalBandwidthBytesPerSecond = config.outboundGlobalBandwidthBytesPerSecond();
        long peakOutboundGlobalBandwidthBytesPerSecond = config.peakOutboundGlobalBandwidthBytesPerSecond();
        LOGGER.info("Configured traffic shaping options. InboundGlobalBandwidth={}/s rawInboundGlobalBandwidth={} B/s OutboundGlobalBandwidth={}/s rawOutboundGlobalBandwidth={} B/s PeakOutboundGlobalBandwidth={}/s rawPeakOutboundGlobalBandwidth={} B/s IntervalForStats={}ms MaxDelayToWait={}ms", new Object[]{ByteUtils.bytesToHumanReadableBinaryPrefix((long)inboundGlobalBandwidthBytesPerSecond), inboundGlobalBandwidthBytesPerSecond, ByteUtils.bytesToHumanReadableBinaryPrefix((long)outboundGlobalBandwidthBytesPerSecond), outboundGlobalBandwidthBytesPerSecond, ByteUtils.bytesToHumanReadableBinaryPrefix((long)peakOutboundGlobalBandwidthBytesPerSecond), peakOutboundGlobalBandwidthBytesPerSecond, config.checkIntervalForStats().toMillis(), config.maxDelayToWait().toMillis()});
        return new TrafficShapingOptions().setInboundGlobalBandwidth(inboundGlobalBandwidthBytesPerSecond).setOutboundGlobalBandwidth(outboundGlobalBandwidthBytesPerSecond).setPeakOutboundGlobalBandwidth(peakOutboundGlobalBandwidthBytesPerSecond).setCheckIntervalForStats(config.checkIntervalForStats().quantity()).setCheckIntervalForStatsTimeUnit(config.checkIntervalForStats().unit()).setMaxDelayToWait(config.maxDelayToWait().quantity()).setMaxDelayToWaitUnit(config.maxDelayToWait().unit());
    }
}

