/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.common.server.utils.DriverUtils;
import org.apache.cassandra.sidecar.common.server.utils.SidecarVersionProvider;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.utils.DigestAlgorithmProvider;
import org.apache.cassandra.sidecar.utils.JdkMd5DigestProvider;
import org.apache.cassandra.sidecar.utils.TimeProvider;
import org.apache.cassandra.sidecar.utils.XXHash32Provider;

public class UtilitiesModule
extends AbstractModule {
    @Provides
    @Singleton
    DriverUtils driverUtils() {
        return new DriverUtils();
    }

    @Provides
    @Singleton
    TimeProvider timeProvider() {
        return TimeProvider.DEFAULT_TIME_PROVIDER;
    }

    @Provides
    @Singleton
    DnsResolver dnsResolver(SidecarConfiguration configuration) {
        return configuration.serviceConfiguration().dnsResolver();
    }

    @Provides
    @Singleton
    @Named(value="xxhash32")
    DigestAlgorithmProvider xxHash32Provider() {
        return new XXHash32Provider();
    }

    @Provides
    @Singleton
    @Named(value="md5")
    DigestAlgorithmProvider md5Provider() {
        return new JdkMd5DigestProvider();
    }

    @Provides
    @Singleton
    SidecarVersionProvider sidecarVersionProvider() {
        return new SidecarVersionProvider("/sidecar.version");
    }
}

