/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.ProvidesIntoMap;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.locator.CachedLocalTokenRanges;
import org.apache.cassandra.sidecar.cluster.locator.LocalTokenRangesProvider;
import org.apache.cassandra.sidecar.common.response.data.CreateRestoreJobResponsePayload;
import org.apache.cassandra.sidecar.common.response.data.RestoreJobProgressResponsePayload;
import org.apache.cassandra.sidecar.common.response.data.RestoreJobSummaryResponsePayload;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.db.schema.RestoreJobsSchema;
import org.apache.cassandra.sidecar.db.schema.RestoreRangesSchema;
import org.apache.cassandra.sidecar.db.schema.RestoreSlicesSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.apache.cassandra.sidecar.handlers.DiskSpaceProtectionHandler;
import org.apache.cassandra.sidecar.handlers.restore.AbortRestoreJobHandler;
import org.apache.cassandra.sidecar.handlers.restore.CreateRestoreJobHandler;
import org.apache.cassandra.sidecar.handlers.restore.CreateRestoreSliceHandler;
import org.apache.cassandra.sidecar.handlers.restore.RestoreJobProgressHandler;
import org.apache.cassandra.sidecar.handlers.restore.RestoreJobSummaryHandler;
import org.apache.cassandra.sidecar.handlers.restore.RestoreRequestValidationHandler;
import org.apache.cassandra.sidecar.handlers.restore.UpdateRestoreJobHandler;
import org.apache.cassandra.sidecar.handlers.validations.ValidateTableExistenceHandler;
import org.apache.cassandra.sidecar.modules.multibindings.ClassKey;
import org.apache.cassandra.sidecar.modules.multibindings.KeyClassMapKey;
import org.apache.cassandra.sidecar.modules.multibindings.MultiBindingUtils;
import org.apache.cassandra.sidecar.modules.multibindings.PeriodicTaskMapKeys;
import org.apache.cassandra.sidecar.modules.multibindings.TableSchemaMapKeys;
import org.apache.cassandra.sidecar.modules.multibindings.VertxRouteMapKeys;
import org.apache.cassandra.sidecar.restore.RestoreJobDiscoverer;
import org.apache.cassandra.sidecar.restore.RestoreProcessor;
import org.apache.cassandra.sidecar.restore.RingTopologyRefresher;
import org.apache.cassandra.sidecar.routes.RouteBuilder;
import org.apache.cassandra.sidecar.routes.VertxRoute;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;

@Path(value="/")
public class RestoreJobModule
extends AbstractModule {
    protected void configure() {
        MapBinder<Class<ClassKey>, PeriodicTask> periodicTaskMapBinder = MultiBindingUtils.newClassKeyClassMapBinder(this.binder(), PeriodicTask.class);
        periodicTaskMapBinder.addBinding(PeriodicTaskMapKeys.RestoreJobDiscovererKey.class).to(RestoreJobDiscoverer.class);
        periodicTaskMapBinder.addBinding(PeriodicTaskMapKeys.RestoreProcessorKey.class).to(RestoreProcessor.class);
        periodicTaskMapBinder.addBinding(PeriodicTaskMapKeys.RingTopologyRefresherKey.class).to(RingTopologyRefresher.class);
    }

    @Provides
    @Singleton
    LocalTokenRangesProvider localTokenRangesProvider(InstancesMetadata instancesMetadata, DnsResolver dnsResolver) {
        return new CachedLocalTokenRanges(instancesMetadata, dnsResolver);
    }

    @ProvidesIntoMap
    @KeyClassMapKey(value=TableSchemaMapKeys.RestoreJobsSchemaKey.class)
    TableSchema restoreJobsSchema(SidecarConfiguration configuration) {
        return new RestoreJobsSchema(configuration.serviceConfiguration().schemaKeyspaceConfiguration(), configuration.restoreJobConfiguration().restoreJobTablesTtl());
    }

    @ProvidesIntoMap
    @KeyClassMapKey(value=TableSchemaMapKeys.RestoreSlicesSchemaKey.class)
    TableSchema restoreSlicesSchema(SidecarConfiguration configuration) {
        return new RestoreSlicesSchema(configuration.serviceConfiguration().schemaKeyspaceConfiguration(), configuration.restoreJobConfiguration().restoreJobTablesTtl());
    }

    @ProvidesIntoMap
    @KeyClassMapKey(value=TableSchemaMapKeys.RestoreRangesSchemaKey.class)
    TableSchema restoreRangesSchema(SidecarConfiguration configuration) {
        return new RestoreRangesSchema(configuration.serviceConfiguration().schemaKeyspaceConfiguration(), configuration.restoreJobConfiguration().restoreJobTablesTtl());
    }

    @POST
    @Path(value="/api/v1/keyspaces/:keyspace/tables/:table/restore-jobs")
    @Operation(summary="Create restore job", description="Creates a new restore job for importing data from backup sources")
    @APIResponse(description="Restore job created successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateRestoreJobResponsePayload.class))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.CreateRestoreJobRouteKey.class)
    VertxRoute createRestoreJobsRoute(RouteBuilder.Factory factory, ValidateTableExistenceHandler validateTableExistence, RestoreRequestValidationHandler validateRestoreJobRequest, CreateRestoreJobHandler createRestoreJobHandler) {
        return factory.builderForRoute().setBodyHandler(true).handler(validateTableExistence).handler(validateRestoreJobRequest).handler(createRestoreJobHandler).build();
    }

    @POST
    @Path(value="/api/v1/keyspaces/:keyspace/tables/:table/restore-jobs/:jobId/slices")
    @Operation(summary="Create restore slice", description="Creates a new restore slice as part of a restore job")
    @APIResponse(description="Restore slice created successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class, example="{\"status\": \"OK\", \"message\": \"Restore slice created successfully\"}"))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.CreateRestoreSliceRouteKey.class)
    VertxRoute createRestoreJobSlicesRoute(RouteBuilder.Factory factory, ValidateTableExistenceHandler validateTableExistence, RestoreRequestValidationHandler validateRestoreJobRequest, DiskSpaceProtectionHandler diskSpaceProtection, CreateRestoreSliceHandler createRestoreSliceHandler) {
        return factory.builderForRoute().setBodyHandler(true).handler(diskSpaceProtection).handler(validateTableExistence).handler(validateRestoreJobRequest).handler(createRestoreSliceHandler).build();
    }

    @GET
    @Path(value="/api/v1/keyspaces/:keyspace/tables/:table/restore-jobs/:jobId")
    @Operation(summary="Get restore job summary", description="Returns a summary of restore jobs")
    @APIResponse(description="Restore job summary retrieved successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=RestoreJobSummaryResponsePayload.class))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.GetRestoreJobSummaryRouteKey.class)
    VertxRoute restoreJobSummaryRoute(RouteBuilder.Factory factory, ValidateTableExistenceHandler validateTableExistence, RestoreRequestValidationHandler validateRestoreJobRequest, RestoreJobSummaryHandler restoreJobSummaryHandler) {
        return factory.builderForRoute().handler(validateTableExistence).handler(validateRestoreJobRequest).handler(restoreJobSummaryHandler).build();
    }

    @PATCH
    @Path(value="/api/v1/keyspaces/:keyspace/tables/:table/restore-jobs/:jobId")
    @Operation(summary="Update restore job", description="Updates an existing restore job configuration")
    @APIResponse(description="Restore job updated successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class, example="{\"status\": \"OK\", \"message\": \"Restore job updated successfully\"}"))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.UpdateRestoreJobRouteKey.class)
    VertxRoute updateRestoreJobRoute(RouteBuilder.Factory factory, ValidateTableExistenceHandler validateTableExistence, RestoreRequestValidationHandler validateRestoreJobRequest, UpdateRestoreJobHandler updateRestoreJobHandler) {
        return factory.builderForRoute().setBodyHandler(true).handler(validateTableExistence).handler(validateRestoreJobRequest).handler(updateRestoreJobHandler).build();
    }

    @POST
    @Path(value="/api/v1/keyspaces/:keyspace/tables/:table/restore-jobs/:jobId/abort")
    @Operation(summary="Abort restore job", description="Aborts an active restore job and stops all associated operations")
    @APIResponse(description="Restore job aborted successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class, example="{\"status\": \"OK\", \"message\": \"Restore job aborted successfully\"}"))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.AbortRestoreJobRouteKey.class)
    VertxRoute abortRestoreJobRoute(RouteBuilder.Factory factory, ValidateTableExistenceHandler validateTableExistence, RestoreRequestValidationHandler validateRestoreJobRequest, AbortRestoreJobHandler abortRestoreJobHandler) {
        return factory.builderForRoute().setBodyHandler(true).handler(validateTableExistence).handler(validateRestoreJobRequest).handler(abortRestoreJobHandler).build();
    }

    @GET
    @Path(value="/api/v1/keyspaces/:keyspace/tables/:table/restore-jobs/:jobId/progress")
    @Operation(summary="Get restore job progress", description="Returns the progress information for a specific restore job")
    @APIResponse(description="Restore job progress retrieved successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=RestoreJobProgressResponsePayload.class))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.GetRestoreJobProgressRouteKey.class)
    VertxRoute restoreJobProgressRoute(RouteBuilder.Factory factory, ValidateTableExistenceHandler validateTableExistence, RestoreRequestValidationHandler validateRestoreJobRequest, RestoreJobProgressHandler restoreJobProgressHandler) {
        return factory.builderForRoute().handler(validateTableExistence).handler(validateRestoreJobRequest).handler(restoreJobProgressHandler).build();
    }
}

