/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics.instance;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.NamedMetric;

public class UploadSSTableMetrics {
    public static final String DOMAIN = "Sidecar.CassInstance.UploadSSTable";
    protected final MetricRegistry metricRegistry;
    protected final Map<String, UploadSSTableComponentMetrics> uploadComponentMetrics = new ConcurrentHashMap<String, UploadSSTableComponentMetrics>();
    public final NamedMetric<Meter> totalBytesUploadedRate;
    public final NamedMetric<DeltaGauge> throttled;

    public UploadSSTableMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry can not be null");
        this.totalBytesUploadedRate = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).meter(arg_0)).withDomain(DOMAIN).withName("TotalBytesUploadedRate").build();
        this.throttled = NamedMetric.builder(name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new)).withDomain(DOMAIN).withName("Throttled").build();
    }

    public UploadSSTableComponentMetrics forComponent(String component) {
        return this.uploadComponentMetrics.computeIfAbsent(component, sstableComponent -> new UploadSSTableComponentMetrics(this.metricRegistry, (String)sstableComponent));
    }

    public static class UploadSSTableComponentMetrics {
        protected final MetricRegistry metricRegistry;
        public final String sstableComponent;
        public final NamedMetric<Meter> bytesUploadedRate;

        public UploadSSTableComponentMetrics(MetricRegistry metricRegistry, String sstableComponent) {
            this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry can not be null");
            this.sstableComponent = Objects.requireNonNull(sstableComponent, "SSTable component required for component specific metrics capture");
            if (sstableComponent.isEmpty()) {
                throw new IllegalArgumentException("SSTableComponent required for component specific metrics capture");
            }
            NamedMetric.Tag componentTag = NamedMetric.Tag.of("component", sstableComponent);
            this.bytesUploadedRate = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).meter(arg_0)).withDomain(UploadSSTableMetrics.DOMAIN).withName("BytesUploadedRate").addTag(componentTag).build();
        }
    }
}

