/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.livemigration;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.livemigration.LiveMigrationInstanceMetadataUtil;
import org.jetbrains.annotations.Nullable;

public class LiveMigrationPlaceholderUtil {
    public static final String DATA_FILE_DIR_PLACEHOLDER = "DATA_FILE_DIR";
    public static final String COMMITLOG_DIR_PLACEHOLDER = "COMMITLOG_DIR";
    public static final String HINTS_DIR_PLACEHOLDER = "HINTS_DIR";
    public static final String SAVED_CACHES_DIR_PLACEHOLDER = "SAVED_CACHES_DIR";
    public static final String CDC_RAW_DIR_PLACEHOLDER = "CDC_RAW_DIR";
    public static final String LOCAL_SYSTEM_DATA_FILE_DIR_PLACEHOLDER = "LOCAL_SYSTEM_DATA_FILE_DIR";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(\\w+)}.*");

    @Nullable
    public static String replacePlaceholder(String input, Set<String> placeholders, String value) {
        String placeholder = LiveMigrationPlaceholderUtil.getPlaceholder(input);
        if (placeholder == null) {
            return input;
        }
        if (placeholders.contains(placeholder)) {
            return LiveMigrationPlaceholderUtil.replacePlaceholder(input, placeholder, value);
        }
        return null;
    }

    public static Set<String> replacePlaceholder(String input, InstanceMetadata instanceMetadata) {
        if (!LiveMigrationPlaceholderUtil.hasAnyPlaceholder(input)) {
            return Collections.singleton(input);
        }
        String placeholder = LiveMigrationPlaceholderUtil.getPlaceholder(input);
        Map<String, Set<String>> placeholderDirsMap = LiveMigrationInstanceMetadataUtil.placeholderDirsMap(instanceMetadata);
        if (!placeholderDirsMap.containsKey(placeholder)) {
            throw new IllegalArgumentException("Unknown placeholder specified in " + input);
        }
        Set<String> dirs = placeholderDirsMap.get(placeholder);
        HashSet<String> output = new HashSet<String>(dirs.size());
        for (String dir : dirs) {
            output.add(LiveMigrationPlaceholderUtil.replacePlaceholder(input, placeholder, dir));
        }
        return output;
    }

    private static String replacePlaceholder(String input, String placeholder, String value) {
        return input.replace("${" + placeholder + "}", value);
    }

    public static boolean hasAnyPlaceholder(String input) {
        String placeholder = LiveMigrationPlaceholderUtil.getPlaceholder(input);
        return placeholder != null;
    }

    public static boolean hasAnyPlaceholder(String input, Set<String> knownPlaceHolders) {
        String placeholder = LiveMigrationPlaceholderUtil.getPlaceholder(input);
        return placeholder != null && knownPlaceHolders.contains(placeholder);
    }

    @Nullable
    private static String getPlaceholder(String input) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

