/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.livemigration;

import java.lang.invoke.CallSite;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.handlers.livemigration.LiveMigrationDirType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveMigrationInstanceMetadataUtil {
    public static final String LIVE_MIGRATION_CDC_RAW_DIR_PATH = "/api/v1/live-migration/files/" + LiveMigrationDirType.CDC_RAW_DIR.dirType;
    public static final String LIVE_MIGRATION_COMMITLOG_DIR_PATH = "/api/v1/live-migration/files/" + LiveMigrationDirType.COMMIT_LOG_DIR.dirType;
    public static final String LIVE_MIGRATION_DATA_FILE_DIR_PATH = "/api/v1/live-migration/files/" + LiveMigrationDirType.DATA_FIlE_DIR.dirType;
    public static final String LIVE_MIGRATION_HINTS_DIR_PATH = "/api/v1/live-migration/files/" + LiveMigrationDirType.HINTS_DIR.dirType;
    public static final String LIVE_MIGRATION_LOCAL_SYSTEM_DATA_FILE_DIR_PATH = "/api/v1/live-migration/files/" + LiveMigrationDirType.LOCAL_SYSTEM_DATA_FILE_DIR.dirType;
    public static final String LIVE_MIGRATION_SAVED_CACHES_DIR_PATH = "/api/v1/live-migration/files/" + LiveMigrationDirType.SAVED_CACHES_DIR.dirType;
    private static final Logger LOGGER = LoggerFactory.getLogger(LiveMigrationInstanceMetadataUtil.class);

    public static List<String> dirsToCopy(InstanceMetadata instanceMetadata) {
        ArrayList<String> dirsToCopy = new ArrayList<String>();
        dirsToCopy.add(instanceMetadata.hintsDir());
        dirsToCopy.add(instanceMetadata.commitlogDir());
        if (instanceMetadata.savedCachesDir() != null) {
            dirsToCopy.add(instanceMetadata.savedCachesDir());
        }
        if (instanceMetadata.cdcDir() != null) {
            dirsToCopy.add(instanceMetadata.cdcDir());
        }
        if (instanceMetadata.localSystemDataFileDir() != null) {
            dirsToCopy.add(instanceMetadata.localSystemDataFileDir());
        }
        dirsToCopy.addAll(instanceMetadata.dataDirs());
        return Collections.unmodifiableList(dirsToCopy);
    }

    public static Map<String, String> dirPathPrefixMap(InstanceMetadata instanceMetadata) {
        HashMap<String, CallSite> dirIndexMap = new HashMap<String, CallSite>();
        dirIndexMap.put(instanceMetadata.hintsDir(), (CallSite)((Object)(LIVE_MIGRATION_HINTS_DIR_PATH + "/0")));
        dirIndexMap.put(instanceMetadata.commitlogDir(), (CallSite)((Object)(LIVE_MIGRATION_COMMITLOG_DIR_PATH + "/0")));
        if (instanceMetadata.savedCachesDir() != null) {
            dirIndexMap.put(instanceMetadata.savedCachesDir(), (CallSite)((Object)(LIVE_MIGRATION_SAVED_CACHES_DIR_PATH + "/0")));
        }
        if (instanceMetadata.cdcDir() != null) {
            dirIndexMap.put(instanceMetadata.cdcDir(), (CallSite)((Object)(LIVE_MIGRATION_CDC_RAW_DIR_PATH + "/0")));
        }
        if (instanceMetadata.localSystemDataFileDir() != null) {
            dirIndexMap.put(instanceMetadata.localSystemDataFileDir(), (CallSite)((Object)(LIVE_MIGRATION_LOCAL_SYSTEM_DATA_FILE_DIR_PATH + "/0")));
        }
        for (int i = 0; i < instanceMetadata.dataDirs().size(); ++i) {
            dirIndexMap.put(instanceMetadata.dataDirs().get(i), (CallSite)((Object)(LIVE_MIGRATION_DATA_FILE_DIR_PATH + "/" + i)));
        }
        return Collections.unmodifiableMap(dirIndexMap);
    }

    public static Map<String, Set<String>> dirPlaceHoldersMap(InstanceMetadata instanceMetadata) {
        HashMap<String, Set<Object>> placeholderMap = new HashMap<String, Set<Object>>();
        placeholderMap.put(instanceMetadata.hintsDir(), Collections.singleton("HINTS_DIR"));
        placeholderMap.put(instanceMetadata.commitlogDir(), Collections.singleton("COMMITLOG_DIR"));
        if (instanceMetadata.savedCachesDir() != null) {
            placeholderMap.put(instanceMetadata.savedCachesDir(), Collections.singleton("SAVED_CACHES_DIR"));
        }
        if (instanceMetadata.cdcDir() != null) {
            placeholderMap.put(instanceMetadata.cdcDir(), Collections.singleton("CDC_RAW_DIR"));
        }
        if (instanceMetadata.localSystemDataFileDir() != null) {
            placeholderMap.put(instanceMetadata.localSystemDataFileDir(), Collections.singleton("LOCAL_SYSTEM_DATA_FILE_DIR"));
        }
        List<String> dataDirs = instanceMetadata.dataDirs();
        for (int i = 0; i < dataDirs.size(); ++i) {
            String dir = dataDirs.get(i);
            Set<CallSite> placeholders = Set.of("DATA_FILE_DIR", "DATA_FILE_DIR_" + i);
            placeholderMap.put(dir, placeholders);
        }
        return Collections.unmodifiableMap(placeholderMap);
    }

    public static Map<String, Set<String>> placeholderDirsMap(InstanceMetadata instanceMetadata) {
        HashMap<String, Set<String>> placeholderDirsMap = new HashMap<String, Set<String>>();
        placeholderDirsMap.put("HINTS_DIR", Collections.singleton(instanceMetadata.hintsDir()));
        placeholderDirsMap.put("COMMITLOG_DIR", Collections.singleton(instanceMetadata.commitlogDir()));
        if (instanceMetadata.savedCachesDir() != null) {
            placeholderDirsMap.put("SAVED_CACHES_DIR", Collections.singleton(instanceMetadata.savedCachesDir()));
        }
        if (instanceMetadata.cdcDir() != null) {
            placeholderDirsMap.put("CDC_RAW_DIR", Collections.singleton(instanceMetadata.cdcDir()));
        }
        if (instanceMetadata.localSystemDataFileDir() != null) {
            placeholderDirsMap.put("LOCAL_SYSTEM_DATA_FILE_DIR", Collections.singleton(instanceMetadata.localSystemDataFileDir()));
        }
        placeholderDirsMap.put("DATA_FILE_DIR", Set.copyOf(instanceMetadata.dataDirs()));
        List<String> dataDirs = instanceMetadata.dataDirs();
        for (int i = 0; i < dataDirs.size(); ++i) {
            placeholderDirsMap.put("DATA_FILE_DIR_" + i, Collections.singleton(dataDirs.get(i)));
        }
        return placeholderDirsMap;
    }

    public static String localPath(@NotNull String fileUrl, @NotNull InstanceMetadata metadata) {
        if (fileUrl.contains("/../") || fileUrl.endsWith("/..")) {
            String errorMessage = "Tried to access file using relative path " + fileUrl + ".";
            LOGGER.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        Map<String, String> urlToLocalDirMap = LiveMigrationInstanceMetadataUtil.migrationUrlLocalDirMap(metadata);
        for (Map.Entry<String, String> entry : urlToLocalDirMap.entrySet()) {
            if (!fileUrl.startsWith(entry.getKey())) continue;
            Objects.requireNonNull(entry.getValue(), () -> "No local path found for url " + fileUrl);
            String relativePath = fileUrl.substring(entry.getKey().length());
            return Paths.get(entry.getValue(), relativePath).toAbsolutePath().toString();
        }
        throw new IllegalArgumentException("File url " + fileUrl + " is unknown.");
    }

    private static Map<String, String> migrationUrlLocalDirMap(InstanceMetadata instanceMetadata) {
        HashMap<String, String> urlToLocalDirMap = new HashMap<String, String>();
        urlToLocalDirMap.put(LIVE_MIGRATION_COMMITLOG_DIR_PATH + "/0/", instanceMetadata.commitlogDir());
        urlToLocalDirMap.put(LIVE_MIGRATION_HINTS_DIR_PATH + "/0/", instanceMetadata.hintsDir());
        urlToLocalDirMap.put(LIVE_MIGRATION_SAVED_CACHES_DIR_PATH + "/0/", instanceMetadata.savedCachesDir());
        if (instanceMetadata.cdcDir() != null) {
            urlToLocalDirMap.put(LIVE_MIGRATION_CDC_RAW_DIR_PATH + "/0/", instanceMetadata.cdcDir());
        }
        if (instanceMetadata.localSystemDataFileDir() != null) {
            urlToLocalDirMap.put(LIVE_MIGRATION_LOCAL_SYSTEM_DATA_FILE_DIR_PATH + "/0/", instanceMetadata.localSystemDataFileDir());
        }
        for (int i = 0; i < instanceMetadata.dataDirs().size(); ++i) {
            urlToLocalDirMap.put(LIVE_MIGRATION_DATA_FILE_DIR_PATH + "/" + i + "/", instanceMetadata.dataDirs().get(0));
        }
        return urlToLocalDirMap;
    }
}

