/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.job;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.common.data.OperationalJobStatus;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.job.OperationalJob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OperationalJobTracker {
    public static final long ONE_DAY_TTL = TimeUnit.DAYS.toMillis(1L);
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationalJobTracker.class);
    private final Map<UUID, OperationalJob> map;

    @Inject
    public OperationalJobTracker(ServiceConfiguration serviceConfiguration) {
        this(serviceConfiguration.operationalJobTrackerSize());
    }

    public OperationalJobTracker(final int initialCapacity) {
        this.map = Collections.synchronizedMap(new LinkedHashMap<UUID, OperationalJob>(initialCapacity){

            @Override
            protected boolean removeEldestEntry(Map.Entry<UUID, OperationalJob> eldest) {
                if (OperationalJobTracker.this.map.size() > initialCapacity) {
                    OperationalJob job = eldest.getValue();
                    OperationalJobStatus status = job.status();
                    if (status.isCompleted() && job.isStale(System.currentTimeMillis(), ONE_DAY_TTL)) {
                        LOGGER.debug("Expiring completed and stale job due to job tracker has reached max size. jobId={} status={} createdAt={}", new Object[]{job.jobId(), status, job.creationTime()});
                        return true;
                    }
                    LOGGER.warn("Job tracker reached max size, but the eldest job is not completed yet. Not evicting. jobId={} status={}", (Object)job.jobId(), (Object)status);
                }
                return false;
            }
        });
    }

    public OperationalJob computeIfAbsent(UUID key, Function<UUID, OperationalJob> mappingFunction) {
        return this.map.computeIfAbsent(key, mappingFunction);
    }

    public OperationalJob get(UUID key) {
        return this.map.get(key);
    }

    @NotNull
    Map<UUID, OperationalJob> jobsView() {
        return Collections.unmodifiableMap(this.map);
    }

    @NotNull
    List<OperationalJob> inflightJobsByOperation(String operation) {
        return this.jobsView().values().stream().filter(j -> j.name().equals(operation) && (j.status() == OperationalJobStatus.RUNNING || j.status() == OperationalJobStatus.CREATED)).collect(Collectors.toList());
    }

    @VisibleForTesting
    OperationalJob put(OperationalJob job) {
        return this.map.put(job.jobId(), job);
    }

    @VisibleForTesting
    int size() {
        return this.map.size();
    }
}

