/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.datastax.driver.core.utils.UUIDs;
import com.google.inject.Inject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.data.OperationalJobStatus;
import org.apache.cassandra.sidecar.common.response.OperationalJobResponse;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.exceptions.OperationalJobConflictException;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.job.NodeDecommissionJob;
import org.apache.cassandra.sidecar.job.OperationalJobManager;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.cassandra.sidecar.utils.OperationalJobUtils;
import org.apache.cassandra.sidecar.utils.RequestUtils;
import org.jetbrains.annotations.NotNull;

public class NodeDecommissionHandler
extends AbstractHandler<Boolean>
implements AccessProtected {
    private final OperationalJobManager jobManager;
    private final ServiceConfiguration config;

    @Inject
    protected NodeDecommissionHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, ServiceConfiguration serviceConfiguration, CassandraInputValidator validator, OperationalJobManager jobManager) {
        super(metadataFetcher, executorPools, validator);
        this.jobManager = jobManager;
        this.config = serviceConfiguration;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.DECOMMISSION_NODE.toAuthorization());
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, Boolean isForce) {
        StorageOperations operations = this.metadataFetcher.delegate(host).storageOperations();
        NodeDecommissionJob job = new NodeDecommissionJob(UUIDs.timeBased(), operations, isForce);
        try {
            this.jobManager.trySubmitJob(job);
        }
        catch (OperationalJobConflictException oje) {
            String reason = oje.getMessage();
            this.logger.error("Conflicting job encountered. reason={}", (Object)reason);
            context.response().setStatusCode(HttpResponseStatus.CONFLICT.code());
            context.json((Object)new OperationalJobResponse(job.jobId(), OperationalJobStatus.FAILED, job.name(), reason));
            return;
        }
        job.asyncResult(this.executorPools.service(), (DurationSpec)this.config.operationalJobExecutionMaxWaitTime()).onComplete(v -> OperationalJobUtils.sendStatusBasedResponse(context, job));
    }

    @Override
    protected Boolean extractParamsOrThrow(RoutingContext context) {
        return RequestUtils.parseBooleanQueryParam(context.request(), "force", false);
    }
}

