/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.Map;
import java.util.Optional;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.db.ConfigAccessor;
import org.apache.cassandra.sidecar.db.DatabaseAccessor;
import org.apache.cassandra.sidecar.db.ServiceConfig;
import org.apache.cassandra.sidecar.db.schema.ConfigsSchema;
import org.apache.cassandra.sidecar.db.schema.SidecarSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigAccessorImpl
extends DatabaseAccessor<ConfigsSchema>
implements ConfigAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigAccessorImpl.class);
    private final String serviceName = this.service();
    private final SidecarSchema sidecarSchema;

    protected ConfigAccessorImpl(CQLSessionProvider sessionProvider, SidecarSchema sidecarSchema) {
        super((TableSchema)sidecarSchema.tableSchema(ConfigsSchema.class), sessionProvider);
        this.sidecarSchema = sidecarSchema;
    }

    public abstract String service();

    @Override
    public ServiceConfig getConfig() {
        this.sidecarSchema.ensureInitialized();
        BoundStatement statement = ((ConfigsSchema)this.tableSchema).selectConfig().bind(new Object[]{this.serviceName});
        Row row = this.execute((Statement)statement).one();
        if (row == null || row.isNull(0)) {
            LOGGER.debug("No {} configs are present in the table Cassandra table", (Object)this.serviceName);
            return new ServiceConfig(Map.of());
        }
        return ServiceConfig.from(row);
    }

    @Override
    public ServiceConfig storeConfig(Map<String, String> config) {
        this.sidecarSchema.ensureInitialized();
        BoundStatement statement = ((ConfigsSchema)this.tableSchema).insertConfig().bind(new Object[]{this.serviceName, config});
        this.execute((Statement)statement);
        return new ServiceConfig(config);
    }

    @Override
    public Optional<ServiceConfig> storeConfigIfNotExists(Map<String, String> config) {
        this.sidecarSchema.ensureInitialized();
        BoundStatement statement = ((ConfigsSchema)this.tableSchema).insertConfigIfNotExists().bind(new Object[]{this.serviceName, config});
        ResultSet resultSet = this.execute((Statement)statement);
        if (resultSet.wasApplied()) {
            return Optional.of(new ServiceConfig(config));
        }
        return Optional.empty();
    }

    @Override
    public void deleteConfig() {
        this.sidecarSchema.ensureInitialized();
        BoundStatement deleteStatement = ((ConfigsSchema)this.tableSchema).deleteConfig().bind(new Object[]{this.serviceName});
        this.execute((Statement)deleteStatement);
    }

    public boolean isAvailable() {
        return super.isAvailable() && this.sidecarSchema.isInitialized();
    }
}

