/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.coordination;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import java.util.Comparator;
import java.util.Set;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.coordination.AbstractTokenZeroOfKeyspaceElectorateMembership;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MostReplicatedKeyspaceTokenZeroElectorateMembership
extends AbstractTokenZeroOfKeyspaceElectorateMembership {
    private static final Logger LOGGER = LoggerFactory.getLogger(MostReplicatedKeyspaceTokenZeroElectorateMembership.class);
    private final CQLSessionProvider cqlSessionProvider;
    private final SidecarConfiguration configuration;

    public MostReplicatedKeyspaceTokenZeroElectorateMembership(InstanceMetadataFetcher instanceMetadataFetcher, CQLSessionProvider cqlSessionProvider, SidecarConfiguration sidecarConfiguration) {
        super(instanceMetadataFetcher);
        this.cqlSessionProvider = cqlSessionProvider;
        this.configuration = sidecarConfiguration;
    }

    @Override
    protected String keyspaceToDetermineElectorateMembership() {
        return this.highestReplicationFactorKeyspace();
    }

    String highestReplicationFactorKeyspace() {
        Session activeSession;
        if (this.instanceMetadataFetcher.allLocalInstances().isEmpty()) {
            LOGGER.warn("There are no local Cassandra instances managed by this Sidecar");
            return null;
        }
        try {
            activeSession = this.cqlSessionProvider.get();
        }
        catch (CassandraUnavailableException exception) {
            LOGGER.warn("There is no active session to Cassandra");
            return null;
        }
        Set<String> forbiddenKeyspaces = this.configuration.cassandraInputValidationConfiguration().forbiddenKeyspaces();
        String sidecarKeyspaceName = this.configuration.serviceConfiguration().schemaKeyspaceConfiguration().keyspace();
        return activeSession.getCluster().getMetadata().getKeyspaces().stream().filter(keyspace -> !forbiddenKeyspaces.contains(keyspace.getName())).sorted(Comparator.comparingInt(this::aggregateReplicationFactor).reversed().thenComparing(KeyspaceMetadata::getName)).map(KeyspaceMetadata::getName).findFirst().orElse(sidecarKeyspaceName);
    }

    int aggregateReplicationFactor(KeyspaceMetadata keyspace) {
        int replicationFactor = 0;
        for (String value : keyspace.getReplication().values()) {
            try {
                replicationFactor += Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return replicationFactor;
    }
}

