/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.cdc;

import java.util.Map;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CdcConfig {
    public String env();

    @Nullable
    public String kafkaTopic();

    @NotNull
    public TopicFormatType topicFormat();

    public boolean cdcEnabled();

    public String jobId();

    public Map<String, Object> kafkaConfigs();

    public Map<String, Object> cdcConfigs();

    public boolean logOnly();

    public String datacenter();

    public SecondBoundConfiguration watermarkWindow();

    public int maxRecordSizeBytes();

    @Nullable
    public String compression();

    public boolean failOnRecordTooLargeError();

    public boolean failOnKafkaError();

    public boolean isConfigReady();

    public MillisecondBoundConfiguration minDelayBetweenMicroBatches();

    public int maxCommitLogsPerInstance();

    public int maxWatermarkerSize();

    public boolean persistEnabled();

    public MillisecondBoundConfiguration persistDelay();

    public static enum TopicFormatType {
        STATIC,
        KEYSPACE,
        KEYSPACETABLE,
        TABLE,
        MAP;

    }
}

