/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.response;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GossipInfoResponse
extends HashMap<String, GossipInfo> {
    @Override
    public GossipInfo get(Object key) {
        GossipInfo value;
        String keyAsString;
        if (key instanceof String && (keyAsString = (String)key).length() > 0 && keyAsString.charAt(0) != '/' && (value = (GossipInfo)super.get("/" + key)) != null) {
            return value;
        }
        return (GossipInfo)super.get(key);
    }

    protected static enum GossipField {
        GENERATION,
        HEARTBEAT,
        STATUS,
        LOAD,
        SCHEMA,
        DC,
        RACK,
        RELEASE_VERSION,
        REMOVAL_COORDINATOR,
        INTERNAL_IP,
        RPC_ADDRESS,
        SEVERITY,
        NET_VERSION,
        HOST_ID,
        TOKENS,
        RPC_READY,
        INTERNAL_ADDRESS_AND_PORT,
        NATIVE_ADDRESS_AND_PORT,
        STATUS_WITH_PORT,
        SSTABLE_VERSIONS,
        DISK_USAGE,
        INDEX_STATUS;


        static String read(GossipInfo gossipInfo, GossipField field) {
            return (String)gossipInfo.get(field.toLowerCamelCase());
        }

        String toLowerCamelCase() {
            String upperUnderscoreCase = this.name();
            StringBuilder sb = new StringBuilder(upperUnderscoreCase.length());
            sb.append(Character.toLowerCase(upperUnderscoreCase.charAt(0)));
            int length = upperUnderscoreCase.length();
            for (int i = 1; i < length; ++i) {
                if (upperUnderscoreCase.charAt(i) == '_' && i + 1 < length) {
                    sb.append(upperUnderscoreCase.charAt(++i));
                    continue;
                }
                sb.append(Character.toLowerCase(upperUnderscoreCase.charAt(i)));
            }
            return sb.toString();
        }
    }

    public static class GossipInfo
    extends HashMap<String, String> {
        public void camelizeKeyAndPut(String key, String value) {
            String lowerCamelCasedKey = GossipField.valueOf(key.toUpperCase()).toLowerCamelCase();
            super.put(lowerCamelCasedKey, value);
        }

        @NotNull
        public String generation() {
            return GossipField.read(this, GossipField.GENERATION);
        }

        @NotNull
        public String heartbeat() {
            return GossipField.read(this, GossipField.HEARTBEAT);
        }

        @Nullable
        public String status() {
            return GossipField.read(this, GossipField.STATUS);
        }

        @Nullable
        public String load() {
            return GossipField.read(this, GossipField.LOAD);
        }

        @Nullable
        public String schema() {
            return GossipField.read(this, GossipField.SCHEMA);
        }

        @Nullable
        public String datacenter() {
            return GossipField.read(this, GossipField.DC);
        }

        @Nullable
        public String rack() {
            return GossipField.read(this, GossipField.RACK);
        }

        @Nullable
        public String releaseVersion() {
            return GossipField.read(this, GossipField.RELEASE_VERSION);
        }

        @Nullable
        public String removalCoordinator() {
            return GossipField.read(this, GossipField.REMOVAL_COORDINATOR);
        }

        @Nullable
        public String internalIp() {
            return GossipField.read(this, GossipField.INTERNAL_IP);
        }

        @Nullable
        public String rpcAddress() {
            return GossipField.read(this, GossipField.RPC_ADDRESS);
        }

        @Nullable
        public String severity() {
            return GossipField.read(this, GossipField.SEVERITY);
        }

        @Nullable
        public String netVersion() {
            return GossipField.read(this, GossipField.NET_VERSION);
        }

        @Nullable
        public String hostId() {
            return GossipField.read(this, GossipField.HOST_ID);
        }

        @Nullable
        public String indexStatus() {
            return GossipField.read(this, GossipField.INDEX_STATUS);
        }

        @Nullable
        public String tokens() {
            return GossipField.read(this, GossipField.TOKENS);
        }

        @Nullable
        public Boolean rpcReady() {
            String value = GossipField.read(this, GossipField.RPC_READY);
            return value == null ? null : Boolean.valueOf(value);
        }

        @Nullable
        public String internalAddressAndPort() {
            return GossipField.read(this, GossipField.INTERNAL_ADDRESS_AND_PORT);
        }

        @Nullable
        public String nativeAddressAndPort() {
            return GossipField.read(this, GossipField.NATIVE_ADDRESS_AND_PORT);
        }

        @Nullable
        public String statusWithPort() {
            return GossipField.read(this, GossipField.STATUS_WITH_PORT);
        }

        @Nullable
        public List<String> sstableVersions() {
            String value = GossipField.read(this, GossipField.SSTABLE_VERSIONS);
            return value == null ? null : Arrays.asList(value.split(","));
        }

        @Nullable
        public String diskUsage() {
            return GossipField.read(this, GossipField.DISK_USAGE);
        }
    }
}

