/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base.db;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.cassandra.sidecar.adapters.base.db.ConnectedClientStats;
import org.apache.cassandra.sidecar.adapters.base.db.ConnectedClientStatsSummary;
import org.apache.cassandra.sidecar.adapters.base.db.schema.ConnectedClientsSchema;
import org.apache.cassandra.sidecar.common.server.ICassandraAdapter;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.db.LocalDatabaseAccessor;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchemaFetcher;

public class ConnectedClientStatsDatabaseAccessor
extends LocalDatabaseAccessor<ConnectedClientsSchema> {
    public ConnectedClientStatsDatabaseAccessor(TableSchemaFetcher tableSchemaFetcher, ICassandraAdapter cassandraAdapter) {
        super((TableSchema)((ConnectedClientsSchema)tableSchemaFetcher.tableSchema(ConnectedClientsSchema.class)), cassandraAdapter);
    }

    public ConnectedClientStatsSummary summary() {
        Preconditions.checkState((boolean)((ConnectedClientsSchema)this.tableSchema).isInitialized(), () -> ((Object)((Object)((ConnectedClientsSchema)this.tableSchema))).getClass().getSimpleName() + " is not initialized yet");
        BoundStatement statement = ((ConnectedClientsSchema)this.tableSchema).connectionsByUser().bind();
        ResultSet resultSet = this.execute((Statement)statement);
        return ConnectedClientStatsSummary.from(resultSet);
    }

    public Stream<ConnectedClientStats> stats() {
        Preconditions.checkState((boolean)((ConnectedClientsSchema)this.tableSchema).isInitialized(), () -> ((Object)((Object)((ConnectedClientsSchema)this.tableSchema))).getClass().getSimpleName() + " is not initialized yet");
        BoundStatement statement = ((ConnectedClientsSchema)this.tableSchema).stats().bind();
        ResultSet resultSet = this.execute((Statement)statement);
        return StreamSupport.stream(resultSet.spliterator(), false).map(ConnectedClientStats::from);
    }
}

