/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.types;

import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.spark.data.NativeType;
import org.apache.cassandra.spark.utils.RandomUtils;

public class TinyInt
extends NativeType {
    public static final TinyInt INSTANCE = new TinyInt();

    public String name() {
        return "tinyint";
    }

    @Override
    public AbstractType<?> dataType() {
        return ByteType.instance;
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return RandomUtils.randomBytes((int)1)[0];
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setByte(position, ((Byte)value).byteValue());
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.tinyint();
    }
}

