/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.types;

import java.util.stream.Collectors;
import org.apache.cassandra.cql3.functions.types.TupleType;
import org.apache.cassandra.cql3.functions.types.TupleValue;
import org.apache.cassandra.spark.data.CqlType;
import org.apache.cassandra.spark.data.complex.AbstractCqlTuple;
import org.apache.cassandra.transport.ProtocolVersion;
import org.jetbrains.annotations.NotNull;

public final class TupleHelper {
    private TupleHelper() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    @NotNull
    public static TupleType buildTupleType(AbstractCqlTuple tuple, boolean isFrozen) {
        return new TupleType(tuple.types().stream().map(type -> ((CqlType)type).driverDataType(isFrozen)).collect(Collectors.toList()), ProtocolVersion.V3, CqlType.CODEC_REGISTRY);
    }

    @NotNull
    public static TupleValue buildTupleValue(AbstractCqlTuple tuple) {
        return TupleHelper.buildTupleValue(tuple, false);
    }

    @NotNull
    public static TupleValue buildTupleValue(AbstractCqlTuple tuple, boolean isFrozen) {
        return new TupleValue(TupleHelper.buildTupleType(tuple, isFrozen));
    }
}

