/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import java.util.stream.IntStream;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.sparksql.CassandraInputPartition;
import org.apache.cassandra.spark.sparksql.PartitionSizeReaderFactory;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

class PartitionSizeScanBuilder
implements ScanBuilder,
Scan,
Batch {
    final DataLayer dataLayer;
    final StructType schema;
    final CaseInsensitiveStringMap options;

    PartitionSizeScanBuilder(DataLayer dataLayer, StructType schema, CaseInsensitiveStringMap options) {
        this.dataLayer = dataLayer;
        this.schema = schema;
        this.options = options;
    }

    public Scan build() {
        return this;
    }

    public StructType readSchema() {
        return this.schema;
    }

    public Batch toBatch() {
        return this;
    }

    public InputPartition[] planInputPartitions() {
        return (InputPartition[])IntStream.range(0, this.dataLayer.partitionCount()).mapToObj(CassandraInputPartition::new).toArray(InputPartition[]::new);
    }

    public PartitionReaderFactory createReaderFactory() {
        return new PartitionSizeReaderFactory(this.dataLayer);
    }
}

