/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.cassandra.spark.bulkwriter.DataTransportInfo;
import org.apache.cassandra.spark.bulkwriter.DigestAlgorithmSupplier;
import org.apache.cassandra.spark.bulkwriter.TokenPartitioner;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JobInfo {
    public ConsistencyLevel getConsistencyLevel();

    @Nullable
    public String getLocalDC();

    public int sstableDataSizeInMiB();

    public int getCommitBatchSize();

    public int getCommitThreadsPerInstance();

    public UUID getRestoreJobId();

    public UUID getRestoreJobId(@Nullable String var1) throws NoSuchElementException;

    @Nullable
    public String getConfiguredJobId();

    default public String getId() {
        String configuredJobId = this.getConfiguredJobId();
        return configuredJobId == null ? this.getRestoreJobId().toString() : configuredJobId;
    }

    public TokenPartitioner getTokenPartitioner();

    public boolean skipExtendedVerify();

    public boolean getSkipClean();

    @NotNull
    public DigestAlgorithmSupplier digestAlgorithmSupplier();

    public QualifiedTableName qualifiedTableName();

    public DataTransportInfo transportInfo();

    public int jobKeepAliveMinutes();

    public long jobTimeoutSeconds();

    public int effectiveSidecarPort();

    public double importCoordinatorTimeoutMultiplier();

    @Nullable
    public CoordinatedWriteConf coordinatedWriteConf();

    default public boolean isCoordinatedWriteEnabled() {
        return this.coordinatedWriteConf() != null;
    }
}

