/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import org.apache.cassandra.spark.bulkwriter.DataTransport;
import org.apache.cassandra.spark.bulkwriter.DataTransportInfo;
import org.apache.cassandra.spark.bulkwriter.DigestAlgorithmSupplier;
import org.apache.cassandra.spark.bulkwriter.DigestAlgorithms;
import org.apache.cassandra.spark.bulkwriter.TTLOption;
import org.apache.cassandra.spark.bulkwriter.TimestampOption;
import org.apache.cassandra.spark.bulkwriter.WriteMode;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.StorageClientConfig;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.util.SbwKryoRegistrator;
import org.apache.cassandra.spark.common.SidecarInstanceFactory;
import org.apache.cassandra.spark.utils.BuildInfo;
import org.apache.cassandra.spark.utils.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BulkSparkConf
implements Serializable {
    private static final long serialVersionUID = -5060973521517656241L;
    public static final String JDK11_OPTIONS = " -Djdk.attach.allowAttachSelf=true --add-exports java.base/jdk.internal.misc=ALL-UNNAMED --add-exports java.base/jdk.internal.ref=ALL-UNNAMED --add-exports java.base/sun.nio.ch=ALL-UNNAMED --add-exports java.management.rmi/com.sun.jmx.remote.internal.rmi=ALL-UNNAMED --add-exports java.rmi/sun.rmi.registry=ALL-UNNAMED --add-exports java.rmi/sun.rmi.server=ALL-UNNAMED --add-exports java.sql/java.sql=ALL-UNNAMED --add-opens java.base/java.lang.module=ALL-UNNAMED --add-opens java.base/jdk.internal.loader=ALL-UNNAMED --add-opens java.base/jdk.internal.ref=ALL-UNNAMED --add-opens java.base/jdk.internal.reflect=ALL-UNNAMED --add-opens java.base/jdk.internal.math=ALL-UNNAMED --add-opens java.base/jdk.internal.module=ALL-UNNAMED --add-opens java.base/jdk.internal.util.jar=ALL-UNNAMED --add-opens jdk.management/com.sun.management.internal=ALL-UNNAMED";
    public static final int DEFAULT_NUM_SPLITS = -1;
    public static final int DEFAULT_HTTP_CONNECTION_TIMEOUT = 100000;
    public static final int DEFAULT_HTTP_RESPONSE_TIMEOUT = 100000;
    public static final int DEFAULT_HTTP_MAX_CONNECTIONS = 25;
    public static final int DEFAULT_SIDECAR_PORT = 9043;
    public static final int DEFAULT_SIDECAR_REQUEST_RETRIES = 10;
    public static final long DEFAULT_SIDECAR_REQUEST_RETRY_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    public static final long DEFAULT_SIDECAR_REQUEST_MAX_RETRY_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    public static final int DEFAULT_SIDECAR_REQUEST_TIMEOUT_SECONDS = 300;
    public static final int DEFAULT_COMMIT_BATCH_SIZE = 10000;
    public static final int DEFAULT_RING_RETRY_COUNT = 3;
    public static final int DEFAULT_SSTABLE_DATA_SIZE_IN_MIB = 160;
    public static final long DEFAULT_STORAGE_CLIENT_KEEP_ALIVE_SECONDS = 60L;
    public static final int DEFAULT_STORAGE_CLIENT_CONCURRENCY = Runtime.getRuntime().availableProcessors() * 2;
    public static final int DEFAULT_STORAGE_CLIENT_MAX_CHUNK_SIZE_IN_BYTES = 0x6400000;
    private static final long DEFAULT_MAX_SIZE_PER_SSTABLE_BUNDLE_IN_BYTES_S3_TRANSPORT = 0x140000000L;
    public static final String SETTING_PREFIX = "spark.cassandra_analytics.";
    public static final String CASSANDRA_VERSION = "spark.cassandra_analytics.cassandra.version";
    public static final String HTTP_MAX_CONNECTIONS = "spark.cassandra_analytics.request.max_connections";
    public static final String HTTP_RESPONSE_TIMEOUT = "spark.cassandra_analytics.request.response_timeout";
    public static final String HTTP_CONNECTION_TIMEOUT = "spark.cassandra_analytics.request.connection_timeout";
    public static final String SIDECAR_PORT = "spark.cassandra_analytics.ports.sidecar";
    public static final String SIDECAR_REQUEST_RETRIES = "spark.cassandra_analytics.sidecar.request.retries";
    public static final String SIDECAR_REQUEST_RETRY_DELAY_MILLIS = "spark.cassandra_analytics.sidecar.request.retries.delay.milliseconds";
    public static final String SIDECAR_REQUEST_MAX_RETRY_DELAY_MILLIS = "spark.cassandra_analytics.sidecar.request.retries.max.delay.milliseconds";
    public static final String SIDECAR_REQUEST_TIMEOUT_SECONDS = "spark.cassandra_analytics.sidecar.request.timeout.seconds";
    public static final String SKIP_CLEAN = "spark.cassandra_analytics.job.skip_clean";
    public static final String USE_OPENSSL = "spark.cassandra_analytics.use_openssl";
    public static final String RING_RETRY_COUNT = "spark.cassandra_analytics.ring_retry_count";
    public static final String IMPORT_COORDINATOR_TIMEOUT_MULTIPLIER = "spark.cassandra_analytics.importCoordinatorTimeoutMultiplier";
    public static final int MINIMUM_JOB_KEEP_ALIVE_MINUTES = 10;
    public final String keyspace;
    public final String table;
    public final ConsistencyLevel.CL consistencyLevel;
    public final String localDC;
    public final Integer numberSplits;
    public final Integer sstableDataSizeInMiB;
    public final int commitBatchSize;
    public final boolean skipExtendedVerify;
    public final WriteMode writeMode;
    public final int commitThreadsPerInstance;
    public final double importCoordinatorTimeoutMultiplier;
    public boolean quoteIdentifiers;
    protected final String keystorePassword;
    protected final String keystorePath;
    protected final String keystoreBase64Encoded;
    protected final String keystoreType;
    protected final String cassandraRole;
    protected final String truststorePassword;
    protected final String truststorePath;
    protected final String truststoreBase64Encoded;
    protected final String truststoreType;
    protected final String ttl;
    protected final String timestamp;
    protected final SparkConf conf;
    protected final int effectiveSidecarPort;
    protected final int userProvidedSidecarPort;
    protected final DigestAlgorithmSupplier digestAlgorithmSupplier;
    protected final StorageClientConfig storageClientConfig;
    protected final DataTransportInfo dataTransportInfo;
    protected final int jobKeepAliveMinutes;
    protected final long jobTimeoutSeconds;
    protected final String configuredJobId;
    protected boolean useOpenSsl;
    protected int ringRetryCount;
    private final String sidecarContactPointsValue;
    private transient Set<SidecarInstance> sidecarContactPoints;
    protected final String coordinatedWriteConfJson;
    private transient CoordinatedWriteConf coordinatedWriteConf;

    public BulkSparkConf(SparkConf conf, Map<String, String> options) {
        this(conf, options, null);
    }

    public BulkSparkConf(SparkConf conf, Map<String, String> options, @Nullable Logger logger) {
        this.conf = conf;
        Optional sidecarPortFromOptions = MapUtils.getOptionalInt(options, (String)WriterOptions.SIDECAR_PORT.name(), (String)"sidecar port");
        this.userProvidedSidecarPort = sidecarPortFromOptions.isPresent() ? (Integer)sidecarPortFromOptions.get() : this.getOptionalInt(SIDECAR_PORT).orElse(-1);
        this.effectiveSidecarPort = this.userProvidedSidecarPort == -1 ? 9043 : this.userProvidedSidecarPort;
        this.sidecarContactPointsValue = BulkSparkConf.resolveSidecarContactPoints(options);
        this.keyspace = MapUtils.getOrThrow(options, (String)WriterOptions.KEYSPACE.name());
        this.table = MapUtils.getOrThrow(options, (String)WriterOptions.TABLE.name());
        this.skipExtendedVerify = MapUtils.getBoolean(options, (String)WriterOptions.SKIP_EXTENDED_VERIFY.name(), (boolean)true, (String)"skip extended verification of SSTables by Cassandra");
        this.consistencyLevel = ConsistencyLevel.CL.valueOf(MapUtils.getOrDefault(options, (String)WriterOptions.BULK_WRITER_CL.name(), (String)"EACH_QUORUM"));
        String dc = MapUtils.getOrDefault(options, (String)WriterOptions.LOCAL_DC.name(), null);
        if (!this.consistencyLevel.isLocal() && dc != null) {
            if (logger != null) {
                logger.warn("localDc is present for non-local consistency level {} specified in writer options. Correcting localDc to null", (Object)this.consistencyLevel);
            }
            dc = null;
        }
        this.localDC = dc;
        this.numberSplits = MapUtils.getInt(options, (String)WriterOptions.NUMBER_SPLITS.name(), (int)-1, (String)"number of splits");
        this.sstableDataSizeInMiB = BulkSparkConf.resolveSSTableDataSizeInMiB(options);
        this.commitBatchSize = MapUtils.getInt(options, (String)WriterOptions.COMMIT_BATCH_SIZE.name(), (int)10000, (String)"commit batch size");
        this.commitThreadsPerInstance = MapUtils.getInt(options, (String)WriterOptions.COMMIT_THREADS_PER_INSTANCE.name(), (int)2, (String)"commit threads per instance");
        this.keystorePassword = MapUtils.getOrDefault(options, (String)WriterOptions.KEYSTORE_PASSWORD.name(), null);
        this.keystorePath = MapUtils.getOrDefault(options, (String)WriterOptions.KEYSTORE_PATH.name(), null);
        this.keystoreBase64Encoded = MapUtils.getOrDefault(options, (String)WriterOptions.KEYSTORE_BASE64_ENCODED.name(), null);
        this.keystoreType = MapUtils.getOrDefault(options, (String)WriterOptions.KEYSTORE_TYPE.name(), (String)"PKCS12");
        this.cassandraRole = MapUtils.getOrDefault(options, (String)WriterOptions.CASSANDRA_ROLE.name(), null);
        this.truststorePassword = MapUtils.getOrDefault(options, (String)WriterOptions.TRUSTSTORE_PASSWORD.name(), null);
        this.truststorePath = MapUtils.getOrDefault(options, (String)WriterOptions.TRUSTSTORE_PATH.name(), null);
        this.truststoreBase64Encoded = MapUtils.getOrDefault(options, (String)WriterOptions.TRUSTSTORE_BASE64_ENCODED.name(), null);
        this.truststoreType = MapUtils.getOrDefault(options, (String)WriterOptions.TRUSTSTORE_TYPE.name(), null);
        this.writeMode = (WriteMode)MapUtils.getEnumOption(options, (String)WriterOptions.WRITE_MODE.name(), (Enum)WriteMode.INSERT, (String)"write mode");
        this.useOpenSsl = this.getBoolean(USE_OPENSSL, true);
        this.ringRetryCount = this.getInt(RING_RETRY_COUNT, 3);
        this.importCoordinatorTimeoutMultiplier = this.getDouble(IMPORT_COORDINATOR_TIMEOUT_MULTIPLIER, 0.5);
        this.ttl = MapUtils.getOrDefault(options, (String)WriterOptions.TTL.name(), null);
        this.timestamp = MapUtils.getOrDefault(options, (String)WriterOptions.TIMESTAMP.name(), null);
        this.quoteIdentifiers = MapUtils.getBoolean(options, (String)WriterOptions.QUOTE_IDENTIFIERS.name(), (boolean)false, (String)"quote identifiers");
        int storageClientConcurrency = MapUtils.getInt(options, (String)WriterOptions.STORAGE_CLIENT_CONCURRENCY.name(), (int)DEFAULT_STORAGE_CLIENT_CONCURRENCY, (String)"storage client concurrency");
        long storageClientKeepAliveSeconds = MapUtils.getLong(options, (String)WriterOptions.STORAGE_CLIENT_THREAD_KEEP_ALIVE_SECONDS.name(), (long)60L);
        int storageClientMaxChunkSizeInBytes = MapUtils.getInt(options, (String)WriterOptions.STORAGE_CLIENT_MAX_CHUNK_SIZE_IN_BYTES.name(), (int)0x6400000);
        String storageClientHttpsProxy = MapUtils.getOrDefault(options, (String)WriterOptions.STORAGE_CLIENT_HTTPS_PROXY.name(), null);
        String storageClientEndpointOverride = MapUtils.getOrDefault(options, (String)WriterOptions.STORAGE_CLIENT_ENDPOINT_OVERRIDE.name(), null);
        long nioHttpClientConnectionAcquisitionTimeoutSeconds = MapUtils.getLong(options, (String)WriterOptions.STORAGE_CLIENT_NIO_HTTP_CLIENT_CONNECTION_ACQUISITION_TIMEOUT_SECONDS.name(), (long)300L);
        int nioHttpClientMaxConcurrency = MapUtils.getInt(options, (String)WriterOptions.STORAGE_CLIENT_NIO_HTTP_CLIENT_MAX_CONCURRENCY.name(), (int)50);
        this.storageClientConfig = new StorageClientConfig(storageClientConcurrency, storageClientKeepAliveSeconds, storageClientMaxChunkSizeInBytes, storageClientHttpsProxy, storageClientEndpointOverride, nioHttpClientConnectionAcquisitionTimeoutSeconds, nioHttpClientMaxConcurrency);
        DataTransport dataTransport = (DataTransport)MapUtils.getEnumOption(options, (String)WriterOptions.DATA_TRANSPORT.name(), (Enum)DataTransport.DIRECT, (String)"Data Transport");
        long maxSizePerSSTableBundleInBytesS3Transport = MapUtils.getLong(options, (String)WriterOptions.MAX_SIZE_PER_SSTABLE_BUNDLE_IN_BYTES_S3_TRANSPORT.name(), (long)0x140000000L);
        String transportExtensionClass = MapUtils.getOrDefault(options, (String)WriterOptions.DATA_TRANSPORT_EXTENSION_CLASS.name(), null);
        this.dataTransportInfo = new DataTransportInfo(dataTransport, transportExtensionClass, maxSizePerSSTableBundleInBytesS3Transport);
        this.jobKeepAliveMinutes = MapUtils.getInt(options, (String)WriterOptions.JOB_KEEP_ALIVE_MINUTES.name(), (int)10);
        if (this.jobKeepAliveMinutes < 10) {
            throw new IllegalArgumentException(String.format("Invalid value for the '%s' Bulk Writer option (%d). It cannot be less than the minimum %s", WriterOptions.JOB_KEEP_ALIVE_MINUTES, this.jobKeepAliveMinutes, 10));
        }
        this.jobTimeoutSeconds = MapUtils.getLong(options, (String)WriterOptions.JOB_TIMEOUT_SECONDS.name(), (long)-1L);
        this.configuredJobId = MapUtils.getOrDefault(options, (String)WriterOptions.JOB_ID.name(), null);
        this.coordinatedWriteConfJson = MapUtils.getOrDefault(options, (String)WriterOptions.COORDINATED_WRITE_CONFIG.name(), null);
        this.coordinatedWriteConf = this.buildCoordinatedWriteConf(this.dataTransportInfo.getTransport(), logger);
        this.digestAlgorithmSupplier = this.digestAlgorithmSupplierFromOptions(dataTransport, options);
        this.validateEnvironment();
    }

    @NotNull
    protected DigestAlgorithmSupplier digestAlgorithmSupplierFromOptions(DataTransport dataTransport, Map<String, String> options) {
        if (dataTransport == DataTransport.S3_COMPAT) {
            return DigestAlgorithms.XXHASH32;
        }
        return (DigestAlgorithmSupplier)((Object)MapUtils.getEnumOption(options, (String)WriterOptions.DIGEST.name(), (Enum)DigestAlgorithms.XXHASH32, (String)"digest type"));
    }

    public static int resolveSSTableDataSizeInMiB(Map<String, String> options) {
        return (Integer)MapUtils.resolveDeprecated(options, (String)WriterOptions.SSTABLE_DATA_SIZE_IN_MIB.name(), (String)WriterOptions.SSTABLE_DATA_SIZE_IN_MB.name(), option -> {
            if (option == null) {
                return 160;
            }
            return MapUtils.getInt((Map)options, (String)option, (int)160, (String)"sstable data size in mebibytes");
        });
    }

    public static String resolveSidecarContactPoints(Map<String, String> options) {
        return (String)MapUtils.resolveDeprecated(options, (String)WriterOptions.SIDECAR_CONTACT_POINTS.name(), (String)WriterOptions.SIDECAR_INSTANCES.name(), option -> {
            if (option == null) {
                return null;
            }
            return MapUtils.getOrDefault((Map)options, (String)option, null);
        });
    }

    protected Set<SidecarInstance> buildSidecarContactPoints() {
        String[] split = Objects.requireNonNull(this.sidecarContactPointsValue, "Unable to build sidecar instances from null value").split(",");
        return Arrays.stream(split).filter(StringUtils::isNotEmpty).map(hostname -> SidecarInstanceFactory.createFromString(hostname, this.effectiveSidecarPort)).collect(Collectors.toSet());
    }

    Set<SidecarInstance> sidecarContactPoints() {
        if (this.sidecarContactPoints == null) {
            this.sidecarContactPoints = this.buildSidecarContactPoints();
        }
        return this.sidecarContactPoints;
    }

    public boolean isCoordinatedWriteConfigured() {
        return this.coordinatedWriteConf() != null;
    }

    public CoordinatedWriteConf coordinatedWriteConf() {
        if (this.coordinatedWriteConf == null) {
            this.coordinatedWriteConf = this.buildCoordinatedWriteConf(this.dataTransportInfo.getTransport(), null);
        }
        return this.coordinatedWriteConf;
    }

    @Nullable
    protected CoordinatedWriteConf buildCoordinatedWriteConf(DataTransport dataTransport, @Nullable Logger logger) {
        if (this.coordinatedWriteConfJson == null) {
            return null;
        }
        Preconditions.checkArgument((dataTransport == DataTransport.S3_COMPAT ? 1 : 0) != 0, (Object)("Coordinated write only supports " + String.valueOf(DataTransport.S3_COMPAT)));
        if (this.sidecarContactPointsValue != null && logger != null) {
            logger.warn("SIDECAR_CONTACT_POINTS or SIDECAR_INSTANCES are ignored on the presence of COORDINATED_WRITE_CONF");
        }
        if (this.userProvidedSidecarPort != -1 && logger != null) {
            logger.warn("SIDECAR_PORT is ignored on the presence of COORDINATED_WRITE_CONF");
        }
        if (this.localDC != null && logger != null) {
            logger.warn("LOCAL_DC is ignored on the presence of COORDINATED_WRITE_CONF");
        }
        return CoordinatedWriteConf.create(this.coordinatedWriteConfJson, this.consistencyLevel, CoordinatedWriteConf.SimpleClusterConf.class);
    }

    protected void validateEnvironment() throws RuntimeException {
        Preconditions.checkNotNull((Object)this.keyspace);
        Preconditions.checkNotNull((Object)this.table);
        Preconditions.checkArgument((this.getHttpResponseTimeoutMs() > 0 ? 1 : 0) != 0, (Object)"spark.cassandra_analytics.request.response_timeout must be > 0");
        this.validateSslConfiguration();
    }

    public void validateSslConfiguration() {
        if (this.getKeyStorePassword() != null && this.getKeyStorePath() == null && this.getKeystoreBase64Encoded() == null) {
            throw new NullPointerException("Keystore password was set. But both keystore path and base64 encoded string are not set. Please either set option " + String.valueOf(WriterOptions.KEYSTORE_PATH) + " or option " + String.valueOf(WriterOptions.KEYSTORE_BASE64_ENCODED));
        }
        if (this.getConfiguredTrustStorePassword() != null) {
            Preconditions.checkArgument((this.getTruststoreBase64Encoded() != null || this.getTrustStorePath() != null ? 1 : 0) != 0, (Object)("Trust Store password was provided, but both truststore path and base64 encoded string are missing. Please provide either option " + String.valueOf(WriterOptions.TRUSTSTORE_PATH) + " or option " + String.valueOf(WriterOptions.TRUSTSTORE_BASE64_ENCODED)));
        } else if (this.getTrustStorePath() != null || this.getTruststoreBase64Encoded() != null) {
            Preconditions.checkNotNull((Object)this.getTruststoreBase64Encoded(), (Object)("Trust Store Path was provided, but password is missing. Please provide option " + String.valueOf(WriterOptions.TRUSTSTORE_PASSWORD)));
            Preconditions.checkNotNull((Object)this.getTrustStorePath(), (Object)("Trust Store Base64 encoded was provided, but password is missing.Please provide option " + String.valueOf(WriterOptions.TRUSTSTORE_PASSWORD)));
        }
    }

    public int getUserProvidedSidecarPort() {
        return this.userProvidedSidecarPort;
    }

    public int getEffectiveSidecarPort() {
        return this.effectiveSidecarPort;
    }

    protected String getTrustStorePath() {
        return this.truststorePath;
    }

    public TTLOption getTTLOptions() {
        return TTLOption.from(this.ttl);
    }

    public TimestampOption getTimestampOptions() {
        return TimestampOption.from(this.timestamp);
    }

    protected String getTruststoreBase64Encoded() {
        return this.truststoreBase64Encoded;
    }

    public String getTrustStoreTypeOrDefault() {
        return this.truststoreType != null ? this.truststoreType : "PKCS12";
    }

    protected String getKeyStorePath() {
        return this.keystorePath;
    }

    protected String getKeystoreBase64Encoded() {
        return this.keystoreBase64Encoded;
    }

    public InputStream getKeyStore() {
        return this.getKeyStorePath() != null ? this.getKeyStoreFromPath(this.getKeyStorePath()) : this.getKeyStoreFromBase64EncodedString(this.getKeystoreBase64Encoded());
    }

    @Nullable
    public String getCassandraRole() {
        return this.cassandraRole;
    }

    @Nullable
    public InputStream getTrustStore() {
        return this.getTrustStorePath() != null ? this.getKeyStoreFromPath(this.getTrustStorePath()) : this.getKeyStoreFromBase64EncodedString(this.getTruststoreBase64Encoded());
    }

    protected InputStream getKeyStoreFromPath(String keyStorePath) {
        if (keyStorePath != null) {
            try {
                return new FileInputStream(keyStorePath);
            }
            catch (FileNotFoundException exception) {
                throw new RuntimeException("Could not load keystore at path '" + keyStorePath + "'", exception);
            }
        }
        return null;
    }

    protected InputStream getKeyStoreFromBase64EncodedString(String keyStoreBase64Encoded) {
        if (keyStoreBase64Encoded != null) {
            return new ByteArrayInputStream(Base64.getDecoder().decode(keyStoreBase64Encoded));
        }
        return null;
    }

    public String getTrustStorePasswordOrDefault() {
        return this.truststorePassword != null ? this.truststorePassword : "password";
    }

    public String getKeyStoreTypeOrDefault() {
        return this.keystoreType != null ? this.keystoreType : "PKCS12";
    }

    public String getKeyStorePassword() {
        return this.keystorePassword;
    }

    public String getConfiguredTrustStorePassword() {
        return this.truststorePassword;
    }

    public String getConfiguredKeyStorePassword() {
        return this.keystorePassword;
    }

    public int getSidecarRequestRetries() {
        return this.getInt(SIDECAR_REQUEST_RETRIES, 10);
    }

    public long getSidecarRequestRetryDelayMillis() {
        return this.getLong(SIDECAR_REQUEST_RETRY_DELAY_MILLIS, DEFAULT_SIDECAR_REQUEST_RETRY_DELAY_MILLIS);
    }

    public long getSidecarRequestMaxRetryDelayMillis() {
        return this.getLong(SIDECAR_REQUEST_MAX_RETRY_DELAY_MILLIS, DEFAULT_SIDECAR_REQUEST_MAX_RETRY_DELAY_MILLIS);
    }

    public int getSidecarRequestTimeoutSeconds() {
        return this.getInt(SIDECAR_REQUEST_TIMEOUT_SECONDS, 300);
    }

    public int getHttpConnectionTimeoutMs() {
        return this.getInt(HTTP_CONNECTION_TIMEOUT, 100000);
    }

    public int getHttpResponseTimeoutMs() {
        return this.getInt(HTTP_RESPONSE_TIMEOUT, 100000);
    }

    public int getMaxHttpConnections() {
        return this.getInt(HTTP_MAX_CONNECTIONS, 25);
    }

    public boolean getSkipClean() {
        return this.getBoolean(SKIP_CLEAN, false);
    }

    public Integer getCores() {
        int coresPerExecutor = this.conf.getInt("spark.executor.cores", 1);
        int numExecutors = this.conf.getInt("spark.dynamicAllocation.maxExecutors", this.conf.getInt("spark.executor.instances", 1));
        return coresPerExecutor * numExecutors;
    }

    public int getJobKeepAliveMinutes() {
        return this.jobKeepAliveMinutes;
    }

    public long getJobTimeoutSeconds() {
        return this.jobTimeoutSeconds;
    }

    protected double getDouble(String settingName, double defaultValue) {
        String finalSetting = this.getSettingNameOrDeprecatedName(settingName);
        return this.conf.getDouble(finalSetting, defaultValue);
    }

    protected int getInt(String settingName, int defaultValue) {
        String finalSetting = this.getSettingNameOrDeprecatedName(settingName);
        return this.conf.getInt(finalSetting, defaultValue);
    }

    protected Optional<Integer> getOptionalInt(String settingName) {
        String finalSetting = this.getSettingNameOrDeprecatedName(settingName);
        if (!this.conf.contains(finalSetting)) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(this.conf.get(finalSetting)));
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("Spark conf " + settingName + " is not set to a valid integer string.", exception);
        }
    }

    protected long getLong(String settingName, long defaultValue) {
        String finalSetting = this.getSettingNameOrDeprecatedName(settingName);
        return this.conf.getLong(finalSetting, defaultValue);
    }

    protected boolean getBoolean(String settingName, boolean defaultValue) {
        String finalSetting = this.getSettingNameOrDeprecatedName(settingName);
        return this.conf.getBoolean(finalSetting, defaultValue);
    }

    protected String getSettingNameOrDeprecatedName(String settingName) {
        if (!this.conf.contains(settingName)) {
            String settingSuffix = settingName.startsWith(SETTING_PREFIX) ? settingName.substring(SETTING_PREFIX.length()) : settingName;
            for (String settingPrefix : this.getDeprecatedSettingPrefixes()) {
                String deprecatedSetting = settingPrefix + settingSuffix;
                if (!this.conf.contains(deprecatedSetting)) continue;
                return deprecatedSetting;
            }
        }
        return settingName;
    }

    @NotNull
    protected List<String> getDeprecatedSettingPrefixes() {
        return Collections.emptyList();
    }

    public static void setupSparkConf(SparkConf conf, boolean addKryoRegistrator) {
        String previousOptions = conf.get("spark.executor.extraJavaOptions", "");
        if (BuildInfo.isAtLeastJava11((String)BuildInfo.javaSpecificationVersion())) {
            conf.set("spark.executor.extraJavaOptions", previousOptions + JDK11_OPTIONS);
        }
        if (addKryoRegistrator) {
            SbwKryoRegistrator.setupKryoRegistrator(conf);
        }
    }

    public SparkConf getSparkConf() {
        return this.conf;
    }

    public boolean getUseOpenSsl() {
        return this.useOpenSsl;
    }

    public int getRingRetryCount() {
        return this.ringRetryCount;
    }

    public StorageClientConfig getStorageClientConfig() {
        return this.storageClientConfig;
    }

    public DataTransportInfo getTransportInfo() {
        return this.dataTransportInfo;
    }

    public boolean hasKeystoreAndKeystorePassword() {
        return this.keystorePassword != null && (this.keystorePath != null || this.keystoreBase64Encoded != null);
    }

    public boolean hasTruststoreAndTruststorePassword() {
        return this.truststorePassword != null && (this.truststorePath != null || this.truststoreBase64Encoded != null);
    }
}

