/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.LongFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.streamhist.TombstoneHistogram;

public final class Util {
    public static final String ALLOW_TOOL_REINIT_FOR_TEST = Util.class.getName() + "ALLOW_TOOL_REINIT_FOR_TEST";
    static final String RESET = "\u001b[0m";
    static final String BLUE = "\u001b[34m";
    static final String CYAN = "\u001b[36m";
    static final String WHITE = "\u001b[37m";
    private static final List<String> ANSI_COLORS = Lists.newArrayList("\u001b[0m", "\u001b[34m", "\u001b[36m", "\u001b[37m");
    private static final String FULL_BAR_UNICODE = Strings.repeat("\u2593", 30);
    private static final String EMPTY_BAR_UNICODE = Strings.repeat("\u2591", 30);
    private static final String FULL_BAR_ASCII = Strings.repeat("#", 30);
    private static final String EMPTY_BAR_ASCII = Strings.repeat("-", 30);
    private static final TreeMap<Double, String> BARS_UNICODE = new TreeMap<Double, String>(){
        {
            this.put(1.0, "\u2589");
            this.put(0.875, "\u2589");
            this.put(0.75, "\u258a");
            this.put(0.625, "\u258b");
            this.put(0.375, "\u258d");
            this.put(0.25, "\u258e");
            this.put(0.125, "\u258f");
        }
    };
    private static final TreeMap<Double, String> BARS_ASCII = new TreeMap<Double, String>(){
        {
            this.put(1.0, "O");
            this.put(0.75, "o");
            this.put(0.3, ".");
        }
    };

    private static TreeMap<Double, String> barmap(boolean unicode) {
        return unicode ? BARS_UNICODE : BARS_ASCII;
    }

    public static String progress(double percentComplete, int width, boolean unicode) {
        assert (percentComplete >= 0.0 && percentComplete <= 1.0);
        int cols = (int)(percentComplete * (double)width);
        return (unicode ? FULL_BAR_UNICODE : FULL_BAR_ASCII).substring(width - cols) + (unicode ? EMPTY_BAR_UNICODE : EMPTY_BAR_ASCII).substring(cols);
    }

    public static String stripANSI(String string) {
        return ANSI_COLORS.stream().reduce(string, (a, b) -> a.replace((CharSequence)b, ""));
    }

    public static int countANSI(String string) {
        return string.length() - Util.stripANSI(string).length();
    }

    public static String wrapQuiet(String toWrap, boolean color) {
        if (Strings.isNullOrEmpty(toWrap)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (color) {
            sb.append(WHITE);
        }
        sb.append("(");
        sb.append(toWrap);
        sb.append(")");
        if (color) {
            sb.append(RESET);
        }
        return sb.toString();
    }

    private Util() {
    }

    public static void initDatabaseDescriptor() {
        try {
            DatabaseDescriptor.toolInitialization();
        }
        catch (Throwable e) {
            boolean logStackTrace = !(e instanceof ConfigurationException) || ((ConfigurationException)e).logStackTrace;
            System.out.println("Exception (" + e.getClass().getName() + ") encountered during startup: " + e.getMessage());
            if (logStackTrace) {
                e.printStackTrace();
                System.exit(3);
            }
            System.err.println(e.getMessage());
            System.exit(3);
        }
    }

    public static <T> Stream<T> iterToStream(Iterator<T> iter2) {
        Spliterator<T> splititer = Spliterators.spliteratorUnknownSize(iter2, 1024);
        return StreamSupport.stream(splititer, false);
    }

    public static TableMetadata metadataFromSSTable(Descriptor desc) throws IOException {
        if (desc.version.getVersion().compareTo("ma") < 0) {
            throw new IOException("pre-3.0 SSTable is not supported.");
        }
        EnumSet<MetadataType> types = EnumSet.of(MetadataType.STATS, MetadataType.HEADER);
        Map<MetadataType, MetadataComponent> sstableMetadata = desc.getMetadataSerializer().deserialize(desc, types);
        SerializationHeader.Component header = (SerializationHeader.Component)sstableMetadata.get((Object)MetadataType.HEADER);
        IPartitioner partitioner = FBUtilities.newPartitioner(desc);
        TableMetadata.Builder builder = TableMetadata.builder("keyspace", "table").partitioner(partitioner);
        header.getStaticColumns().entrySet().stream().forEach(entry -> {
            ColumnIdentifier ident = ColumnIdentifier.getInterned(UTF8Type.instance.getString((ByteBuffer)entry.getKey()), true);
            builder.addStaticColumn(ident, (AbstractType)entry.getValue());
        });
        header.getRegularColumns().entrySet().stream().forEach(entry -> {
            ColumnIdentifier ident = ColumnIdentifier.getInterned(UTF8Type.instance.getString((ByteBuffer)entry.getKey()), true);
            builder.addRegularColumn(ident, (AbstractType)entry.getValue());
        });
        builder.addPartitionKeyColumn("PartitionKey", header.getKeyType());
        for (int i = 0; i < header.getClusteringTypes().size(); ++i) {
            builder.addClusteringColumn("clustering" + (i > 0 ? Integer.valueOf(i) : ""), header.getClusteringTypes().get(i));
        }
        return builder.build();
    }

    public static class TermHistogram {
        public long max;
        public long min;
        public double sum;
        int maxCountLength = 5;
        int maxOffsetLength = 5;
        Map<? extends Number, Long> histogram;
        LongFunction<String> offsetName;
        LongFunction<String> countName;
        String title;

        public TermHistogram(Map<? extends Number, Long> histogram, String title, LongFunction<String> offsetName, LongFunction<String> countName) {
            this.offsetName = offsetName;
            this.countName = countName;
            this.histogram = histogram;
            this.title = title;
            this.maxOffsetLength = title.length();
            histogram.entrySet().stream().forEach(e -> {
                this.max = Math.max(this.max, (Long)e.getValue());
                this.min = Math.min(this.min, (Long)e.getValue());
                this.sum += (double)((Long)e.getValue()).longValue();
                this.maxCountLength = Math.max(this.maxCountLength, Util.stripANSI((String)countName.apply((Long)e.getValue())).length());
                this.maxOffsetLength = Math.max(this.maxOffsetLength, Util.stripANSI((String)offsetName.apply(((Number)e.getKey()).longValue())).length());
            });
        }

        public TermHistogram(final TombstoneHistogram histogram, String title, LongFunction<String> offsetName, LongFunction<String> countName) {
            this((Map<? extends Number, Long>)new TreeMap<Number, Long>(){
                {
                    histogram.forEach((int point, int value) -> this.put(point, Long.valueOf(value)));
                }
            }, title, offsetName, countName);
        }

        public TermHistogram(final EstimatedHistogram histogram, String title, LongFunction<String> offsetName, LongFunction<String> countName) {
            this((Map<? extends Number, Long>)new TreeMap<Number, Long>(){
                {
                    long[] counts = histogram.getBuckets(false);
                    long[] offsets = histogram.getBucketOffsets();
                    for (int i = 0; i < counts.length; ++i) {
                        long e = counts[i];
                        if (e <= 0L) continue;
                        this.put(offsets[i], e);
                    }
                }
            }, title, offsetName, countName);
        }

        public String bar(long count, int length, String color, boolean unicode) {
            if (color == null) {
                color = "";
            }
            StringBuilder sb = new StringBuilder(color);
            long barVal = count;
            int intWidth = (int)((double)barVal * 1.0 / (double)this.max * (double)length);
            double remainderWidth = (double)barVal * 1.0 / (double)this.max * (double)length - (double)intWidth;
            sb.append(Strings.repeat((String)Util.barmap(unicode).get(1.0), intWidth));
            if (Util.barmap(unicode).floorKey(remainderWidth) != null) {
                sb.append((String)Util.barmap(unicode).get(Util.barmap(unicode).floorKey(remainderWidth)));
            }
            if (!Strings.isNullOrEmpty(color)) {
                sb.append(Util.RESET);
            }
            return sb.toString();
        }

        public void printHistogram(PrintStream out, boolean color, boolean unicode) {
            int offsetTitleLength = color ? this.maxOffsetLength + Util.BLUE.length() : this.maxOffsetLength;
            out.printf("   %-" + offsetTitleLength + "s %s %-" + this.maxCountLength + "s  %s  %sHistogram%s %n", color ? Util.BLUE + this.title : this.title, color ? "\u001b[36m|\u001b[34m" : "|", "Count", Util.wrapQuiet("%", color), color ? Util.BLUE : "", color ? Util.RESET : "");
            this.histogram.entrySet().stream().forEach(e -> {
                String offset = this.offsetName.apply(((Number)e.getKey()).longValue());
                long count = (Long)e.getValue();
                String histo = this.bar(count, 30, color ? Util.WHITE : null, unicode);
                int mol2 = color ? this.maxOffsetLength + Util.countANSI(offset) : this.maxOffsetLength;
                int mcl = color ? this.maxCountLength + Util.countANSI(this.countName.apply(count)) : this.maxCountLength;
                out.printf("   %-" + mol2 + "s %s %" + mcl + "s %s %s%n", offset, color ? "\u001b[36m|\u001b[0m" : "|", this.countName.apply(count), Util.wrapQuiet(String.format("%3s", (int)(100.0 * ((double)count / this.sum))), color), histo);
            });
            EstimatedHistogram eh = new EstimatedHistogram(165);
            for (Map.Entry<? extends Number, Long> e2 : this.histogram.entrySet()) {
                eh.add(e2.getKey().longValue(), e2.getValue());
            }
            String[] percentiles = new String[]{"50th", "75th", "95th", "98th", "99th", "Min", "Max"};
            long[] data = new long[]{eh.percentile(0.5), eh.percentile(0.75), eh.percentile(0.95), eh.percentile(0.98), eh.percentile(0.99), eh.min(), eh.max()};
            out.println((color ? Util.BLUE : "") + "   Percentiles" + (color ? Util.RESET : ""));
            for (int i = 0; i < percentiles.length; ++i) {
                out.println(String.format("   %s%-10s%s%s", color ? Util.BLUE : "", percentiles[i], color ? Util.RESET : "", this.offsetName.apply(data[i])));
            }
        }
    }
}

