/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import com.codahale.metrics.Snapshot;
import com.google.common.base.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.reads.FixedSpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.PercentileSpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.SpeculativeRetryPolicy;

public class HybridSpeculativeRetryPolicy
implements SpeculativeRetryPolicy {
    private static final Pattern PATTERN = Pattern.compile("^(?<fun>MIN|MAX)\\((?<val1>[0-9.]+[a-z]+)\\s*,\\s*(?<val2>[0-9.]+[a-z]+)\\)$", 2);
    private final PercentileSpeculativeRetryPolicy percentilePolicy;
    private final FixedSpeculativeRetryPolicy fixedPolicy;
    private final Function function;

    HybridSpeculativeRetryPolicy(PercentileSpeculativeRetryPolicy percentilePolicy, FixedSpeculativeRetryPolicy fixedPolicy, Function function) {
        this.percentilePolicy = percentilePolicy;
        this.fixedPolicy = fixedPolicy;
        this.function = function;
    }

    @Override
    public long calculateThreshold(Snapshot latency, long existingValue) {
        if (latency.size() <= 0) {
            return existingValue;
        }
        return this.function.call(this.percentilePolicy.calculateThreshold(latency, existingValue), this.fixedPolicy.calculateThreshold(latency, existingValue));
    }

    @Override
    public SpeculativeRetryPolicy.Kind kind() {
        return SpeculativeRetryPolicy.Kind.HYBRID;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HybridSpeculativeRetryPolicy)) {
            return false;
        }
        HybridSpeculativeRetryPolicy rhs = (HybridSpeculativeRetryPolicy)obj;
        return this.function == rhs.function && Objects.equal(this.percentilePolicy, rhs.percentilePolicy) && Objects.equal(this.fixedPolicy, rhs.fixedPolicy);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.function, this.percentilePolicy, this.fixedPolicy});
    }

    public String toString() {
        return String.format("%s(%s,%s)", new Object[]{this.function, this.percentilePolicy, this.fixedPolicy});
    }

    static HybridSpeculativeRetryPolicy fromString(String str) {
        SpeculativeRetryPolicy value2;
        SpeculativeRetryPolicy value1;
        Matcher matcher = PATTERN.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        String val1 = matcher.group("val1");
        String val2 = matcher.group("val2");
        try {
            value1 = SpeculativeRetryPolicy.fromString(val1);
            value2 = SpeculativeRetryPolicy.fromString(val2);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException(String.format("Invalid value %s for option '%s'", new Object[]{str, TableParams.Option.SPECULATIVE_RETRY}));
        }
        if (value1.kind() == value2.kind()) {
            throw new ConfigurationException(String.format("Invalid value %s for option '%s': MIN()/MAX() arguments should be of different types, but both are of type %s", new Object[]{str, TableParams.Option.SPECULATIVE_RETRY, value1.kind()}));
        }
        SpeculativeRetryPolicy policy1 = value1 instanceof PercentileSpeculativeRetryPolicy ? value1 : value2;
        SpeculativeRetryPolicy policy2 = value1 instanceof FixedSpeculativeRetryPolicy ? value1 : value2;
        Function function = Function.valueOf(matcher.group("fun").toUpperCase());
        return new HybridSpeculativeRetryPolicy((PercentileSpeculativeRetryPolicy)policy1, (FixedSpeculativeRetryPolicy)policy2, function);
    }

    static boolean stringMatches(String str) {
        return PATTERN.matcher(str).matches();
    }

    public static enum Function {
        MIN,
        MAX;


        long call(long val1, long val2) {
            return this == MIN ? Math.min(val1, val2) : Math.max(val1, val2);
        }
    }
}

