/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadQuery;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.transform.RTBoundValidator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReadsListener;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;

public class PartitionRangeReadCommand
extends ReadCommand
implements PartitionRangeReadQuery {
    protected static final ReadCommand.SelectionDeserializer selectionDeserializer = new Deserializer();
    private final DataRange dataRange;

    @VisibleForTesting
    protected PartitionRangeReadCommand(boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange, IndexMetadata index) {
        super(ReadCommand.Kind.PARTITION_RANGE, isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, index);
        this.dataRange = dataRange;
    }

    public static PartitionRangeReadCommand create(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange) {
        return new PartitionRangeReadCommand(false, 0, false, metadata, nowInSec, columnFilter, rowFilter, limits, dataRange, PartitionRangeReadCommand.findIndex(metadata, rowFilter));
    }

    public static PartitionRangeReadCommand allDataRead(TableMetadata metadata, int nowInSec) {
        return new PartitionRangeReadCommand(false, 0, false, metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.NONE, DataLimits.NONE, DataRange.allData(metadata.partitioner), null);
    }

    @Override
    public DataRange dataRange() {
        return this.dataRange;
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter(DecoratedKey key) {
        return this.dataRange.clusteringIndexFilter(key);
    }

    public boolean isNamesQuery() {
        return this.dataRange.isNamesQuery();
    }

    public PartitionRangeReadCommand forSubRange(AbstractBounds<PartitionPosition> range, boolean isRangeContinuation) {
        return new PartitionRangeReadCommand(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), isRangeContinuation ? this.limits() : this.limits().withoutState(), this.dataRange().forSubRange(range), this.indexMetadata());
    }

    @Override
    public PartitionRangeReadCommand copy() {
        return new PartitionRangeReadCommand(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange(), this.indexMetadata());
    }

    @Override
    protected PartitionRangeReadCommand copyAsDigestQuery() {
        return new PartitionRangeReadCommand(true, this.digestVersion(), false, this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange(), this.indexMetadata());
    }

    @Override
    protected PartitionRangeReadCommand copyAsTransientQuery() {
        return new PartitionRangeReadCommand(false, 0, true, this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange(), this.indexMetadata());
    }

    @Override
    public PartitionRangeReadCommand withUpdatedLimit(DataLimits newLimits) {
        return new PartitionRangeReadCommand(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, this.dataRange(), this.indexMetadata());
    }

    @Override
    public PartitionRangeReadCommand withUpdatedLimitsAndDataRange(DataLimits newLimits, DataRange newDataRange) {
        return new PartitionRangeReadCommand(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, newDataRange, this.indexMetadata());
    }

    @Override
    public long getTimeout(TimeUnit unit) {
        return DatabaseDescriptor.getRangeRpcTimeout(unit);
    }

    @Override
    public boolean isReversed() {
        return this.dataRange.isReversed();
    }

    @Override
    public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState, long queryStartNanoTime) throws RequestExecutionException {
        return StorageProxy.getRangeSlice(this, consistency, queryStartNanoTime);
    }

    @Override
    protected void recordLatency(TableMetrics metric, long latencyNanos) {
        metric.rangeLatency.addNano(latencyNanos);
    }

    @Override
    @VisibleForTesting
    public UnfilteredPartitionIterator queryStorage(ColumnFamilyStore cfs, ReadExecutionController controller) {
        ColumnFamilyStore.ViewFragment view = cfs.select(View.selectLive(this.dataRange().keyRange()));
        Tracing.trace("Executing seq scan across {} sstables for {}", (Object)view.sstables.size(), (Object)this.dataRange().keyRange().getString(this.metadata().partitionKeyType));
        ReadCommand.InputCollector<UnfilteredPartitionIterator> inputCollector = this.iteratorsForRange(view, controller);
        try {
            for (Memtable memtable : view.memtables) {
                Memtable.MemtableUnfilteredPartitionIterator iter2 = memtable.makePartitionIterator(this.columnFilter(), this.dataRange());
                controller.updateMinOldestUnrepairedTombstone(iter2.getMinLocalDeletionTime());
                inputCollector.addMemtableIterator(RTBoundValidator.validate(iter2, RTBoundValidator.Stage.MEMTABLE, false));
            }
            SSTableReadsListener readCountUpdater = PartitionRangeReadCommand.newReadCountUpdater();
            for (SSTableReader sstable : view.sstables) {
                ISSTableScanner iter3 = sstable.getScanner(this.columnFilter(), this.dataRange(), readCountUpdater);
                inputCollector.addSSTableIterator(sstable, RTBoundValidator.validate(iter3, RTBoundValidator.Stage.SSTABLE, false));
                if (sstable.isRepaired()) continue;
                controller.updateMinOldestUnrepairedTombstone(sstable.getMinLocalDeletionTime());
            }
            if (inputCollector.isEmpty()) {
                return EmptyIterators.unfilteredPartition(this.metadata());
            }
            return this.checkCacheFilter(UnfilteredPartitionIterators.mergeLazily(inputCollector.finalizeIterators(cfs, this.nowInSec(), controller.oldestUnrepairedTombstone())), cfs);
        }
        catch (Error | RuntimeException e) {
            try {
                inputCollector.close();
            }
            catch (Exception exception) {
                e.addSuppressed(exception);
            }
            throw e;
        }
    }

    private static SSTableReadsListener newReadCountUpdater() {
        return new SSTableReadsListener(){

            @Override
            public void onScanningStarted(SSTableReader sstable) {
                sstable.incrementReadCount();
            }
        };
    }

    private UnfilteredPartitionIterator checkCacheFilter(UnfilteredPartitionIterator iter2, final ColumnFamilyStore cfs) {
        class CacheFilter
        extends Transformation<BaseRowIterator<?>> {
            CacheFilter() {
            }

            @Override
            public BaseRowIterator<?> applyToPartition(BaseRowIterator<?> iter2) {
                DecoratedKey dk = iter2.partitionKey();
                CachedPartition cached = cfs.getRawCachedPartition(dk);
                ClusteringIndexFilter filter = PartitionRangeReadCommand.this.dataRange().clusteringIndexFilter(dk);
                if (cached != null && cfs.isFilterFullyCoveredBy(filter, PartitionRangeReadCommand.this.limits(), cached, PartitionRangeReadCommand.this.nowInSec(), iter2.metadata().enforceStrictLiveness())) {
                    iter2.close();
                    return filter.getUnfilteredRowIterator(PartitionRangeReadCommand.this.columnFilter(), cached);
                }
                return iter2;
            }
        }
        return Transformation.apply(iter2, new CacheFilter());
    }

    @Override
    public Verb verb() {
        return Verb.RANGE_REQ;
    }

    @Override
    protected void appendCQLWhereClause(StringBuilder sb) {
        if (this.dataRange.isUnrestricted() && this.rowFilter().isEmpty()) {
            return;
        }
        sb.append(" WHERE ");
        if (!this.rowFilter().isEmpty()) {
            sb.append(this.rowFilter());
            if (!this.dataRange.isUnrestricted()) {
                sb.append(" AND ");
            }
        }
        if (!this.dataRange.isUnrestricted()) {
            sb.append(this.dataRange.toCQLString(this.metadata()));
        }
    }

    public PartitionIterator postReconciliationProcessing(PartitionIterator result) {
        ColumnFamilyStore cfs = Keyspace.open(this.metadata().keyspace).getColumnFamilyStore(this.metadata().name);
        Index index = this.getIndex(cfs);
        return index == null ? result : index.postProcessorFor(this).apply(result, this);
    }

    public String toString() {
        return String.format("Read(%s columns=%s rowfilter=%s limits=%s %s)", this.metadata().toString(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange().toString(this.metadata()));
    }

    @Override
    protected void serializeSelection(DataOutputPlus out, int version) throws IOException {
        DataRange.serializer.serialize(this.dataRange(), out, version, this.metadata());
    }

    @Override
    protected long selectionSerializedSize(int version) {
        return DataRange.serializer.serializedSize(this.dataRange(), version, this.metadata());
    }

    @Override
    public boolean isLimitedToOnePartition() {
        return this.dataRange.keyRange instanceof Bounds && this.dataRange.startKey().kind() == PartitionPosition.Kind.ROW_KEY && this.dataRange.startKey().equals(this.dataRange.stopKey());
    }

    @Override
    public boolean isRangeRequest() {
        return true;
    }

    private static class Deserializer
    extends ReadCommand.SelectionDeserializer {
        private Deserializer() {
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version, boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, IndexMetadata index) throws IOException {
            DataRange range = DataRange.serializer.deserialize(in, version, metadata);
            return new PartitionRangeReadCommand(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, range, index);
        }
    }
}

