/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate.values;

import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.stress.generate.FasterRandom;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.stress.generate.values.GeneratorConfig;

public class Strings
extends Generator<String> {
    private final char[] chars;
    private final FasterRandom rnd = new FasterRandom();

    public Strings(String name, GeneratorConfig config) {
        super((AbstractType<?>)UTF8Type.instance, config, name, String.class);
        this.chars = new char[(int)this.sizeDistribution.maxValue()];
    }

    @Override
    public String generate() {
        long seed = this.identityDistribution.next();
        this.sizeDistribution.setSeed(seed);
        this.rnd.setSeed(seed ^ 0xFFFFFFFFFFFFFFFFL);
        int size = (int)this.sizeDistribution.next();
        int i = 0;
        while (i < size) {
            long v = this.rnd.nextLong();
            long n = Math.min(size - i, 8);
            while (n-- > 0L) {
                this.chars[i++] = (char)((v & 0x7FL) + 32L & 0x7FL);
                v >>= 8;
            }
        }
        return new String(this.chars, 0, size);
    }
}

